<?php include 'includes/topbar.php'; ?>
<?php include 'includes/navbar.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Global Measure Malawi</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />
  <style>
  html {
    scroll-behavior: smooth;
  }

  body, html {
    margin: 0;
    padding: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  }

  /* Hero Carousel */
  .slide-wrapper {
    height: 100vh;
  }

  .slide-image {
    width: 100%;
    height: 100vh;
    object-fit: cover;
    background-color: #000;
  }

  .slide-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 2;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .slide-overlay .container {
    padding: 1rem;
  }

  .navbar-brand img {
    max-height: 50px;
  }

  .hero {
    position: relative;
    margin-top: 0 !important;
    padding-top: 0 !important;
  }

  section {
    padding: 60px 0;
  }

  .footer {
    background-color: #222;
    color: #bbb;
    padding: 20px 0;
  }

  .footer a {
    color: #bbb;
    text-decoration: none;
  }

  .footer a:hover {
    color: #fff;
  }

  .navbar-light .navbar-nav .nav-link {
    color: #333;
  }

  .navbar-light .navbar-nav .nav-link:hover {
    color: #007bff;
  }
  
  .partner-scroll-container {
  display: flex;
  gap: 1.5rem;
  overflow-x: auto;
  padding: 1rem 0;
  scroll-snap-type: x mandatory;
}

.partner-card {
  flex: 0 0 auto;
  width: 220px;
  min-height: 250px;
  background: white;
  border-radius: 8px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.1);
  text-align: center;
  padding: 1rem;
  scroll-snap-align: start;
}
.partner-logo {
  max-height: 400px;
  width: auto;
  object-fit: contain;
  margin: 0 auto;
  display: block;
}


.partner-card h6 {
  margin-bottom: 0.5rem;
  font-weight: 600;
  color: #007bff;
}

.partner-card p {
  margin: 0;
  font-size: 0.875rem;
  color: #555;
}

.card {
  min-height: 260px;
  border: none;
  border-radius: 10px;
}
.card h6 {
  font-weight: 600;
}
.card p {
  font-size: 0.9rem;
  color: #555;
}
.bg-light-blue {
  background-color: #e3f2fc;
}


</style>
</head>
<body>

<section id="hero" class="hero">
  <div id="heroCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel">
    
    <!-- Indicators -->
    <div class="carousel-indicators">
      <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active" aria-label="Slide 1"></button>
      <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1" aria-label="Slide 2"></button>
      <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2" aria-label="Slide 3"></button>
    </div>

    <!-- Slides -->
    <div class="carousel-inner">
      <div class="carousel-item active">
        <div class="position-relative slide-wrapper">
          <img src="images/49027795122_e58a97681c_o-scaled.jpg" class="slide-image" alt="Empowering Smallholder Farmers" />
          <div class="slide-overlay">
            <div class="container text-center text-white">
              <h1 class="display-4">Partnering Smallholder Farmers for Greater Success</h1>
              <p class="lead">Sustainable Trade Ecosystems for lasting impact.</p>
              <a href="about_us.php" class="btn btn-primary btn-lg mt-3">Learn More</a>
            </div>
          </div>
        </div>
      </div>
      <div class="carousel-item">
        <div class="position-relative slide-wrapper">
          <img src="images/AdobeStock_147024160.jpeg" class="slide-image" alt="Linking Farmers to Opportunities" />
          <div class="slide-overlay">
            <div class="container text-center text-white">
              <h1 class="display-4">Linking Farmers to Opportunities</h1>
              <p class="lead">TESH helps build value-chain partnerships that last.</p>
              <a href="products.php" class="btn btn-primary btn-lg mt-3">Our Products</a>
            </div>
          </div>
        </div>
      </div>
      <div class="carousel-item">
        <div class="position-relative slide-wrapper">
          <img src="images/gi-malawi-data.jpg" class="slide-image" alt="Innovative Rural Development" />
          <div class="slide-overlay">
            <div class="container text-center text-white">
              <h1 class="display-4">Innovative Rural Development</h1>
              <p class="lead">Driven by data, partnerships, and grassroots innovation.</p>
              <a href="contact.php" class="btn btn-primary btn-lg mt-3">Get in Touch</a>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Next</span>
    </button>
  </div>
</section>


  <section id="about" class="bg-light py-5">
  <div class="container">
    <!-- About Content -->
    <div class="row align-items-center mb-5">
      <div class="col-lg-6 mb-4 mb-lg-0">
        <img src="images/IMG_1720-scaled.webp" alt="Smallholder Farmers" class="img-fluid rounded shadow">
      </div>
      <div class="col-lg-6">
        <h2 class="mb-3">About Global Measure Malawi</h2>
        <p><strong>Global Measure Malawi Limited (GMM)</strong> supports the development of sustainable Trade Ecosystems that foster mutually beneficial partnerships between smallholder farmers and key stakeholders across on-farm, off-farm, and non-farm value chains in rural Malawi.</p>
        <p>Through the <strong>Trade Ecosystem for Smallholder Farmers (TESH)</strong> model, GMM connects organized farmer groups with relevant partners to drive inclusive business opportunities. Since its inception, GMM has indirectly supported over <strong>50,000 rural Malawians</strong>, enhancing food and income security.</p>
        <p>TESH is currently active in Lilongwe, Ntchisi, Zomba, and Thyolo districts, reaching over <strong>3,500 direct beneficiaries</strong> with access to genuine improved seed inputs at the community level. Demand for expansion continues to grow across new areas.</p>
        <p>GMM is guided by strong principles: <em>integrity</em>, <em>value innovation</em>, <em>quality service delivery</em>, <em>collaboration</em>, and a deep <em>commitment to community responsibility</em>.</p>
      </div>
    </div>

    <!-- Vision, Mission, Clarion Call -->
    <div class="row text-center">
      <div class="col-md-4 mb-4">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="mb-2">
            <i class="fas fa-eye fa-2x text-primary"></i>
          </div>
          <h5 class="fw-bold">Vision</h5>
          <p class="mb-0">Every Malawian household visible, connected, thriving, and growing incomes.</p>
        </div>
      </div>

      <div class="col-md-4 mb-4">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="mb-2">
            <i class="fas fa-bullseye fa-2x text-success"></i>
          </div>
          <h5 class="fw-bold">Mission</h5>
          <p class="mb-0">GMM provides new emerging opportunities for efficiency in trade and services for low-income communities across Malawi.</p>
        </div>
      </div>

      <div class="col-md-4 mb-4">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="mb-2">
            <i class="fas fa-flag fa-2x text-danger"></i>
          </div>
          <h5 class="fw-bold">Clarion Call</h5>
          <p class="mb-0">Waging trade in Malawi.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="offerings" class="bg-light-blue py-5">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold">What We Offer</h2>
      <p class="lead text-muted">Empowering agriculture through products, services, and innovation.</p>
    </div>
    
    <div class="row g-4">
      <!-- Certified Seeds -->
      <div class="col-md-6 col-lg-6">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="d-flex align-items-start mb-3">
            <i class="fas fa-seedling fa-2x text-primary me-3"></i>
            <h5 class="mb-0">Certified Seeds on Credit</h5>
          </div>
          <p>We provide certified high-yield seeds to smallholder farmers on affordable, consumer-friendly credit, boosting access and productivity.</p>
        </div>
      </div>

      <!-- Solar Products -->
      <div class="col-md-6 col-lg-6">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="d-flex align-items-start mb-3">
            <i class="fas fa-solar-panel fa-2x text-warning me-3"></i>
            <h5 class="mb-0">Green Energy Solutions</h5>
          </div>
          <p>Our solar-powered equipment helps reduce costs and environmental impact, offering energy independence and sustainability for farmers.</p>
        </div>
      </div>

      <!-- Market Research -->
      <div class="col-md-6 col-lg-6">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="d-flex align-items-start mb-3">
            <i class="fas fa-chart-line fa-2x text-success me-3"></i>
            <h5 class="mb-0">Market Research & Value Chain Analysis</h5>
          </div>
          <p>We deliver detailed market research and value chain assessments to guide data-driven decision-making for clients and stakeholders.</p>
        </div>
      </div>

      <!-- Digital Platforms -->
      <div class="col-md-6 col-lg-6">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="d-flex align-items-start mb-3">
            <i class="fas fa-mobile-alt fa-2x text-info me-3"></i>
            <h5 class="mb-0">Tailor-Made Digital Platforms</h5>
          </div>
          <p>We design smart and feature-phone compatible applications and websites that streamline operations and enhance customer engagement.</p>
        </div>
      </div>

      <!-- Partnership -->
      <div class="col-12">
        <div class="p-4 h-100 shadow-sm bg-white rounded">
          <div class="d-flex align-items-start mb-3">
            <i class="fas fa-handshake fa-2x text-secondary me-3"></i>
            <h5 class="mb-0">Flexible Strategic Partnerships</h5>
          </div>
          <p>GMM collaborates as a consortium lead, co-implementer, sub-guarantee, or last-mile distributor, offering agile development and business support solutions.</p>
        </div>
      </div>
    </div>

    <!-- CTA Button to Products and Services Page -->
    <div class="text-center mt-4">
      <a href="products.php" class="btn btn-primary btn-lg">Explore Our Products & Services</a>
    </div>
  </div>
</section>

<section class="container my-5">
  <div class="row align-items-stretch" style="min-height: 400px;">
    <!-- Map -->
    <div class="col-md-6 p-0">
      <iframe
       src="https://www.google.com/maps/embed?pb=!1m17!1m12!1m3!1d3872.122126108089!2d33.76335507509392!3d-13.95133318646167!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m2!1m1!2zMTPCsDU3JzA0LjgiUyAzM8KwNDUnNTcuNCJF!5e0!3m2!1sen!2smw!4v1747911037395!5m2!1sen!2smw"
        width="100%"
        height="100%"
        style="border:0;"
        allowfullscreen=""
        loading="lazy"
        class="h-100 w-100"
      ></iframe>
    </div>

    <!-- Contact Form -->
    <div class="col-md-6 bg-light d-flex align-items-center">
      <form class="w-100 p-4">
        <div class="mb-3">
          <label for="subject" class="form-label">Subject</label>
          <input type="text" class="form-control" id="subject" name="subject" required>
        </div>
        <div class="mb-3">
          <label for="email" class="form-label">Email</label>
          <input type="email" class="form-control" id="email" name="email" required>
        </div>
        <div class="mb-3">
          <label for="message" class="form-label">Message</label>
          <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Send</button>
      </form>
    </div>
  </div>
</section>


<section id="partners" class="bg-light py-5">
  <div class="container">
    <div class="text-center mb-5">
      <h2>Our Partners</h2>
      <p class="lead">We work with top organizations to support smallholder farmers across Malawi.</p>
    </div>

    <div id="partnersCarousel" class="carousel slide" data-bs-ride="carousel">
      <div class="carousel-inner">

        <!-- Slide 1 -->
        <div class="carousel-item active">
          <div class="row text-center">
            <div class="col-md-4">
              <div class="card shadow-sm p-3">
                <img src="images/global-seeds.png" class="partner-logo mb-3" alt="Global Seeds" style="max-height: 60px;">
                <h6 class="text-primary">Global Seeds</h6>
                <p class="small">Provides improved seeds for drought-tolerant crops and vegetables in Malawi.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="card shadow-sm p-3">
                <img src="images/Sun-King-Logo-01.png" class="partner-logo mb-3" alt="Sun King" style="max-height: 60px;">
                <h6 class="text-primary">Sun King</h6>
                <p class="small">Delivers off-grid solar energy systems for lighting and productivity.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="card shadow-sm p-3">
                <img src="images/cic-africa.png" class="partner-logo mb-3" alt="CIC Malawi" style="max-height: 60px;">
                <h6 class="text-primary">CIC General Malawi</h6>
                <p class="small">Provides agricultural insurance to protect crops from natural risks.</p>
              </div>
            </div>
          </div>
        </div>

        <!-- Slide 2 -->
        <div class="carousel-item">
          <div class="row text-center">
            <div class="col-md-4">
              <div class="card shadow-sm p-3">
                <img src="images/uptrade.webp" class="partner-logo mb-3" alt="Uptread" style="max-height: 60px;">
                <h6 class="text-primary">Uptread Dealers</h6>
                <p class="small">Manufacturers of Gold Organic Fertilizer supporting eco-farming.</p>
              </div>
            </div>
            
          </div>
        </div>

      </div>

      <!-- Carousel controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#partnersCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
        <span class="visually-hidden">Previous</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#partnersCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
        <span class="visually-hidden">Next</span>
      </button>
    </div>
  </div>
</section>

<?php include 'includes/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
