<?php
header('Content-Type: application/json');
include_once 'model/services_model.php';

$data = json_decode(file_get_contents('php://input'), true);
if(empty($data['service_code'])){
    echo json_encode(['success' => false, 'message' => 'Missing service code']);
    exit;
}

$service_code = $data['service_code'];
$services_model = new services_model();

try {
    $result = $services_model->softDeleteService($service_code);
    if($result){
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update service state']);
    }
} catch(Exception $e){
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
