<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Contact Us | Golden Buddha Spa</title>
  <meta name="description" content="Golden Buddha Spa - Your destination for peace, healing, and rejuvenation in Blantyre.">
  <meta property="og:title" content="Golden Buddha Spa" />
  <meta property="og:description" content="Book a massage, relax, and rejuvenate at our peaceful spa." />
  <meta property="og:image" content="images/logo-tr.png" />
  <link rel="icon" type="image/png" href="images/logo-tr.png" />

  <!-- Bootstrap & Google Fonts -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500&family=Open+Sans&display=swap" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <link rel="stylesheet" href="css/style.css">

  <style>
    .contact-logo {
  max-width: 280px;
  margin-bottom: 1.5rem;
  display: block;
}

.map-fullwidth-wrapper {
  width: 100vw;
  position: relative;
  left: 50%;
  right: 50%;
  margin-left: -50vw;
  margin-right: -50vw;
  height: 550px;
  overflow: hidden;
  border-radius: 10px 10px 0 0;
  box-shadow: 0 4px 12px rgb(0 0 0 / 0.15);
  margin-top: 3rem;
}

.map-fullwidth-wrapper iframe {
  width: 100%;
  height: 100%;
  border: none;
}

/* Responsive tweaks */
@media (max-width: 767.98px) {
  .contact-info a {
    font-size: 1rem;
  }
  .btn-gold {
    width: 100%;
  }
}
.btn-gold {
  background-color: #b9975b;
  color: #fff;
  border: none;
  padding: 10px 28px;
  font-weight: 700;
  border-radius: 6px;
  transition: background-color 0.3s ease;
}

.btn-gold:hover,
.btn-gold:focus {
  background-color: #8c7642;
  color: #fff;
  box-shadow: 0 0 8px rgba(141, 118, 66, 0.7);
}
    </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<!-- Parallax Contact Header -->
<section class="parallax-about w-100">
  <div class="parallax-overlay text-center text-white py-5">
    <h2 class="mb-4 text-gold">Contact Golden Buddha Spa</h2>
    <p class="lead">We'd love to hear from you. Reach out or visit us today.</p>
  </div>
</section>

<!-- Contact Us Section -->
<section id="contact" class="py-5" style="background-color: #f9f9f9;">
  <div class="container">
    <div class="row g-0 shadow rounded overflow-hidden bg-white">
      
      <!-- Left: Contact Info -->
      <div class="col-md-6 p-5 d-flex flex-column justify-content-center bg-white border-end">
        <div class="mb-4">
          <img src="images/logo-tr.png" alt="Golden Buddha Spa Logo" class="img-fluid mb-3" style="max-height: 100px;">
          <h4 class="text-gold">Golden Buddha Spa</h4>
        </div>
        <ul class="list-unstyled">
          <li class="mb-3 d-flex align-items-center">
            <i class="fas fa-phone-alt text-gold me-3"></i>
            <span>+27 65 555 5577</span>
          </li>
          <li class="mb-3 d-flex align-items-center">
            <i class="fab fa-whatsapp text-success me-3"></i>
            <span>+27 71 155 3577</span>
          </li>
          <li class="mb-3 d-flex align-items-center">
            <i class="fas fa-envelope text-gold me-3"></i>
            <span>info@goldenbuddhaspa.co.za</span>
          </li>
          <li class="mb-3 d-flex align-items-center">
            <i class="fas fa-map-marker-alt text-danger me-3"></i>
            <span>90 Blairegowrie, Randburg</span>
          </li>
        </ul>
      </div>

      <!-- Right: Contact Form -->
      <div class="col-md-6 bg-light p-5">
        <h4 class="mb-4 text-gold">Send Us a Message</h4>
        <form>
          <div class="mb-3">
            <input type="text" class="form-control" placeholder="Your Name" required>
          </div>
          <div class="mb-3">
            <input type="email" class="form-control" placeholder="Your Email" required>
          </div>
          <div class="mb-3">
            <textarea class="form-control" rows="5" placeholder="Your Message" required></textarea>
          </div>
          <button type="submit" class="btn btn-gold px-4 py-2 mt-2">Send Message</button>
        </form>
      </div>

    </div>
  </div>
</section>



<!-- Full-width Google Map -->
<section class="map-fullwidth-wrapper" data-aos="fade-up">
  <iframe
    src="https://www.google.com/maps?q=Golden+Buddha+Spa+91+Blairegowrie+Randburg+South+Africa&output=embed"
    allowfullscreen=""
    loading="lazy"
    referrerpolicy="no-referrer-when-downgrade"
  ></iframe>
</section>

<?php include 'footer.php'; ?>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
<script>
  AOS.init({
    duration: 2000,
    once: true
  });
</script>

</body>
</html>
