<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Our Services | Golden Buddha Spa</title>
  <meta name="description" content="Discover our massage and spa services designed to rejuvenate your body and mind.">
  <meta property="og:title" content="Golden Buddha Spa Services" />
  <meta property="og:description" content="Explore a range of premium spa services including massage therapies, facials, and body treatments." />
  <meta property="og:image" content="images/logo-tr.png" />
  <link rel="icon" type="image/png" href="images/logo-tr.png" />

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500&family=Open+Sans&display=swap" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <link rel="stylesheet" href="css/style.css">

  <style>
    body {
      font-family: 'Open Sans', sans-serif;
      background-color: #fdf8f5;
      color: #4a4a4a;
    }
    h2.text-gold, .card-title.text-gold {
      color: #bfa14f;
      font-family: 'Playfair Display', serif;
    }
    .card {
      border-radius: 12px;
      transition: transform 0.3s ease;
    }
    .card:hover {
      transform: translateY(-8px);
      box-shadow: 0 10px 25px rgba(191,161,79,0.3);
    }
    .carousel-control-prev-icon,
    .carousel-control-next-icon {
      filter: invert(40%) sepia(96%) saturate(669%) hue-rotate(4deg) brightness(91%) contrast(91%);
    }
    /* Hide Bootstrap grid on mobile to show carousel instead */
    @media (max-width: 767.98px) {
      #services-grid {
        display: none;
      }
    }
    /* Hide carousel on desktop/tablet */
    @media (min-width: 768px) {
      #services-carousel {
        display: none;
      }
    }

    .services-header-parallax {
  position: relative;
  height: 450px; /* Adjust height as needed */
  background-image: url('images/spa-bg.jpg'); /* Replace with your own spa-themed image */
  background-size: cover;
  background-position: center;
  background-attachment: fixed;
  /* fallback for mobile (background-attachment: fixed isn't supported well on iOS) */
  background-repeat: no-repeat;
  z-index: 1;
}

.services-header-parallax .overlay {
  position: absolute;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: rgba(0, 0, 0, 0.4); /* dark overlay for text contrast */
  z-index: 0;
}

.services-header-parallax h2,
.services-header-parallax p {
  position: relative;
  z-index: 1;
  max-width: 700px;
}
.text-gold { color: #c49b63; }
  .btn-gold {
    background-color: #c49b63;
    color: #fff;
    border: none;
  }
  .btn-gold:hover {
    background-color: #b78b55;
  }
  .swiper {
    padding-bottom: 30px;
  }
  .swiper-slide {
    width: 85%;
  }
  @media (min-width: 768px) {
    .swiper-slide {
      width: auto;
    }
  }

  </style>
  <style>
.card-img-top {
  height: 200px; /* or whatever consistent height you want */
  object-fit: cover;
}
</style>

</head>
<body>

<?php 

  include 'navbar.php'; 
  include_once 'model/service_model.php';

  $service_model = new service_model();

  $services = $service_model->getServices();
?>

<section class="services-header-parallax text-center text-white d-flex flex-column justify-content-center align-items-center mb-5" data-aos="fade-up">
  <div class="overlay"></div>
  <h2 class="text-gold display-4 fw-bold">Our Services</h2>
  <p class="fs-5 px-3 px-md-0">Experience the finest treatments crafted to rejuvenate your body, mind, and soul.</p>
</section>


<section id="services" class="py-5 bg-light">
  <div class="container">
    <!-- Hero Intro -->
    <div class="text-center mb-5">
      <h2 class="text-gold display-5 fw-bold">Our Signature Treatments</h2>
      <p class="text-muted fs-5">Curated experiences designed for relaxation, rejuvenation, and harmony.</p>
    </div>

    <!-- Swiper Carousel for Mobile -->
    <div class="swiper d-md-none">
      <div class="swiper-wrapper">

        <!-- Service Slide -->
        <div class="swiper-slide">
          <div class="card shadow-sm rounded-4 overflow-hidden">
            <img src="images/thai-aroma.jpg" class="card-img-top" alt="Thai Aroma Hot Oil">
            <div class="card-body">
              <h5 class="text-gold"></h5>
              <p class="fw-semibold">60min – R400 | 90min – R550</p>
              <ul class="small text-muted">
                <li>Essential oils for deep relaxation</li>
                <li>Gentle to moderate pressure</li>
              </ul>
              <a href="#" class="btn btn-gold btn-sm">Book Now</a>
            </div>
          </div>
        </div>

        <!-- Add 5 More Services Here -->
        <!-- Duplicate and change content per service -->

      </div>
    </div>

    <!-- Grid for Desktop -->
    <?php
// Function to extract bullet points from a description
function extractBulletPoints($description) {
  $sentences = preg_split('/(?<=[.!?])\s+/', $description, -1, PREG_SPLIT_NO_EMPTY);
  $points = [];

  foreach ($sentences as $sentence) {
    $sentence = trim($sentence);
    if (strlen($sentence) < 10 || preg_match('/(will|shall|can|could|may)\s*$/i', $sentence)) continue;
    $points[] = ucfirst(rtrim($sentence, '.!?'));
  }

  return $points;
}
?>

<div class="row d-none d-md-flex g-4">
  <?php foreach($services as $lst): ?>
    <div class="col-md-4">
      <div class="card h-100 shadow-sm rounded-4 overflow-hidden">
        <img src="images/services/<?= htmlspecialchars($lst['service_image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($lst['service_name']) ?>">
        <div class="card-body">
          <h5 class="text-gold"><?= htmlspecialchars($lst['service_name']) ?></h5>
          <p class="fw-semibold"><?= htmlspecialchars($lst['duration']) ?> – R<?= htmlspecialchars($lst['service_cost']) ?></p>

          <ul class="small text-muted">
            <?php
              $bullets = extractBulletPoints($lst['short_description']);
              foreach ($bullets as $b) {
                echo "<li>" . htmlspecialchars($b) . "</li>";
              }
            ?>
          </ul>

          <a href="#" class="btn btn-gold btn-sm">Book Now</a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>


    <!-- Special Offer Banner -->
    <div class="py-4 text-center bg-gold text-white rounded-4 shadow my-5">
      <h4 class="fw-bold">🌿 Special Offer!</h4>
      <p class="fs-5 mb-0">Book a 90‑minute massage and receive a complimentary foot reflexology (45min) – Save R350!</p>
    </div>
  </div>
</section>



<?php include 'footer.php'; ?>

<!-- Bootstrap Bundle JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>

<script>
  AOS.init({
    duration: 1500,
    once: true,
  });

  // Services Data from Buddha Spa website, curated and priced
  const services = [
    {
      title: "Swedish Massage",
      description: "A gentle full body massage using long strokes to promote relaxation and improve circulation.",
      price: "From R450"
    },
    {
      title: "Deep Tissue Massage",
      description: "Intense massage targeting deeper muscle layers to relieve tension and chronic pain.",
      price: "From R550"
    },
    {
      title: "Hot Stone Massage",
      description: "Warm volcanic stones are used to relax muscles and increase circulation.",
      price: "From R600"
    },
    {
      title: "Aromatherapy Massage",
      description: "Relax with essential oils chosen to enhance physical and emotional well-being.",
      price: "From R500"
    },
    {
      title: "Reflexology",
      description: "Foot massage therapy focusing on reflex points to promote overall health.",
      price: "From R350"
    },
    {
      title: "Facial Treatments",
      description: "Customized facials to cleanse, exfoliate, and nourish your skin.",
      price: "From R400"
    },
    {
      title: "Full Body Scrub",
      description: "Exfoliating treatment that removes dead skin cells and leaves your skin glowing.",
      price: "From R380"
    },
    {
      title: "Body Wrap",
      description: "Detoxifying wrap to hydrate, firm, and rejuvenate your skin.",
      price: "From R420"
    },
    {
      title: "Couples Massage",
      description: "Enjoy a relaxing massage side by side with your partner in a private room.",
      price: "From R900"
    }
  ];

  // Generate service cards for desktop/tablet grid
  const gridContainer = document.getElementById('services-grid');
  services.forEach((service, i) => {
    const col = document.createElement('div');
    col.className = 'col-md-4';
    col.setAttribute('data-aos', 'fade-up');
    col.setAttribute('data-aos-delay', 100 + i * 100);
    col.innerHTML = `
      <div class="card h-100 shadow border-0">
        <div class="card-body">
          <h5 class="card-title text-gold">${service.title}</h5>
          <p class="card-text">${service.description}</p>
          <p class="fw-bold">${service.price}</p>
        </div>
      </div>
    `;
    gridContainer.appendChild(col);
  });

  // Generate carousel items for mobile
  const carouselInner = document.querySelector('#services-carousel .carousel-inner');
  services.forEach((service, i) => {
    const isActive = i === 0 ? 'active' : '';
    const carouselItem = document.createElement('div');
    carouselItem.className = `carousel-item ${isActive}`;
    carouselItem.innerHTML = `
      <div class="card shadow border-0 mx-3" style="border-radius: 12px;">
        <div class="card-body text-center">
          <h5 class="card-title text-gold">${service.title}</h5>
          <p class="card-text">${service.description}</p>
          <p class="fw-bold">${service.price}</p>
        </div>
      </div>
    `;
    carouselInner.appendChild(carouselItem);
  });
</script>

</body>
</html>
