<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Contact Us | HRDC Malawi</title>

  <!-- Bootstrap -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

  <!-- FontAwesome -->
  <link rel="stylesheet" 
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="css/style.css">

  <style>

/* =====================================================
   GLOBAL
===================================================== */
body {
  font-family: "Poppins", sans-serif;
  background: #fdfdfd;
}

.section-title {
  font-size: 2.4rem;
  font-weight: 800;
  color: #bf1e2e;
  text-align: center;
}

.section-underline {
  width: 80px;
  height: 5px;
  background: #bf1e2e;
  margin: 10px auto 40px auto;
  border-radius: 4px;
}

/* =====================================================
   CONTACT WRAPPER
===================================================== */
.contact-wrapper {
  max-width: 1150px;
  margin: auto;
  display: flex;
  flex-wrap: wrap;
  gap: 40px;
  padding: 60px 20px;
}

/* Left side — Info box */
.contact-info-box {
  background: #ffffff;
  padding: 40px;
  border-radius: 18px;
  flex: 1;
  min-width: 320px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.12);
  border-left: 10px solid #bf1e2e;
}

.contact-info-item {
  display: flex;
  gap: 20px;
  margin-bottom: 25px;
  align-items: flex-start;
}

.contact-info-item i {
  font-size: 1.8rem;
  color: #bf1e2e;
}

.contact-info-item h4 {
  font-weight: 700;
  margin-bottom: 5px;
}

/* Right side — Form */
.contact-form-box {
  background: #ffffff;
  padding: 40px;
  border-radius: 18px;
  flex: 1.3;
  min-width: 350px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.12);
}

.form-control {
  border-radius: 10px;
  padding: 14px;
}

.btn-red {
  background: #bf1e2e;
  border: none;
  padding: 12px 26px;
  color: white;
  font-weight: 700;
  border-radius: 50px;
  transition: 0.3s;
}

.btn-red:hover {
  background: #8a1521;
  transform: translateY(-3px);
}

/* =====================================================
   MAP SECTION
===================================================== */
.map-wrapper iframe {
  width: 100%;
  height: 420px;
  border: 0;
  border-radius: 12px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.12);
}

  </style>
</head>
<body>

<!-- PAGE HERO BANNER -->
<section style="padding: 80px 20px; text-align:center; background:#feecee;">
  <h1 class="section-title">Get in Touch with HRDC</h1>
  <div class="section-underline"></div>
  <p style="max-width:700px; margin:auto; font-size:1.1rem;">
    We value your voice. Whether you want to report a human rights issue, collaborate, or ask a question—
    we’re here for you.
  </p>
</section>


<!-- CONTACT CONTENT -->
<section>

  <div class="contact-wrapper">

    <!-- CONTACT INFORMATION -->
<div class="contact-info-box">

  <h3 class="mb-4 fw-bold">Contact Information</h3>

  <div class="contact-info-item">
    <i class="fas fa-phone"></i>
    <div>
      <h4>Phone</h4>
      <p>+265 994 10 44 57</p>
    </div>
  </div>

  <!-- Hotline Number (24/7) -->
  <div class="contact-info-item">
    <i class="fas fa-headset"></i> <!-- Optional Icon -->
    <div>
      <h4>Hotline (24/7)</h4>
      <p><strong>+265 994 10 44 57</strong></p> <!-- Replace with the actual hotline number -->
      <p>Available 24/7 for urgent assistance.</p>
    </div>
  </div>

  <div class="contact-info-item">
    <i class="fas fa-envelope"></i>
    <div>
      <h4>Email</h4>
      <p>info@hrdcmalawi.org<br>support@hrdcmalawi.org</p>
    </div>
  </div>

  <div class="contact-info-item">
    <i class="fas fa-location-dot"></i>
    <div>
      <h4>Office Location</h4>
      <p>91 Mango Street<br>Area 47, Sector 3<br>Lilongwe</p>
    </div>
  </div>

  <div class="contact-info-item">
    <i class="fas fa-clock"></i>
    <div>
      <h4>Working Hours</h4>
      <p>Monday – Friday<br>08:00 AM – 05:00 PM</p>
    </div>
  </div>

</div>



    <!-- CONTACT FORM -->
    <div class="contact-form-box">

      <h3 class="mb-4 fw-bold">Send Us a Message</h3>

      <form action="send_message.php" method="POST">

        <div class="mb-3">
          <label class="fw-semibold">Full Name</label>
          <input type="text" name="fullname" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Email Address</label>
          <input type="email" name="email" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Phone Number</label>
          <input type="text" name="phone" class="form-control">
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Message</label>
          <textarea name="message" rows="6" class="form-control" required></textarea>
        </div>

        <button type="submit" class="btn-red">Send Message</button>

      </form>

    </div>

  </div>

</section>


<!-- MAP SECTION -->
<section class="map-wrapper" style="padding:60px 20px;">
  <div class="container">
    <h2 class="section-title">Locate Us</h2>
    <div class="section-underline"></div>

    <iframe 
      src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3807.65377819769!2d33.770316!3d-13.962612!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x191f1fdc003b19d3%3A0xc2a6b5756fa0fe58!2sPacific%20Mall!5e0!3m2!1sen!2smw!4v1705839999999"
      loading="lazy"></iframe>
  </div>
</section>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>

</body>
</html>
