const toggle = document.getElementById('mobileToggle');
const menu = document.getElementById('navbarNav');

// MOBILE MENU TOGGLE
toggle.addEventListener('click', () => {
  toggle.classList.toggle('active');
  menu.classList.toggle('active');
});

// FIXED MOBILE DROPDOWN LOGIC
document.querySelectorAll('.dropdown > a').forEach(dropLink => {
  dropLink.addEventListener('click', function (e) {

    // Only override behavior on mobile screens
    if (window.innerWidth <= 768) {
      e.preventDefault();

      const parentLi = this.parentElement;

      // Close all other open dropdowns
      document.querySelectorAll('.dropdown.open').forEach(openLi => {
        if (openLi !== parentLi) {
          openLi.classList.remove('open');
        }
      });

      // Toggle clicked dropdown
      parentLi.classList.toggle('open');
    }
  });
});

// OPTIONAL: Clean up open classes when resizing to desktop
window.addEventListener('resize', () => {
  if (window.innerWidth > 768) {
    document.querySelectorAll('.dropdown.open').forEach(openLi => {
      openLi.classList.remove('open');
    });
    menu.classList.remove('active');
    toggle.classList.remove('active');
  }
});
