	<?php 
		session_start();
		date_default_timezone_set('Africa/Blantyre'); // Example: Malawi

		function createRandomPassword($length = 8) {
			$digits = '0123456789';
			$password = '';
			$maxIndex = strlen($digits) - 1;

			for ($i = 0; $i < $length; $i++) {
				$password .= $digits[random_int(0, $maxIndex)];
			}

			return $password;
		}
			
		$session_id = 'ID'.createRandomPassword();
		
		include_once 'admin/model/users_model.php';
		$user_model = new users_model();

		$check_session = $user_model->checkSession($session_id);
		
		if($check_session > 0){
			$_SESSION['notification'] = [
				'type' => 'warning',
				'title' => 'SECURITY CHECK',
				'message' => 'Duplicate Session ID<br>Please Try To Login Once Again'
			];
			header('Location: login.php');
			exit();
		}
		
		$date = date('Y-m-d');
		$time = date("H:i");
		$username = "";
		$pass = "";
		
		if(isset($_POST['email'])){
		$username = $_POST['email'];
		}
		if (isset($_POST['password'])) {
		$pass = $_POST['password'];
		$hashed_password = password_hash($pass, PASSWORD_BCRYPT);

		}
		
		$user = $user_model->authenticateUser($username);

		
		if (!$user) {
			$_SESSION['notification'] = [
				'type' => 'error',
				'title' => 'LOGIN FAILED',
				'message' => 'Invalid Username'
			];
			header('Location: login.php');
			exit();
		} else {

			$userid = $user['ID'];
			$account = $user['user_role'];
			$state = $user['user_state'];
			$login_time = date('Y-m-d H:i:s');
			$username = $user['username_email'];

			$stored_hashed_password = $user['user_pass'];
			if (password_verify($pass, $stored_hashed_password)) {
				session_regenerate_id();
				$_SESSION['user_id'] = $user['ID'];
				$_SESSION['username'] = $user['username_email'];
				$_SESSION['userrole'] = $user['user_role'];
				$_SESSION['userstate'] = $user['user_state'];
				$_SESSION['sess_session'] = $session_id;
		
				if ($user['user_state'] == 0) {
					// Account is suspended
					$log_user = $user_model->logLogin($session_id, $userid, $username, $login_time, $account, 0, 0);
					$_SESSION['notification'] = [
						'type' => 'error',
						'title' => 'FAILED',
						'message' => 'Your Account Has Been Suspended<br>Consult System Administrator'
					];
					header('Location: login.php');
					exit();
				} else {
					// Handle based on user role
					switch ($user['user_role']) {
						case 'Administrator':
							$log_user = $user_model->logLogin($session_id, $userid, $username, $login_time, $account, 1, 1);
							$_SESSION['notification'] = [
								'title' => 'SUCCESS',
								'type' => 'success',
								'message' => 'Login Successful<br>Session ' . $session_id
							];
							session_write_close();
							header('Location: admin/dashboard.php');
							break;
		
						
						case 'Editor':
								$log_user = $user_model->logLogin($session_id, $userid, $username, $login_time, $account, 1, 1);
								$_SESSION['notification'] = [
									'title' => 'SUCCESS',
									'type' => 'success',
									'message' => 'Login Successful<br>Session ' . $session_id
								];
								session_write_close();
								header('Location: editor/dashboard.php');
								break;
		
						default:
							// User role is not assigned
							$log_user = $user_model->logLogin($session_id, $userid, $username, $login_time, $account, 0, 0);
							$_SESSION['notification'] = [
								'title' => 'LOGIN FAILED',
								'type' => 'error',
								'message' => 'Your Role Has Not Been Assigned'
							];
							header('Location: login.php');
							break;
					}
					exit();
				}
			} else {
				// Password is incorrect
				$log_user = $user_model->logLogin($session_id, $userid, $username, $login_time, $account, 0, 0);
				$_SESSION['notification'] = [
					'type' => 'error',
					'title' => 'LOGIN FAILED',
					'message' => 'Invalid Password'
				];
				header('Location: login.php');
				exit();
			}
		}
		
		
	?>