<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Press Release | HRDC Malawi</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">

<style>
body {
  font-family: "Poppins", sans-serif;
  background:#f4f7fb;
  color:#333;
}

/* HERO */
.hero {
  background:url('uploads/political.jpg') center/cover no-repeat;
  padding:160px 20px;
  text-align:center;
  color:white;
  position:relative;
}
.hero::after {
  content:""; position:absolute; width:100%; height:100%;
  background:linear-gradient(to bottom right, rgba(0,0,0,.7), rgba(0,0,0,.4));
  top:0; left:0; z-index:1;
}
.hero-content { position:relative; z-index:2; }
.hero-content h1 { font-size:3rem; font-weight:800; }
.hero-content p { font-size:1.2rem; }

/* VIEWER BLOCK */
.viewer-box {
  background:white;
  padding:25px;
  border-radius:15px;
  box-shadow:0 10px 25px rgba(0,0,0,.08);
}
.viewer-container {
  width:100%;
  height:85vh;
  margin-top:20px;
  border-radius:10px;
  overflow:hidden;
  border:1px solid #ddd;
}

/* BACK BUTTON */
.back-btn {
  margin-bottom:20px;
  font-weight:600;
}

/* SIDEBAR */
.sidebar {
  background-color: white;
  padding: 25px;
  border-radius: 15px;
  box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
}

.sidebar h4 {
  color: #0d8ac2;
  font-size: 1.5rem;
  margin-bottom: 18px;
  font-weight: 700;
}

.sidebar .resource-list {
  list-style: none;
  padding: 0;
  margin-top: 15px;
}

.sidebar .resource-list li {
  margin-bottom: 15px;
  padding-bottom: 10px;
  border-bottom: 1px dashed #ddd;
}

.sidebar .resource-list a {
  text-decoration: none;
  color: #444;
  font-weight: 600;
  display: flex;
  align-items: center;
}

.sidebar .resource-list a:hover {
  color: #0d8ac2;
  padding-left: 4px;
}
</style>
</head>

<body>

<!-- HERO -->
<div class="hero">
  <div class="hero-content">
    <h1>Press Release</h1>
    <p>Official Statement from HRDC Malawi</p>
  </div>
</div>

<?php
// FETCH DOCUMENT DETAILS
$conn = new mysqli('localhost','smplus_hrdc','0991123495@Tomaida','smplus_hrdc');
$id = intval($_GET['id']);

$sql = "SELECT * FROM hrdc_resources WHERE resource_id = $id LIMIT 1";
$result = $conn->query($sql);
$row = $result->fetch_assoc();
$conn->close();

if (!$row) { 
  echo "<div class='container mt-5'><h3>Press Release Not Found</h3></div>";
  exit();
}

$file = $row['resource_name'];
$path = "$file";
$ext  = strtolower(pathinfo($file, PATHINFO_EXTENSION));

// Determine the base URL (Live vs Local)
$base_url = ($_SERVER['HTTP_HOST'] == 'hrdcmalawi.org') 
            ? 'https://hrdcmalawi.org/admin/press_release/documents/' 
            : 'http://localhost/hrdc/admin/press_release/documents/';
?>

<div class="container mt-5 mb-5">
  <div class="row">

    <!-- MAIN CONTENT -->
    <div class="col-lg-8">
      <div class="viewer-box">

        <!-- TITLE + COMMENT -->
        <h2 class="fw-bold text-primary"><?php echo $row['title']; ?></h2>
        <p class="mt-2"><?php echo nl2br($row['comment']); ?></p>

        <!-- DOCUMENT VIEWER -->
        <div class="viewer-container">
          <?php if ($ext == "pdf"): 
             
            ?>

              <iframe src="<?php echo $base_url . $path; ?>" width="100%" height="100%" style="border:none;"></iframe>

          <?php elseif (in_array($ext, ['jpg','jpeg','png','gif'])): ?>

              <!-- IMAGE -->
              <img src="<?php echo $base_url . $path; ?>" style="width:100%; height:auto;" />

          <?php elseif (in_array($ext, ['doc','docx','xls','xlsx','ppt','pptx'])): ?>

              <!-- OFFICE VIEWER -->
              <iframe 
                  src="https://view.officeapps.live.com/op/embed.aspx?src=<?php 
                    echo urlencode("https://" . $_SERVER['HTTP_HOST'] . "/" . $base_url . $path); 
                  ?>" 
                  width="100%" height="100%" style="border:none;">
              </iframe>

          <?php else: ?>

              <!-- FALLBACK -->
              <div style="padding:40px; text-align:center;">
                <h4>Preview Not Available</h4>
                <p>This document type cannot be previewed online.</p>
                <a href="<?php echo $base_url . $path; ?>" download class="btn btn-primary">
                  <i class="fa-solid fa-download"></i> Download File
                </a>
              </div>

          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- SIDEBAR -->
    <div class="col-lg-4">
      <div class="sidebar">
        <h4><i class="fa-solid fa-clock-rotate-left"></i> Latest Press Releases</h4>

        <ul class="resource-list">
          <?php
          // Fetch the latest 5 press releases
          $conn = new mysqli('localhost', 'smplus_hrdc', '0991123495@Tomaida', 'smplus_hrdc');
          $sql = "SELECT * FROM hrdc_resources ORDER BY date_created DESC LIMIT 5";
          $result = $conn->query($sql);

          if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
              echo '<li><a href="view_press.php?id=' . $row['resource_id'] . '"><i class="fa-solid fa-file-alt"></i>' . $row['title'] . '</a></li>';
            }
          }
          $conn->close();
          ?>
        </ul>
      </div>
    </div>

  </div>
</div>

<?php include 'footer.php'; ?>
<script src="navigation.js"></script>

</body>
</html>
