<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Who We Are | HRDC Malawi</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">

<style>

body {
  font-family: "Poppins", sans-serif;
  background: #fbfeff;
}

/* ===== HERO BANNER ===== */
.hero {
  background: url('images/slider2.jpeg') center/cover no-repeat;
  padding: 140px 20px;
  text-align: center;
  color: white;
  position: relative;
}

.hero::after {
  content: "";
  position: absolute;
  top:0; left:0; width:100%; height:100%;
  background: rgba(0,0,0,0.55);
  z-index: 1;
}

.hero-content {
  position: relative;
  z-index: 2;
  max-width: 800px;
  margin: auto;
}

.hero h1 {
  font-size: 3rem;
  font-weight: 800;
}

.hero p {
  font-size: 1.2rem;
  margin-top: 15px;
}

/* ===== SECTION TITLE ===== */
.section-title {
  font-weight: 800;
  font-size: 2.4rem;
  color: #0d8ac2;
  text-align: center;
}

.section-underline {
  width: 70px;
  height: 5px;
  background: #bf1e2e;
  margin: 10px auto 40px auto;
  border-radius: 3px;
}

/* ===== ABOUT SECTION ===== */
.about-wrapper {
  max-width: 1100px;
  margin: auto;
  padding: 60px 20px;
  display: flex;
  flex-wrap: wrap;
  gap: 40px;
  align-items: center;
}

.about-text {
  flex: 1.4;
}

.about-text h2 {
  font-size: 2.2rem;
  font-weight: 700;
  color: #bf1e2e;
}

.about-text p {
  line-height: 1.7;
  color: #333;
}

.about-img {
  flex: 1;
  text-align: center;
}

.about-img img {
  width: 350px;
  height: 350px;
  border-radius: 50%;
  object-fit: cover;
  border: 6px solid #0d8ac2;
}

/* ===== CORE VALUES ===== */
.values-section {
  background: #eef7ff;
  padding: 70px 20px;
}

.values-grid {
  max-width: 1100px;
  margin: auto;
  display: grid;
  gap: 25px;
  grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
}

.value-box {
  background: white;
  padding: 30px;
  border-radius: 18px;
  box-shadow: 0 8px 18px rgba(0,0,0,0.08);
  text-align: center;
  transition: 0.35s ease;
}

.value-box:hover {
  transform: translateY(-6px);
  box-shadow: 0 15px 35px rgba(0,0,0,0.13);
}

.value-box i {
  font-size: 2.5rem;
  color: #0d8ac2;
  margin-bottom: 15px;
}

/* ===== LEADERSHIP TEAM ===== */
/* ===== LEADERSHIP TEAM ===== */
.team-section {
  padding: 70px 30px;
}

.team-grid {
  max-width: 1200px;
  margin: auto;
  display: grid;
  gap: 35px;
  grid-template-columns: repeat(3, 1fr);   /* 3 per row */
  text-align: center;
  padding: 20px;
}

.team-card {
  background: white;
  border-radius: 18px;
  padding: 30px 20px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.08);
  transition: 0.3s ease;
}

.team-card:hover {
  transform: translateY(-6px);
  box-shadow: 0 15px 35px rgba(0,0,0,0.13);
}

.team-card img {
  width: 180px;
  height: 180px;
  object-fit: cover;
  border-radius: 50%;
  margin-bottom: 15px;
  border: 5px solid #bf1e2e;
}

/* RESPONSIVE */
@media(max-width: 992px) {
  .team-grid {
    grid-template-columns: repeat(2, 1fr); /* 2 per row on tablets */
  }
}

@media(max-width: 600px) {
  .team-grid {
    grid-template-columns: 1fr; /* 1 per row on phones */
  }
}



/* ===== HISTORY SECTION ===== */
.history-section {
  background: #fff;
  padding: 70px 20px;
}

.history-wrapper {
  max-width: 1000px;
  margin: auto;
  text-align: center;
}

.history-wrapper p {
  line-height: 1.8;
  font-size: 1.05rem;
  color: #444;
}

/* RESPONSIVE TWEAKS */
@media(max-width: 768px) {
  .hero h1 { font-size: 2.2rem; }
  .about-img img { width: 260px; height:260px; }
}

</style>
</head>
<body>

<!-- HERO SECTION -->
<section class="hero">
  <div class="hero-content">
    <h1>Who We Are</h1>
    <p>Championing human rights, justice, and good governance for every Malawian.</p>
  </div>
</section>


<!-- ABOUT HRDC -->
<section>
  <div class="about-wrapper">
    
    <div class="about-img">
      <img src="images/michael_kaiyatsa.jpg" alt="HRDC Chairperson">
    </div>

    <div class="about-text">
      <h2>Human Rights Defenders Coalition (HRDC)</h2>
      <p>
        HRDC is a nationwide coalition of human rights organizations, activists, and civil society groups  
        dedicated to safeguarding human rights, strengthening accountability, and ensuring that every Malawian  
        enjoys freedom, justice, and dignity without discrimination.
      </p>
      <p>
        Since its formation, HRDC has been at the forefront of advocating for transparency, democratic governance,  
        and lawful conduct of public institutions. Our mission is rooted in defending the rights of citizens and  
        amplifying the voices of vulnerable communities throughout Malawi.
      </p>
    </div>

  </div>
</section>


<!-- CORE VALUES -->
<section class="values-section">
  <h2 class="section-title">Our Core Values</h2>
  <div class="section-underline"></div>

  <div class="values-grid">

    <div class="value-box">
      <i class="fas fa-balance-scale"></i>
      <h4 class="fw-bold mt-3">Justice</h4>
      <p>We fight for fairness, transparency, and accountability in all institutions.</p>
    </div>

    <div class="value-box">
      <i class="fas fa-shield-alt"></i>
      <h4 class="fw-bold mt-3">Protection</h4>
      <p>We defend activists, whistleblowers, and individuals facing human rights violations.</p>
    </div>

    <div class="value-box">
      <i class="fas fa-users"></i>
      <h4 class="fw-bold mt-3">Solidarity</h4>
      <p>We work as a united front, building strong partnerships for greater impact.</p>
    </div>

    <div class="value-box">
      <i class="fas fa-hand-holding-heart"></i>
      <h4 class="fw-bold mt-3">Integrity</h4>
      <p>We uphold honesty, ethics, and professionalism in all our work.</p>
    </div>

  </div>
</section>


<!-- LEADERSHIP TEAM -->
<section class="team-section">
  <h2 class="section-title">Our Leadership</h2>
  <div class="section-underline"></div>

  <div class="team-grid">

    <div class="team-card">
      <img src="images/michael_kaiyatsa.jpg" alt="">
      <h5 class="fw-bold mt-2">Michael Kaiyatsa</h5>
      <p class="text-muted">Chairperson</p>
    </div>

    <div class="team-card">
      <img src="images/mada.jpg" alt="">
      <h5 class="fw-bold mt-2">Madalitso Banda</h5>
      <p class="text-muted">Eastern Chairperson - HRDC Malawi</p>
    </div>

    <div class="team-card">
      <img src="images/foster.jpg" alt="">
      <h5 class="fw-bold mt-2">Foster Gondwe</h5>
      <p class="text-muted">Programs Officer - HRDC Malawi</p>
    </div>

    

    <div class="team-card">
      <img src="images/kelvin.jpg" alt="">
      <h5 class="fw-bold mt-2">Kelvin Chirwa</h5>
      <p class="text-muted">National Coordinator - HRDC Malawi</p>
    </div>

    <div class="team-card">
      <img src="images/beatrice.jpg" alt="">
      <h5 class="fw-bold mt-2">Beatrice</h5>
      <p class="text-muted">HRDC Malawi</p>
    </div>

    <div class="team-card">
      <img src="images/gibson_2.jpg" alt="">
      <h5 class="fw-bold mt-2">Gibson Chisale</h5>
      <p class="text-muted">Board Member - HRDC Malawi</p>
    </div>

  </div>
</section>



<!-- OUR HISTORY -->
<section class="history-section">
  <div class="history-wrapper">
    <h2 class="section-title">Our Journey</h2>
    <div class="section-underline"></div>

    <p>
      The Human Rights Defenders Coalition was formed in response to growing concerns  
      about shrinking civic space, abuses of office, and threats against activists and  
      journalists. Over the years, HRDC has led major nationwide movements demanding  
      justice, electoral accountability, and constitutional order.
    </p>

    <p>
      Our advocacy has contributed to significant legal reforms, increased awareness of  
      human rights, and strengthened the protection of vulnerable communities.
      HRDC continues to stand firm as a watchdog for democracy in Malawi.
    </p>
  </div>
</section>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>
</body>
</html>
