<?php
session_start();
include_once 'model/posts_model.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
  
    $category_id = isset($_POST['categoryId']) ? (int)$_POST['categoryId'] : 0;
    $category_name = isset($_POST['categoryName']) ? trim($_POST['categoryName']) : '';

    if (empty($category_name)) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'Category name is required.'
        ];
        header('Location: post_categories.php');
        exit;
    }


    $posts_model = new posts_model();


    $update_result = $posts_model->update_category($category_id, $category_name);


    if ($update_result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Success',
            'message' => 'Category updated successfully.'
        ];
        header('Location: post_categories.php');
        exit;
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'Failed to update category.'
        ];
        header('Location: post_categories.php');
        exit;
    }
}
else {
    $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Error',
        'message' => 'Invalid request method.'
    ];
    header('Location: post_categories.php');
    exit;
}
?>
