<?php
// Include the posts model
include_once 'model/posts_model.php';

// Check if the 'id' parameter is present in the URL
if (isset($_GET['id'])) {
    $post_id = $_GET['id'];
    
    // Instantiate the posts model
    $posts_model = new posts_model();
    
    // Get the current comment status for the post
    $current_status = $posts_model->get_comment_status($post_id);
    
    // Toggle the comment status (1 for 'open' or 0 for 'closed')
    $new_status = ($current_status == 'open') ? 'closed' : 'open';
    
    // Update the comment status in the database
    $success = $posts_model->update_comment_status($post_id, $new_status);
    
    // Return the result as a JSON response
    if ($success) {
        echo json_encode(['success' => true, 'new_status' => $new_status]);
    } else {
        echo json_encode(['success' => false]);
    }
} else {
    // If the ID is not set, return an error message
    echo json_encode(['success' => false, 'message' => 'No post ID provided']);
}
?>
