<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donate | HRDC Malawi</title>

    <!-- Bootstrap 5 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Lightbox CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/css/lightbox.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }

        /* HERO SECTION */
        .hero-section {
            background-color: #007bff;
            color: white;
            padding: 80px 0;
            text-align: center;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .hero-section h1 {
            font-size: 3rem;
            font-weight: 700;
        }

        .hero-section p {
            font-size: 1.25rem;
            font-weight: 300;
            margin-bottom: 30px;
        }

        .hero-section .btn {
            font-size: 1.25rem;
            padding: 12px 30px;
            border-radius: 25px;
        }

        /* DONATION INFO SECTION */
        .donation-info {
            padding: 50px 0;
            background-color: #f8f9fa;
        }

        .donation-info h2 {
            font-size: 2.5rem;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .donation-info ul {
            padding-left: 20px;
            list-style-type: disc;
        }

        .donation-info ul li {
            font-size: 1.125rem;
            margin-bottom: 10px;
        }

        /* DONATION FORM SECTION */
        .donation-form {
            padding: 50px 0;
        }

        .donation-form h2 {
            font-size: 2.5rem;
            font-weight: 600;
            margin-bottom: 40px;
        }

        .donation-form .form-control {
            border-radius: 8px;
            padding: 15px;
            font-size: 1.125rem;
            margin-bottom: 20px;
        }

        .donation-form .form-control:focus {
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            border-color: #007bff;
        }

        .donation-form button {
            font-size: 1.25rem;
            padding: 15px 40px;
            border-radius: 30px;
        }

        /* PAYMENT DETAILS SECTION */
        .payment-details h5 {
            font-size: 1.25rem;
            font-weight: 500;
            margin-bottom: 10px;
        }

        .payment-details p {
            font-size: 1rem;
            margin-bottom: 10px;
        }

        .payment-details .icon {
            font-size: 2rem;
            color: #007bff;
            margin-right: 10px;
        }

        /* CONFIRMATION SECTION */
        .confirmation {
            padding: 50px 0;
            background-color: #f8f9fa;
        }

        .confirmation h2 {
            font-size: 2.5rem;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .confirmation p {
            font-size: 1.125rem;
            font-weight: 300;
        }

        /* CUSTOM BUTTON */
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }

        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
    </style>
</head>
<body>

<!-- HERO SECTION -->
<section class="hero-section">
    <div class="container">
        <h1 class="display-4">Support HRDC Malawi</h1>
        <p class="lead">Your generous donations help us continue our mission to defend and promote human rights.</p>
        <a href="#donationForm" class="btn btn-light btn-lg">Donate Now</a>
    </div>
</section>

<!-- DONATION INFO SECTION -->
<section class="donation-info">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <h2>Why Donate?</h2>
                <p>HRDC Malawi works tirelessly to protect human rights, promote justice, and advocate for positive change across the country. Your donation will enable us to:</p>
                <ul>
                    <li>Support human rights education and training programs.</li>
                    <li>Provide legal aid to victims of human rights violations.</li>
                    <li>Fund advocacy campaigns and policy reforms.</li>
                    <li>Raise awareness about critical issues in Malawi.</li>
                </ul>
                <p>Your contribution makes a real difference. Together, we can create lasting change in our community.</p>
            </div>
            <div class="col-md-6">
                <img src="images/Donate-image-4.webp" class="img-fluid rounded" alt="Donation Image">
            </div>
        </div>
    </div>
</section>

<!-- DONATION FORM SECTION -->
<section id="donationForm" class="donation-form">
    <div class="container">
        <h2 class="text-center">Make a Donation</h2>
        <p class="text-center">Fill out the form below to donate to HRDC Malawi.</p>
        <div class="row">
            <!-- Left Column: Payment Details (Banking Details) -->
            <div class="col-md-6">
                <h3 class="h4">Payment Details</h3>
                <div class="mb-4">
                    <h5><i class="icon fa fa-bank"></i> Bank Transfer</h5>
                    <p>Bank Name:FDH Bank</p>
                    <p>Account Number: 1970100196843</p>
                    <p>Account Name: Human Rights Defenders Coalition</p>
                    <p>SWIFT/BIC: FDHFMWMW</p>
                </div>

                <div class="mb-4">
                    <h5><i class="icon fa fa-phone"></i> Airtel Money</h5>
                    <p>Send your donation to the following Airtel Money number:</p>
                    <p><strong>+265 994 10 44 57</strong></p>
                    <p>Make sure to include "HRDC Donation" in the reference field when transferring.</p>
                </div>

                

                <div class="mb-4">
                    <h5><i class="icon fa fa-credit-card"></i> PayPal</h5>
                    <p>You can donate via PayPal by sending payments to:</p>
                    <p><strong>hrdcmalawi@paypal.com</strong></p>
                </div>
            </div>

            <!-- Right Column: Donation Form -->
            <div class="col-md-6">
                <form id="donationForm" method="POST" action="process_donation.php">
                    <div class="mb-3">
                        <label for="donorName" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="donorName" name="donorName" required>
                    </div>

                    <div class="mb-3">
                        <label for="donorEmail" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="donorEmail" name="donorEmail" required>
                    </div>

                    <div class="mb-3">
                        <label for="donationAmount" class="form-label">Donation Amount (USD)</label>
                        <input type="number" class="form-control" id="donationAmount" name="donationAmount" placeholder="Enter amount" required>
                    </div>

                    <div class="mb-3">
                        <label for="paymentMethod" class="form-label">Select Payment Method</label>
                        <select class="form-control" id="paymentMethod" name="paymentMethod" required>
                            <option value="" selected disabled>Select Payment Method</option>
                            <option value="bank">Bank Transfer</option>
                            <option value="mobile_money">Mobile Money (e.g., Airtel Money, TNM Mpamba)</option>
                            <option value="paypal">PayPal</option>
                        </select>
                    </div>

                    <!-- Submit Button -->
                    <div class="text-center">
                        <button type="submit" class="btn btn-primary btn-lg" id="submitBtn">
                            Donate Now
                            <span id="loadingSpinner" class="spinner-border spinner-border-sm" role="status" aria-hidden="true" style="display: none;"></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>


<!-- DONATION CONFIRMATION SECTION -->
<section id="confirmation" class="confirmation text-center">
    <div class="container">
        <h2>Thank You for Your Donation!</h2>
        <p>Your generosity is helping make a difference. We will send a confirmation email to the address you provided with the details of your donation.</p>
    </div>
</section>

<!-- FOOTER -->
<?php include 'footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>

<!-- Lightbox JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/js/lightbox.min.js"></script>

<!-- Custom JS for form submission -->
<script>
    $(document).ready(function() {
        $('#donationForm').on('submit', function(event) {
            // Disable the submit button and show the loading spinner
            $('#submitBtn').prop('disabled', true);
            $('#loadingSpinner').show();

            // Simulate a delay (e.g., form processing)
            setTimeout(function() {
                // Normally, this would be an AJAX call to submit the form and handle the response.
                // For this example, we'll simulate a success message and redirect to a confirmation page.

                // Show confirmation message
                $('#donationForm').hide();
                $('#confirmation').show();

                // Re-enable the button after a few seconds (simulating server response)
                setTimeout(function() {
                    $('#submitBtn').prop('disabled', false);
                    $('#loadingSpinner').hide();
                }, 2000);
            }, 1500);

            event.preventDefault(); // Prevent the default form submission for now
        });
    });
</script>

</body>
</html>
