<?php $__env->startSection('head'); ?>


    <!-- BEGIN PAGE LEVEL STYLES -->

    <?php echo HTML::style("assets/global/plugins/bootstrap-datepicker/css/datepicker3.css"); ?>


    <!-- END PAGE LEVEL STYLES -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>

    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        <?php echo e($pageTitle); ?>

        <small>Holidays List</small>
    </h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="<?php echo e(route('admin.dashboard.index')); ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="#">Holidays</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="#">Holidays list of <?php echo e(\Illuminate\Support\Carbon::now()->format('Y')); ?> </a>
            </li>
        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->

    <div id="load">
        
        <?php echo $__env->make('admin.common.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>


    <div class="row">
        <div class="col-md-3"><a class="btn green" onclick="showAdd()">
                Add Holidays
                <i class="fa fa-plus"></i> </a></div>
        <div class="col-md-offset-6 col-md-3 ">
            <?php if($number_of_sundays>$holidays_in_db): ?>
                <a class="btn green" href="javascript:;" onclick="markSunday();">
                    Mark All Sunday Holiday
                    <i class="fa fa-check"></i> </a>
            <?php endif; ?>

        </div>

    </div>

    <hr>
    <div class="row">
        <div class="col-md-3">
            <ul class="ver-inline-menu tabbable margin-bottom-10">
                <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li <?php if($month == $currentMonth): ?> class="active" <?php endif; ?> >
                        <a data-toggle="tab" href="#<?php echo e($month); ?>">
                            <i class="fa fa-calendar"></i> <?php echo e($month); ?> </a>
                        <span class="after">
                                    </span>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>
        </div>
        <div class="col-md-9">
            <div class="tab-content">
                <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div id="<?php echo e($month); ?>" class="tab-pane <?php if($month == $currentMonth): ?> active <?php endif; ?>">
                        <div class="portlet box blue">
                            <div class="portlet-title">
                                <div class="caption">
                                    <i class="fa fa-calendar"></i><?php echo e($month); ?>

                                </div>

                            </div>
                            <div class="portlet-body">
                                <div class="table-scrollable">
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th> #</th>
                                            <th> Date</th>
                                            <th> Occasion</th>
                                            <th> Day</th>
                                            <th> Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(isset($holidaysArray[$month])): ?>

                                            <?php for($i=0;$i<count($holidaysArray[$month]['date']);$i++): ?>

                                                <tr id="row<?php echo e($holidaysArray[$month]['id'][$i]); ?>">
                                                    <td> <?php echo e(($i+1)); ?> </td>
                                                    <td> <?php echo e($holidaysArray[$month]['date'][$i]); ?> </td>
                                                    <td> <?php echo e($holidaysArray[$month]['ocassion'][$i]); ?> </td>
                                                    <td> <?php echo e($holidaysArray[$month]['day'][$i]); ?> </td>
                                                    <td>
                                                        <button type="button"
                                                                onclick="del('<?php echo e($holidaysArray[$month]['id'][$i]); ?>',' <?php echo e($holidaysArray[$month]['date'][$i]); ?>')"
                                                                href="#" class="btn btn-xs red">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endfor; ?>
                                        <?php endif; ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
        </div>
    </div>
    <!-- END PAGE CONTENT-->

    


    

    
    <?php echo $__env->make('admin.include.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.show-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerjs'); ?>

    
    <?php echo HTML::script("assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js"); ?>

    <?php echo HTML::script("assets/admin/pages/scripts/components-pickers.js"); ?>

    
    <script>
        jQuery(document).ready(function () {

            ComponentsPickers.init();
        });

        // Javascript function to update the company info and Bank Info
        function storeHolidays() {

            var url = "<?php echo e(route('admin.holidays.store')); ?>";
            $.easyAjax({
                type: 'POST',
                url: url,
                container: '#add_holiday_form',
                data: $('#add_holiday_form').serialize(),
                success: function () {
                    $('#showModal').modal('hide');
                    location.reload(true);
                }
            });
        }

        // Show Create Department Modal
        function showAdd() {
            var url = "<?php echo e(route('admin.holidays.create')); ?>";
            $.ajaxModal('#showModal', url);
        }

        // Show Delete Modal
        function del(id, date) {

            $('#deleteModal').modal('show');

            $("#deleteModal").find('#info').html('Are you sure ! You want to delete <strong>' + date + '</strong> ?');

            $('#deleteModal').find("#delete").off().click(function () {

                var url = "<?php echo e(route('admin.holidays.destroy',':id')); ?>";
                url = url.replace(':id', id);

                var token = "<?php echo e(csrf_token()); ?>";

                $.easyAjax({
                    type: 'DELETE',
                    url: url,
                    data: {'_token': token},
                    container: "#deleteModal",
                    success: function (response) {
                        if (response.status == "success") {
                            $('#deleteModal').modal('hide');
                            $("html, body").animate({scrollTop: 0}, "slow");
                            $('#row' + id).fadeOut(500);
                            //location.reload(true);
                            // TODO: table reload fnDraw
//							table.dataTable.fnDraw();
                        }
                    }
                });

            });
        }

        function markSunday() {
            $.easyAjax({
                type: 'GET',
                url: "<?php echo e(URL::to('admin/holidays/mark_sunday ')); ?>",
                data: {},
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\hrm1\resources\views/admin/holidays/index.blade.php ENDPATH**/ ?>