@extends('admin.adminlayouts.adminlayout')

@section('head')

    <!-- BEGIN PAGE LEVEL STYLES -->
    {!! HTML::style("assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css") !!}
    {!! HTML::style("assets/global/plugins/select2/select2.css") !!}
    {!! HTML::style("assets/global/plugins/jquery-multi-select/css/multi-select.css") !!}
    {!! HTML::style("assets/global/plugins/fullcalendar/fullcalendar.min.css") !!}
    <!-- BEGIN THEME STYLES -->

@stop


@section('mainarea')


    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        {{$pageTitle}}
    </h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="{{route('admin.dashboard.index')}}">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="{{ route('admin.employees.index') }}">Employees</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="#">{{$employee->fullName}}</a>

            </li>

        </ul>

    </div>

    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">

            {{--INLCUDE ERROR MESSAGE BOX--}}
            @include('admin.common.error')
            {{--END ERROR MESSAGE BOX--}}
            <div class="portlet box green-meadow calendar">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-list"></i>{{$employee->fullName}}
                    </div>
                </div>
                <div class="portlet-body text-center">
                    <div class="row ">

                        <div class="col-md-4 col-sm-4">
                            <h2>Select</h2>
                            <form action="http://localhost/pdf/generate_pdf.php" enctype="multipart/form-data" method="get" role="form form-row-sepe">
                                <div class="form-body alert alert-block alert-info fade in">

                                    <div class="row ">

                                        <div class="col-md-12 ">
                                            <div class="form-group">
                                                <label>Select Employee</label>
                                                <div class="input-group ">

                                                    {!!  Form::select('employeeID', $employeeslist,$employee->employeeID,['class' => 'form-control input-large select2me','data-placeholder'=>'Select Employee...','onchange'=>'redirect_to()','id'=>'changeEmployee'])  !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row ">

                                        <!--/span-->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Month</label>
                                                <div class="input-group">

                                                    <select class="form-control input-large select2me monthSelect"
                                                            id="monthSelect" name="forMonth"
                                                            onclick="changeMonthYear();return false;">
                                                        <option value="01"
                                                                @if(strtolower(date('F'))=='january')selected='selected'@endif>
                                                            January
                                                        </option>
                                                        <option value="02"
                                                                @if(strtolower(date('F'))=='february')selected='selected'@endif>
                                                            February
                                                        </option>
                                                        <option value="03"
                                                                @if(strtolower(date('F'))=='march')selected='selected'@endif>
                                                            March
                                                        </option>
                                                        <option value="04"
                                                                @if(strtolower(date('F'))=='april')selected='selected'@endif>
                                                            April
                                                        </option>
                                                        <option value="05"
                                                                @if(strtolower(date('F'))=='may')selected='selected'@endif>
                                                            May
                                                        </option>
                                                        <option value="06"
                                                                @if(strtolower(date('F'))=='june')selected='selected'@endif>
                                                            June
                                                        </option>
                                                        <option value="07"
                                                                @if(strtolower(date('F'))=='july')selected='selected'@endif>
                                                            July
                                                        </option>
                                                        <option value="08"
                                                                @if(strtolower(date('F'))=='august')selected='selected'@endif>
                                                            August
                                                        </option>
                                                        <option value="09"
                                                                @if(strtolower(date('F'))=='september')selected='selected'@endif>
                                                            September
                                                        </option>
                                                        <option value="10"
                                                                @if(strtolower(date('F'))=='october')selected='selected'@endif>
                                                            October
                                                        </option>
                                                        <option value="11"
                                                                @if(strtolower(date('F'))=='november')selected='selected'@endif>
                                                            November
                                                        </option>
                                                        <option value="12"
                                                                @if(strtolower(date('F'))=='december')selected='selected'@endif>
                                                            December
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row ">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Year</label>
                                                <select class="form-control input-large select2me" id="yearSelect"
                                                        name="forYear" onclick="changeMonthYear();return false;">
                                                    @for($i=2013;$i<=date('Y');$i++)
                                                        <option value="{{$i}}"
                                                                @if(date('Y')==$i) selected='selected'@endif>{{$i}}</option>

                                                    @endfor

                                                </select>
                                            </div>
                                        </div>

                                        <!--/span-->

                                    </div>
                                    <hr>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="alert alert-danger text-center">
                                                <div> <button type="submit" name="editextra" class="btn btn-info px-5">Pdf File</button></div>
                                            </div>
                                        </div>
                                        <!--/span-->
                                       

                                        
                                        <!--/span-->

                                    </div>
                                   
                                </div>

                            </form>
                            
                            


                        </div>
                        
                        <div class="col-md-8 col-sm-8">
                            <div id="calendar" class="has-toolbar text-center">
                            </div>
                        </div>
                    </div>
                    <!-- END CALENDAR PORTLET-->
                </div>
            </div>
        </div>
    </div>
    <!-- END PAGE CONTENT-->

@stop

@section('footerjs')

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    {!! HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js") !!}
    {!! HTML::script("assets/global/plugins/bootstrap-select/bootstrap-select.min.js") !!}
    {!! HTML::script("assets/global/plugins/select2/select2.min.js") !!}

    {!! HTML::script("assets/global/plugins/jquery-multi-select/js/jquery.multi-select.js") !!}
    {!! HTML::script("assets/admin/pages/scripts/components-dropdowns.js") !!}


    {!! HTML::script('assets/admin/pages/scripts/ui-blockui.js') !!}
    {!! HTML::script("assets/global/plugins/moment.min.js") !!}
    {!! HTML::script("assets/global/plugins/fullcalendar/fullcalendar.min.js") !!}


    <!-- END PAGE LEVEL PLUGINS -->
    <script>
        jQuery(document).ready(function () {

            Calendar.init();
            //showReport();
            UIBlockUI.init();
            ComponentsDropdowns.init();

        });


        function changeMonthYear() {
            var month = $("#monthSelect").val();
            var year = $("#yearSelect").val();
            $('#calendar').fullCalendar('gotoDate', year + '-' + month + '-01');
            showReport();


        }

        function showReport() {

            Metronic.startPageLoading({animate: true});

            window.setTimeout(function () {
                Metronic.stopPageLoading();
            }, 1000);

            var month = $("#monthSelect").val();
            var year = $("#yearSelect").val();
            var employeeID = $("#changeEmployee").val();

            var url = "{{ route('admin.attendance.report',':id') }}";
            url = url.replace(':id', employeeID);
            $.ajax({
                type: "GET",
                url: url,
                dataType: 'json',
                data: {"month": month, "year": year, "employeeID": employeeID}

            }).done(function (response) {

                if (response.success == "success") {

                    $('#attendanceReport').html(response.presentByWorking);
                    $('#attendancePerReport').html(response.attendancePerReport);

                }
            });
        }

        //Function to redirect to the employees page
        function redirect_to() {

            var employee = $('#changeEmployee').val();
            var url = "{{ route('admin.employees.task',':id') }}";
            url = url.replace(':id', employee);
            window.location.href = url;
        }


        var Calendar = function () {


            return {
                //main function to initiate the module
                init: function () {

                    Calendar.initCalendar();
                },

                initCalendar: function () {

                    if (!jQuery().fullCalendar) {
                        return;
                    }

                    var date = new Date();
                    var d = date.getDate();
                    var m = date.getMonth();
                    var y = date.getFullYear();

                    var h = {};


                    if ($('#calendar').parents(".portlet").width() <= 720) {
                        $('#calendar').addClass("mobile");
                        h = {
                            left: 'title, prev, next',
                            center: '',
                            right: 'today,month'
                        };
                    } else {
                        $('#calendar').removeClass("mobile");
                        h = {
                            left: 'title',
                            center: '',
                            right: 'prev,next,today,month'
                        };
                    }


                    $('#calendar').fullCalendar('destroy'); // destroy the calendar
                    $('#calendar').fullCalendar({ //re-initialize the calendar
                        header: h,
                        themeSystem: 'bootstrap4',
//                defaultDate: '2014-06-12',
                        defaultView: 'month',
                        slotMinutes: 15,

                        events: [

                            {{-- Attendance on calendar --}}

                            @foreach($attendance as $attend)
                                @if($attend->status === 'present')
                                {
                                    title: "{{$attend->taskName}}",
                                    start: '{{$attend->date}}',
                                    backgroundColor: Metronic.getBrandColor('yellow')
                                }
                                @else
                                {
                                    title: "{{\Illuminate\Support\Str::words($attend['taskName'],1,'')}} : {{ $attend['taskdescription'] }} ",
                                    start: '{{$attend->date}}',
                                    backgroundColor: Metronic.getBrandColor('blue')
                                }
                                @endif
                            ,
                            @endforeach


                            {{--Holidays on Calendar--}}
                            @foreach($holidays as $holiday)
                            {
                                title: "{{$holiday->occassion}}",
                                start: '{{$holiday->date}}',
                                backgroundColor: Metronic.getBrandColor('grey')
                            },
                            @endforeach
                        ],
                        dayMaxEvents: true, 
                        eventClick: function(info) {
                            alert( info.title );
                        }
                    });

                }

            };

        }();
    </script>
@stop
