<?php 
	session_start();
	function createRandomPassword() {
		$chars = "003232303232023232023456789";
		$pass = '';
	
		for ($i = 0; $i < 8; $i++) { // 8-character password
			$num = random_int(0, strlen($chars) - 1); // Use random_int() instead of rand()
			$pass .= $chars[$num]; // Directly index the string
		}
	
		return $pass;
	}
	
	
	$session_id = 'ID-'.createRandomPassword();
	
	include_once 'finance/model/users_model.php';
	$user_model = new users_model();

	$check_session = $user_model->checkSession($session_id);
	
	if($check_session > 0){
		$_SESSION['notification'] = [
			'type' => 'warning',
			'title' => 'SECURITY CHECK',
			'message' => 'Duplicate Session ID<br>Please Try To Login Once Again'
		];
		header('Location: index.php');
		exit();
	}
	
	$date = date('Y-m-d H:i:s');
	$username = "";
	$pass = "";
	
	if(isset($_POST['username'])){
	$username = $_POST['username'];
	}
	if (isset($_POST['pass'])) {
	$pass = $_POST['pass'];
	$hashed_password = password_hash($pass, PASSWORD_BCRYPT);

	}
	
	var_dump($user = $user_model->authenticateUser($username));
	if(!$user){
		$_SESSION['notification'] = [
			'type' => 'error',
			'title' => 'FAILED',
			'message' => 'The username entered is not associated with any registered accounts'
		];
		header('Location: index.php');
		exit();
	}
	$emp_id = $user['employee_code'];
	$account = $user['role'];
	$state = $user['user_state'];

	$stored_hashed_password = $user['password'];
    
    // The password entered by the user during login
    $entered_password = $pass;

    // Generate a new hash of the entered password for comparison (this will be different due to salting)
    $new_hashed_password = password_hash($entered_password, PASSWORD_BCRYPT);


	
	if (!$user) { // Check if the username exists first
		$_SESSION['notification'] = [
			'type' => 'error',
			'title' => 'LOGIN FAILED',
			'message' => 'Invalid Username'
		];
		header('Location: index.php');
		exit();
	} else {
		if (password_verify($entered_password, $stored_hashed_password)) { // Verify the password
			// Password is correct, proceed with session setup
			session_regenerate_id();
			$_SESSION['sess_username'] = $user['username'];
			$_SESSION['sess_userrole'] = $user['role'];
			$_SESSION['sess_userstate'] = $user['user_state'];
			$_SESSION['sess_employeecode'] = $user['employee_code'];
			$_SESSION['sess_session'] = $session_id;
	
			if ($user['user_state'] == 0) {
				// Account is suspended
				$log_user = $user_model->logLogin($session_id, $emp_id, $username, $date, $account, 0, 0);
				$_SESSION['notification'] = [
					'type' => 'error',
					'title' => 'FAILED',
					'message' => 'Your Account Has Been Suspended<br>Consult System Administrator'
				];
				header('Location: index.php');
				exit();
			} else {
				// Handle based on user role
				switch ($user['role']) {
					case 'Administrator':
						$log_user = $user_model->logLogin($session_id, $emp_id, $username, $date, $account, 1, 1);
						$_SESSION['notification'] = [
							'title' => 'SUCCESS',
							'type' => 'success',
							'message' => 'Login Successful<br>Session ' . $session_id
						];
						session_write_close();
						header('Location: finance/dashboard.php');
						break;
	
					
					case 'Supervisor':
							$log_user = $user_model->logLogin($session_id, $emp_id, $username, $date, $account, 1, 1);
							$_SESSION['notification'] = [
								'title' => 'SUCCESS',
								'type' => 'success',
								'message' => 'Login Successful<br>Session ' . $session_id
							];
							session_write_close();
							header('Location: supervisor/dashboard.php');
							break;
					case 'Cashier':
							$log_user = $user_model->logLogin($session_id, $emp_id, $username, $date, $account, 1, 1);
							$_SESSION['notification'] = [
								'title' => 'SUCCESS',
								'type' => 'success',
								'message' => 'Login Successful<br>Session ' . $session_id
							];
							session_write_close();
							header('Location: cashier/dashboard.php');
							break;
	
					default:
						// User role is not assigned
						$log_user = $user_model->logLogin($session_id, $emp_id, $username, $date, $account, 0, 0);
						$_SESSION['notification'] = [
							'title' => 'LOGIN FAILED',
							'type' => 'error',
							'message' => 'Your Role Has Not Been Assigned'
						];
						header('Location: index.php');
						break;
				}
				exit();
			}
		} else {
			// Password is incorrect
			$log_user = $user_model->logLogin($session_id, $emp_id, $username, $date, $account, 0, 0);
			$_SESSION['notification'] = [
				'type' => 'error',
				'title' => 'LOGIN FAILED',
				'message' => 'Invalid Password'
			];
			header('Location: index.php');
			exit();
		}
	}
	
	
?>