<?php 
include('menu_cashier.php');
include_once 'model/customers_model.php';
include_once 'model/branch_model.php';

$branch_model = new branch_model();
$customers_model = new customers_model();

$branchDetails = $branch_model->getBranchDetails($location);
$all_customers = $customers_model->getCustomers($location, ['Dealer','Corporate','Individual'], [1,2]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Customers | Powertex</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="../includes/plugins/fontawesome-free/css/all.min.css">




<style>
body { background:#f4f6f9; }

.customer-panel {
    max-height: calc(100vh - 140px);
    overflow-y: auto;
}
.customer-card {
    background:#fff;
    border-radius:10px;
    padding:12px;
    margin-bottom:10px;
    box-shadow:0 2px 8px rgba(0,0,0,.05);
    cursor:pointer;
    transition:.2s;
}
.customer-card:hover { transform:translateY(-2px); }
.customer-card.active { border-left:4px solid #007bff; }

.account-placeholder {
    background:#fff;
    padding:40px;
    border-radius:12px;
    text-align:center;
    color:#6c757d;
}
.ledger-table {
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
}

.ledger-table thead th {
    background: #f4f6f9;
    color: #495057;
    font-weight: 600;
    border-bottom: 2px solid #dee2e6;
}

.ledger-table tbody tr:hover {
    background: #f8f9fa;
}

.ledger-table td {
    vertical-align: middle;
    padding: 10px;
}

.ledger-table td.text-danger {
    color: #dc3545 !important;
}

.ledger-table td.text-success {
    color: #28a745 !important;
}

</style>
</head>

<body class="hold-transition sidebar-mini">
<div class="content-wrapper p-4">

<h3>
Customers
<span class="text-primary">– <?= htmlspecialchars($branchDetails['branch_name'] ?? '') ?></span>
</h3>

<div class="row mt-3">
    <!-- LEFT PANEL -->
    <div class="col-md-4">
        <input type="text" id="customerSearch" class="form-control mb-3" placeholder="Search customers...">

        <div class="customer-panel">
            <?php foreach($all_customers as $c): ?>
            <div class="customer-card" data-id="<?= $c['customer_id'] ?>">
                <strong><?= htmlspecialchars($c['customer_name']) ?></strong><br>
                <small class="text-muted"><?= ucfirst($c['type']) ?> Account</small>
                <div class="mt-1">
                    <span class="badge <?= $c['outstanding_balance'] > 0 ? 'badge-danger':'badge-success' ?>">
                        <?= number_format($c['outstanding_balance'],2) ?>
                    </span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- RIGHT PANEL -->
    <div class="col-md-8">
        <div id="customerDetails">
            <div class="account-placeholder">
                <i class="fa fa-user fa-3x mb-3"></i>
                <p>Select a customer to view account ledger</p>
            </div>
        </div>
    </div>
</div>
</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

<script>
$('#customerSearch').on('keyup', function(){
    var val = $(this).val().toLowerCase();
    $('.customer-card').filter(function(){
        $(this).toggle($(this).text().toLowerCase().indexOf(val) > -1)
    });
});

$('.customer-card').on('click', function(){
    $('.customer-card').removeClass('active');
    $(this).addClass('active');

    $.post('customer_details.php', {
        customer_id: $(this).data('id')
    }, function(data){
        $('#customerDetails').html(data);
    });
});
</script>

</body>
</html>
