<?php
header('Content-Type: application/json');
session_start();
date_default_timezone_set('Africa/Blantyre');

include_once 'model/stock_model.php';
$stock_model = new stock_model();

$tn_number = $_POST['tn_number'] ?? '';
$reason    = trim($_POST['reason'] ?? '');

$tnDetails = $stock_model->getDeliveryNote($tn_number);

if (empty($tn_number) || empty($reason)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing data']);
    exit;
}

$declinedBy   = $_SESSION['sess_employeecode'] ?? '';
$dateDeclined = date("Y-m-d");
$state        = 0;

$transferItems = $stock_model->getDeliveryNoteItems($tn_number);
    if (!$transferItems) {
        throw new Exception("No items found for transfer note $tn_number");
    }


    

    foreach ($transferItems as $item) {
        $currentStockArr = $stock_model->getProductQuantityAtDestination($item['product_id'], $item['transfer_from']);
        $currentStock = isset($currentStockArr['quantity']) ? floatval($currentStockArr['quantity']) : 0;
        $transferQty = floatval($item['qty_initiated']);
        $new_quantity = $currentStock + $transferQty;

        $success = $stock_model->updateSourceQuantity($item['transfer_from'], $item['product_id'], $new_quantity);
        if (!$success) throw new Exception("Failed to return stock for product {$item['product_id']}");
    }

    $updateResult = $stock_model->declineTransferNote($tn_number, $state, $declinedBy, $dateDeclined, $reason);
    if (!$updateResult) throw new Exception("Failed to update transfer note state");

    $send_notification = $stock_model->sendNotification($declinedBy, $tnDetails['operator'], 'transfer_note', $tn_number, 'Your Transfer Note was Declined');
    echo json_encode(['status' => 'success', 'message' => 'Transfer note declined and stock returned successfully.']);


