<?php
    include ('menu_cashier.php');
    include_once 'model/banking_model.php';
    include_once 'model/branch_model.php';

    
    $branch_model = new branch_model();
    $banking_model = new banking_model();


    $branchDetails = $branch_model->getBranchDetails($location);
    $expenseDetails = $banking_model->getExpenseDetails($_GET['id'], $location);
    // Current user & branch info

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Expense Details</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <link rel="stylesheet" href="../includes/plugins/bootstrap/css/bootstrap.min.css">

</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="content-wrapper p-4">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="row mb-3">
            <div class="col-sm-6">
                <h3 class="m-0 text-dark">
                    <i class="fas fa-receipt mr-2"></i>
                    Expense Details
                </h3>
            </div>
        </div>

        <!-- Expense Details Card -->
        <div class="card card-outline card-primary">
            <div class="card-body">
                <?php if($expenseDetails): ?>
                    <table class="table table-bordered">
                        <tr>
                            <th>Expense ID</th>
                            <td><?= htmlspecialchars($expenseDetails['id']) ?></td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td><?= htmlspecialchars($expenseDetails['expense_description']) ?></td>
                        </tr>
                        <tr>
                            <th>Amount</th>
                            <td>MWK <?= number_format($expenseDetails['amount_paid'], 2) ?></td>
                        </tr>
                        <tr>
                            <th>Date</th>
                            <td><?= date('F j, Y', strtotime($expenseDetails['expense_date'])) ?></td>
                        </tr>
                        <?php if(!empty($expenseDetails['reference_number'])): ?>
                        <tr>
                            <th>Reference</th>
                            <td><?= htmlspecialchars($expenseDetails['reference_number']) ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning">Expense details not found.</div>
                <?php endif; ?>
            </div>
        </div>

    </div><!-- /.container-fluid -->
    <section class="content pt-3">
        <div class="container-fluid">

            <div class="row">
                <div class="col-md-8 col-lg-6">

                    <button class="btn btn-secondary mb-3" onclick="window.history.back()">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </button>

                </div>
                <div class="col-md-4 col-lg-6 text-right">
                    <button class="btn btn-secondary mb-3" onclick="window.history.back()">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </button>
                </div>

            </div>

        </div>
    </section>

</div>
</body>
</html>
