<?php
    include('menu_cashier.php');
    include_once 'model/banking_model.php';
    include_once 'model/branch_model.php';

    $banking_model = new banking_model();
    $branch_model  = new branch_model();

    $branchDetails = $branch_model->getBranchDetails($location);
    // Get selected month & year from URL (if set)
    $selectedMonth = isset($_GET['month']) ? intval($_GET['month']) : date('m');
    $selectedYear  = isset($_GET['year'])  ? intval($_GET['year'])  : date('Y');

    $expenses_list = $banking_model->getExpensesList($location, $selectedMonth, $selectedYear);
?>

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>Powertex || Expense Transactions</title>
            <link rel="icon" type="image/png" href="../finance/images/favicon.png">
            <link rel="stylesheet" href="../includes/plugins/fontawesome-free/css/all.min.css">
            <link rel="stylesheet" href="../includes/dist/css/adminlte.min.css">
        </head>

        <body class="hold-transition sidebar-mini layout-fixed">
            <div class="content-wrapper p-4">
                <div class="container-fluid">

                    <!-- Page Header -->
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <h3 class="m-0 text-dark">
                                <i class="fas fa-file-invoice-dollar text-danger mr-2"></i>
                                Expense Transactions
                            </h3>
                            <small class="text-muted">
                                Branch: <?php echo $branchDetails['branch_name']; ?>
                            </small>
                        </div>

                        <div class="col-sm-6 text-right">

                                <form method="GET" class="form-inline justify-content-end">

                                    <!-- Month -->
                                    <select name="month" class="form-control mr-2" onchange="this.form.submit()">
                                        <?php
                                        for($m = 1; $m <= 12; $m++):
                                            $monthName = date("F", mktime(0,0,0,$m,1));
                                            $selected = ($m == $selectedMonth) ? "selected" : "";
                                        ?>
                                            <option value="<?php echo $m; ?>" <?php echo $selected; ?>>
                                                <?php echo $monthName; ?>
                                            </option>
                                        <?php endfor; ?>
                                    </select>

                                    <!-- Year -->
                                    <select name="year" class="form-control mr-2" onchange="this.form.submit()">
                                        <?php
                                        $currentYear = date('Y');
                                        for($y = $currentYear; $y >= $currentYear - 5; $y--):
                                            $selected = ($y == $selectedYear) ? "selected" : "";
                                        ?>
                                            <option value="<?php echo $y; ?>" <?php echo $selected; ?>>
                                                <?php echo $y; ?>
                                            </option>
                                        <?php endfor; ?>
                                    </select>

                                    <!-- Add Expense Button -->
                                    <a href="record_expense.php" class="btn btn-danger">
                                        <i class="fas fa-plus-circle mr-1"></i> Add Expense
                                    </a>

                                </form>

                            
                            
                        </div>
                    </div>

                       <?php
                            $totalApproved  = 0;
                            $totalPending   = 0;
                            $totalCancelled = 0;

                            $countApproved  = 0;
                            $countPending   = 0;
                            $countCancelled = 0;

                            if(!empty($expenses_list)){
                                foreach($expenses_list as $expense){

                                    switch($expense['expense_state']){

                                        case 2: // Approved
                                            $totalApproved += (float)$expense['amount_paid'];
                                            $countApproved++;
                                        break;

                                        case 1: // Waiting Approval
                                            $totalPending += (float)$expense['amount_paid'];
                                            $countPending++;
                                        break;

                                        case 0: // Disapproved
                                            $totalCancelled += (float)$expense['amount_paid'];
                                            $countCancelled++;
                                        break;
                                    }
                                }
                            }

                            $totalRequested = count($expenses_list);
                        ?>

                        <div class="row mb-4">

                            <!-- Total Requested -->
                            <div class="col-lg-3 col-6">
                                <div class="small-box bg-secondary">
                                    <div class="inner">
                                        <h4><?php echo $totalRequested; ?></h4>
                                        <p>Total Requested</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fas fa-file-alt"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Approved -->
                            <div class="col-lg-3 col-6">
                                <div class="small-box bg-success">
                                    <div class="inner">
                                        <h4>MK <?php echo number_format($totalApproved,2); ?></h4>
                                        <p>Approved (<?php echo $countApproved; ?>)</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Pending -->
                            <div class="col-lg-3 col-6">
                                <div class="small-box bg-warning">
                                    <div class="inner">
                                        <h4>MK <?php echo number_format($totalPending,2); ?></h4>
                                        <p>Pending (<?php echo $countPending; ?>)</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fas fa-hourglass-half"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Cancelled -->
                            <div class="col-lg-3 col-6">
                                <div class="small-box bg-danger">
                                    <div class="inner">
                                        <h4>MK <?php echo number_format($totalCancelled,2); ?></h4>
                                        <p>Disapproved (<?php echo $countCancelled; ?>)</p>
                                    </div>
                                    <div class="icon">
                                        <i class="fas fa-times-circle"></i>
                                    </div>
                                </div>
                            </div>

                        </div>

                    <!-- Expense Table -->
                    <div class="card card-outline card-danger shadow">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-list mr-2"></i> Expense Records
                            </h3>
                        </div>

                        <div class="card-body table-responsive p-0">
                            <table class="table table-hover text-nowrap">
                                <thead class="bg-light">
                                <tr>
                                    <th>#</th>
                                    <th><i class="fas fa-calendar mr-1"></i>Date</th>
                                    <th><i class="fas fa-tag mr-1"></i>Reference#</th>
                                    <th><i class="fas fa-align-left mr-1"></i>Description</th>
                                    <th><i class="fas fa-money-bill-wave mr-1"></i>Amount</th>
                                    <th><i class="fas fa-user mr-1"></i>Owner</th>
                                    <th><i class="fas fa-user mr-1"></i>Status</th>
                                    <th class="text-center">Actions <i class="fas fa-cog"></i></th>
                                </tr>
                                </thead>

                                <tbody>
                                    <?php if(!empty($expenses_list)) : ?>
                                        <?php $i=1; foreach($expenses_list as $row): ?>
                                            <tr>
                                                <td><?php echo $i++; ?></td>

                                                <!-- Date -->
                                                <td><?php echo date('d M Y', strtotime($row['expense_date'])); ?></td>

                                                <!-- Reference -->
                                                <td>
                                                    <strong><?php echo $row['reference_number']; ?></strong>
                                                </td>

                                                <!-- Description -->
                                                <td><?php echo $row['expense_description']; ?></td>

                                                <!-- Amount -->
                                                <td class="text-danger font-weight-bold">
                                                    MK <?php echo number_format($row['amount_paid'],2); ?>
                                                </td>

                                                <!-- Owner -->
                                                <td><?php echo $row['operator_name']; ?></td>

                                                <!-- STATUS COLUMN WITH BACKGROUND COLOR -->
                                                <?php
                                                    if($row['expense_state'] == 0){
                                                        $statusText  = "Disapproved";
                                                        $statusClass = "bg-danger text-white";
                                                    }elseif($row['expense_state'] == 1){
                                                        $statusText  = "Waiting Approval";
                                                        $statusClass = "bg-warning";
                                                    }else{
                                                        $statusText  = "Approved";
                                                        $statusClass = "bg-success text-white";
                                                    }
                                                ?>
                                                <td class="text-center <?php echo $statusClass; ?>">
                                                    <strong><?php echo $statusText; ?></strong>
                                                </td>

                                                <!-- ACTIONS -->
                                                <td class="text-center">

                                                    <!-- VIEW (Always allowed) -->
                                                    <a href="expense_details.php?id=<?php echo $row['id']; ?>" 
                                                    class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>

                                                    <!-- EDIT -->
                                                    <?php if($row['expense_state'] == 1): ?>
                                                        <button 
                                                            class="btn btn-sm btn-warning edit-btn"
                                                            data-id="<?php echo $row['id']; ?>">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                    <?php else: ?>
                                                        <button class="btn btn-sm btn-warning disabled-action">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                    <?php endif; ?>

                                                    <!-- DELETE -->
                                                    <?php if($row['expense_state'] == 1): ?>
                                                        <button 
                                                            class="btn btn-sm btn-danger delete-btn"
                                                            data-id="<?php echo $row['id']; ?>">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    <?php else: ?>
                                                        <button class="btn btn-sm btn-danger disabled-action">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    <?php endif; ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="8" class="text-center text-muted py-4">
                                                <i class="fas fa-inbox fa-2x mb-2"></i><br>
                                                No expense records found
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Edit Expense Modal -->
            <div class="modal fade" id="editExpenseModal" tabindex="-1">
                <div class="modal-dialog modal-lg modal-dialog-centered">
                    <div class="modal-content shadow">

                        <div class="modal-header bg-warning">
                            <h5 class="modal-title text-dark">
                                <i class="fas fa-edit mr-2"></i> Edit Expense
                            </h5>
                            <button type="button" class="close text-dark" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>

                        <div class="modal-body" id="editExpenseContent">
                            <!-- Dynamic Content Loaded Here -->
                        </div>

                    </div>
                </div>
            </div>

            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="../includes/dist/js/adminlte.min.js"></script>
            <script>
                $(document).ready(function(){

                    // Disabled buttons notification
                    $('.disabled-action').click(function(){
                        toastr.warning('This action is not allowed in the current expense state.');
                    });

                    // SweetAlert Delete Confirmation
                    $(document).on('click', '.delete-btn', function(){

                        let id  = $(this).data('id');
                        let row = $(this).closest('tr'); // we’ll remove this later on success

                        Swal.fire({
                            title: 'Are you sure?',
                            text: "This expense will be permanently deleted.",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#dc3545',
                            cancelButtonColor: '#6c757d',
                            confirmButtonText: 'Delete',
                            cancelButtonText: 'Cancel',
                            reverseButtons: true
                        }).then((result) => {

                            if (result.isConfirmed) {

                                $.ajax({
                                    url: "controllers/expense_controller.php",
                                    method: "POST",
                                    data: {
                                        action: "delete_expense",
                                        id: id
                                    },
                                    dataType: "json",
                                    success: function(response){

                                        if(response.status === "success"){

                                            Swal.fire({
                                                icon: 'success',
                                                title: 'Deleted!',
                                                text: 'Expense deleted successfully.',
                                                confirmButtonColor: '#dc3545'
                                            }).then(() => {

                                                // Reload page to refresh totals & counts
                                                location.reload();

                                            });

                                        } else {

                                            Swal.fire({
                                                icon: 'error',
                                                title: 'Error!',
                                                text: response.message || 'Unable to delete expense.'
                                            });

                                        }

                                    },
                                    error: function(){
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Server Error',
                                            text: 'Something went wrong.'
                                        });
                                    }
                                });

                            }

                        });

                    });

                });
                // Open edit modal
                $('.edit-btn').click(function(){

                    let id = $(this).data('id');

                    $('#editExpenseModal').modal('show');

                    $('#editExpenseContent').html(
                        "<div class='text-center p-4'>" +
                        "<i class='fas fa-spinner fa-spin fa-2x'></i>" +
                        "<p>Loading expense details...</p>" +
                        "</div>"
                    );

                    // Open edit modal
                    $(document).on('click', '.edit-btn', function(){

                        let id = $(this).data('id');

                        $('#editExpenseModal').modal('show');

                        $('#editExpenseContent').html(
                            "<div class='text-center p-4'>" +
                            "<i class='fas fa-spinner fa-spin fa-2x'></i>" +
                            "<p>Loading expense details...</p>" +
                            "</div>"
                        );

                        $.ajax({
                            url: "controllers/expense_controller.php",
                            method: "POST",
                            data: { id: id, action: 'fetch_expense', location: "<?php echo $location; ?>" },
                            dataType: "json",
                            success: function(response){

                                if(!response || !response.expense){
                                    $('#editExpenseContent').html(
                                        "<div class='text-danger text-center p-3'>Expense not found.</div>"
                                    );
                                    return;
                                }

                                let data = response.expense;
                                let payments = response.cancelled_payments;

                                // Build dropdown options
                                let options = '<option value="">Select Cancelled Payment</option>';

                                if(payments && payments.length > 0){
                                    payments.forEach(function(payment){

                                        let selected = (payment.reference_number == data.reference_number) ? 'selected' : '';

                                        options += `
                                            <option value="${payment.reference_number}" ${selected}>
                                                ${payment.reference_number} - MK ${parseFloat(payment.amount).toLocaleString()}
                                            </option>
                                        `;
                                    });
                                }

                                let formHtml = `
                                    <form id="updateExpenseForm" action="controllers/expense_controller.php" method="POST">

                                        <input type="hidden" name="id" value="${data.id}">
                                        <input type="hidden" name="action" value="update_expense">

                                        <div class="form-group">
                                            <label>Reference Number</label>
                                            <select name="reference_number" class="form-control">
                                                ${options}
                                            </select>
                                        </div>


                                        <div class="form-group">
                                            <label>Expense Date</label>
                                            <input type="date" name="expense_date" max="<?php echo date('Y-m-d'); ?>" class="form-control" value="${data.expense_date}" required>

                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea name="expense_description"
                                                    class="form-control"
                                                    rows="3" required>${data.expense_description ?? ''}</textarea>
                                        </div>

                                        <div class="form-group">
                                            <label>Amount (MK)</label>
                                            <input type="number" step="0.01"
                                                name="amount_paid"
                                                class="form-control"
                                                value="${data.amount_paid ?? ''}" required>
                                        </div>

                                        <div class="text-right">
                                            <button type="submit" class="btn btn-warning">
                                                <i class="fas fa-save mr-1"></i> Update Expense
                                            </button>
                                        </div>

                                    </form>
                                `;

                                $('#editExpenseContent').html(formHtml);


                            },
                            error: function(){
                                $('#editExpenseContent').html(
                                    "<div class='text-danger text-center p-3'>Failed to load expense.</div>"
                                );
                            }
                        });

                    });

                });
            </script>
        </body>
    </html>