<?php 
include('menu_cashier.php');
include_once 'model/payments_model.php';

$payments_model = new payments_model();
$sales_model = new sales_model();

// Fetch invoice payments
$invoice_payments = $payments_model->getInvoicePayments($location); // This function will fetch payments from the DB
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Invoice Payments</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <div class="content-wrapper p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Invoice Payments</h3>

            <!-- Filter and Add New Button -->
            <div class="d-flex align-items-center" style="gap: 10px;">
                <input type="text" id="filter_global" class="form-control" placeholder="Search Invoice Payments" style="height: 40px; width:250px;">
                
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="invoicePaymentsTable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Invoice Number</th>
                        <th>Customer</th>
                        <th>Amount Paid</th>
                        <th>Payment Date</th>
                        <th>Payment Method</th>
                        <th>Transaction ID</th>
                        <th>Payment State</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($invoice_payments) > 0): ?>
                        <?php foreach ($invoice_payments as $payment): ?>
                            <tr>
                                <td><?= $payment['id'] ?></td>
                                <td><?= htmlspecialchars($payment['invoice_number']) ?></td>
                                <td><?= htmlspecialchars($payment['customer_name']) ?></td>
                                <td><?= number_format($payment['amount_paid'], 2) ?></td>
                                <td><?= date('d F Y', strtotime($payment['date_paid'])) ?></td>
                                <td><?= $payment['payment_method'] ?></td>
                                <td><?= htmlspecialchars($payment['transaction_id']) ?></td>
                                <td><?= $payment['payment_state'] == 1 ? 'Completed' : 'Pending' ?></td>
                                <td class="text-center">
                                    <a href="individual_invoice_payment_receipt.php?id=<?= $payment['id'] ?>" class="btn btn-info btn-sm" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    
                                    
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" class="text-center">No payments found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
</body>
</html>
