<?php 
include('menu_cashier.php');
include_once 'model/customers_model.php';
include_once 'model/common_model.php';

$customers_model = new customers_model();
$common_model = new common_model();

$customers = $customers_model->getCustomers($location, ['Dealer','Corporate','Individual'], [1,2]); 
$locations = $common_model->getAllLocations(); 
$districts = $common_model->getDistricts(); // <-- NEW
$nationalities = $common_model->getNationalities(); // <-- NEW
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Customers</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <link href="../includes/plugins/select2/css/select2.min.css" rel="stylesheet" />

    <!-- Custom styles -->
    <style>
        .table th, .table td { vertical-align: middle; }
        .modal-content {
            border-radius: 12px;
            overflow: hidden;
        }
        .modal-header {
            background: linear-gradient(90deg, #0f2b33, #0c6174);
            color: #fff;
            border-bottom: none;
        }
        .modal-title {
            font-weight: 600;
            letter-spacing: .5px;
        }
        .fancy-section-title {
            font-size: 15px;
            font-weight: 600;
            color: #0c6174;
            border-left: 4px solid #0c6174;
            padding-left: 8px;
            margin-top: 10px;
            margin-bottom: 5px;
        }
        /* Make Select2 match Bootstrap form-control styling */
.select2-container .select2-selection--single {
    height: 38px !important;
    padding: 6px 12px;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    background-color: #fff !important;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 26px !important;
    color: #495057 !important;
    font-size: 14px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px;
}

/* Focus style same as Bootstrap */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25) !important;
    outline: 0;
}

/* Match input height also for multiple select (if you use it later) */
.select2-container .select2-selection--multiple {
    min-height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}

    </style>
    

    
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Customers</h3>

        <div class="d-flex align-items-center" style="gap: 10px;">
            <input type="text" id="filter_global" class="form-control" placeholder="Search Customers" style="height: 40px; width:250px;">
            
            <button class="btn btn-success d-flex align-items-center" 
                data-toggle="modal" data-target="#addCustomerModal"
                style="height: 40px;">
                <i class="fa fa-plus mr-1"></i> Add Customer
            </button>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover" id="customersTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Customer Name</th>
                    <th>Contact</th>
                    <th>Email</th>
                    <th>Location</th>
                    <th>Customer Type</th>
                    <th class="text-right">Customer Balance</th>
                    <th style="text-align: center;width:17%">Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($customers as $index => $c): ?>
                <tr>
                    <td><?= $index + 1 ?></td>
                    <td><?= htmlspecialchars($c['customer_name']) ?></td>
                    <td><?= htmlspecialchars($c['phone'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($c['email'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($c['location'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($c['type'] ?? '-') ?></td>
                    <td class="text-right"><?= number_format($c['outstanding_balance'], 2) ?></td>
                    <?php 
                    if($c['state'] == 1){ ?>
                        <td class="text-center">
                            <?php 
                                if($c['type'] == 'Individual'){
                                    $url = "customer_account.php?customer_id=".$c['customer_id'];
                                }else if($c['type']== 'Corporate' || $c['type']== 'Dealer'){
                                    $url = "customer_details.php?customer_id=".$c['customer_id'];
                                }else{
                                    $url = "#";
                                }
                            ?>
                            <a class="btn btn-info" title="Details" href="<?= $url ?>">
                                <i class="fa fa-eye"></i>
                            </a>
                            <a class="btn btn-info" title="View Transactions" href="#">
                                <i class="fa fa-list"></i>
                            </a>
                            <a class="btn btn-info" title="Details" href="#">
                                <i class="fa fa-envelope"></i>
                            </a>
                            <a class="btn btn-success" title="Details" href="#">
                                <i class="fab fa-whatsApp"></i>
                            </a>
                            
                            <a href="#" class="btn btn-warning" title="Edit">
                                <i class="fa fa-edit"></i>
                            </a>
                            
                        </td>
                        <?php
                            }else{ ?>
                                <td class="bg-danger">
                                    Waiting Approval
                                </td>
                            <?php 
                                }
                        ?>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>


<!-- Modal: Add Customer -->
<div class="modal fade" id="addCustomerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="addCustomerForm" method="POST" action="controllers/customer_controller.php" enctype="multipart/form-data">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fa fa-user-plus mr-2"></i> Add New Customer
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <i class="fa fa-times"></i>
                    </button>
                </div>

                <div class="modal-body p-4">
                    <input type="hidden" name="action" value="add_customer">
                    <input type="hidden" name="registration_location" value="<?= $location ?>">

                    <div class="row">
                        <!-- LEFT COLUMN (Personal Information) -->
                        <div class="col-md-6">
                            <div class="fancy-section-title">Personal Information</div>

                            <div class="form-group">
                                <label>Full Name</label>
                                <input type="text" name="customer_name" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label>Phone Number</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text p-1">
                                            <img src="../finance/images/malawi.png" height="20">
                                        </span>
                                    </div>
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">+265</span>
                                    </div>
                                    <input type="text" name="phone" id="phone" maxlength="9" class="form-control" required placeholder="999 999 999">
                                </div>
                            </div>

                            <div class="form-group">
                                <label>WhatsApp (Optional)</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fab fa-whatsapp text-success"></i></span>
                                    </div>
                                    <input type="text" name="whatsapp" class="form-control" placeholder="WhatsApp Number">
                                </div>
                            </div>

                            <div class="form-group">
                                <label>Email</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                                    </div>
                                    <input type="email" name="email" class="form-control" placeholder="example@email.com">
                                </div>
                            </div>

                            <div class="form-group">
                                <label>Gender</label>
                                <select name="gender" class="form-control" required>
                                    <option value="">--Select--</option>
                                    <option>Male</option>
                                    <option>Female</option>
                                    <option>Other</option>
                                </select>
                            </div>
                        </div>

                        <!-- RIGHT COLUMN (Customer Details) -->
                        <div class="col-md-6">
                            <div class="fancy-section-title">Customer Details</div>

                            <!-- Customer Type -->
                            <div class="form-group">
                                <label>Customer Type</label>
                                <select name="customer_type" id="customerTypeSelect" class="form-control" required>
                                    <option value="">-- Select Customer Type --</option>
                                    <option value="Individual">Individual Credit Customers</option>
                                    <option value="Dealer">Dealer</option>
                                    <option value="Corporate">Corporate Customer</option>
                                </select>
                            </div>

                            <!-- Location -->
                            <div class="form-group">
                                <label>Location</label>
                                <select name="location" id="locationSelect" class="form-control select2" style="width: 100%;" required>
                                    <option value="">-- Select Location --</option>
                                    <option value="ADD_NEW">➕ Add New Location</option>
                                    <?php foreach($locations as $loc): ?>
                                        <option value="<?= $loc['loc_id'] ?>"><?= $loc['location_name'] ?></option>
                                    <?php endforeach; ?>
                                    
                                </select>
                            </div>

                            <!-- New Location Inputs -->
                            <div id="newLocationFields" style="display:none;">
                                <div class="form-group">
                                    <label>New Location Name</label>
                                    <input type="text" name="new_location_name" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Select District</label>
                                    <select name="new_location_district" class="form-control">
                                        <option value="">--Select District--</option>
                                        <?php foreach($districts as $d): ?>
                                            <option value="<?= $d['id'] ?>"><?= $d['district'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Nationality -->
                            <div class="form-group">
                                <label>Nationality</label>
                                <select name="nationality" class="form-control select2">
                                    <option value="">-- Select Nationality --</option>
                                    <?php foreach ($nationalities as $nationality): ?>
                                        <option value="<?= $nationality['id'] ?>"><?= htmlspecialchars($nationality['country_name']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <!-- Customer Address -->
                            <div class="form-group">
                                <label>Customer Address (Optional)</label>
                                <textarea name="customer_address" class="form-control" rows="3"></textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Individual Fields (show only when "Individual" is selected) -->
                    <div id="individualFields" style="display:none;">
    <div class="fancy-section-title">Individual Creditors Form</div>

    <div class="row">
        <!-- Left column: Spouse/Guarantor -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Spouse/Guarantor Name</label>
                <input type="text" name="spouse_name" class="form-control">
            </div>
        </div>

        <!-- Right column: Spouse Phone -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Spouse/Guarantor Phone Number</label>
                <input type="text" name="spouse_phone" class="form-control">
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Left column: National ID -->
        <div class="col-md-6">
            <div class="form-group">
                <label>National ID Number</label>
                <input type="text" name="national_id" class="form-control">
            </div>
        </div>

        <!-- Right column: Recommended By -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Recommended By</label>
                <input type="text" name="recommended_by" class="form-control">
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Left column: Employer Name -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Employer/Business Name</label>
                <input type="text" name="employer_name" class="form-control">
            </div>
        </div>

        <!-- Right column: Employer Phone -->
        <div class="col-md-6">
            <div class="form-group">
                <label>Employer/Business Phone Number</label>
                <input type="text" name="employer_phone" class="form-control">
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Full width column for ID upload -->
        <div class="col-md-12">
            <div class="form-group">
                <label>Upload National ID (Optional)</label>
                <input type="file" name="national_id_image" class="form-control">
            </div>
        </div>
    </div>
</div>

                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button class="btn btn-success">
                        <i class="fa fa-save mr-1"></i> Save Customer
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>



<!-- jQuery must load first -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>

<!-- Then Bootstrap -->
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- DISABLE ENFORCE-FOCUS (fix for Select2 + Modal) -->
 <script>
    // Listen for changes to the customer type
    document.getElementById('customerTypeSelect').addEventListener('change', function() {
        const customerType = this.value;
        const individualFields = document.getElementById('individualFields');

        // Show or hide the individual fields based on selection
        if (customerType === 'Individual') {
            individualFields.style.display = 'block';
        } else {
            individualFields.style.display = 'none';
        }
    });
</script>

<script>
if ($.fn.modal && $.fn.modal.Constructor) {
    $.fn.modal.Constructor.prototype._enforceFocus = function() {};
}
</script>

<!-- AdminLTE -->
<script src="../includes/dist/js/adminlte.js"></script>

<!-- Select2 -->
<script src="../includes/plugins/select2/js/select2.min.js"></script>
<script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
        <link rel="stylesheet" href="../includes/plugins/daterangepicker/daterangepicker.css">
        <script src="../includes/plugins/moment/moment.min.js"></script>
        <script src="../includes/plugins/daterangepicker/daterangepicker.js"></script>

<!-- Your custom script -->
<script>
$(document).ready(function() {

    // Init select2 outside modal
    $('.select2').select2();

   $('#addCustomerModal').on('shown.bs.modal', function () {
    
    $('#addCustomerModal .select2').each(function() {

        // Destroy old Select2 safely
        if ($(this).data('select2')) {
            $(this).select2('destroy');
        }

        // Re-init with icons + dropdownParent
        $(this).select2({
            dropdownParent: $('#addCustomerModal'),
            templateResult: formatOption,
            templateSelection: formatSelection,
            escapeMarkup: function(m) { return m; } // allow HTML
        });

    });

});




// Template for dropdown list
function formatOption(option) {
    if (!option.id) {
        return option.text; // placeholder
    }

    let icon = $(option.element).data('icon');
    
    if (icon) {
        return $('<span><i class="' + icon + ' mr-2"></i>' + option.text + '</span>');
    }

    return option.text;
}

// Template for selected value
function formatSelection(option) {
    if (!option.id) {
        return option.text;
    }

    let icon = $(option.element).data('icon');

    if (icon) {
        return $('<span><i class="' + icon + ' mr-2"></i>' + option.text + '</span>');
    }

    return option.text;
}



    // Handle location adding + required validation
$('#locationSelect').on('change', function () {
    var selectedValue = $(this).val();

    if (selectedValue === 'ADD_NEW') {

        // Show the new-location fields
        $('#newLocationFields').show();

        // Make new location fields mandatory
        $('input[name="new_location_name"]').attr('required', true);
        $('select[name="new_location_district"]').attr('required', true);

    } else {

        // Hide the fields
        $('#newLocationFields').hide();

        // Remove required attribute
        $('input[name="new_location_name"]').removeAttr('required');
        $('select[name="new_location_district"]').removeAttr('required');
    }
});


    // Table search
    $("#filter_global").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#customersTable tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
    });

});
</script>

<script>

           

let table;

$(document).ready(function () {

    table = $('#customersTable').DataTable({
        paging: true,
        pageLength: 25  ,
        lengthChange: false,
        ordering: true,
        order: [[6, 'desc'], [1, 'asc']], // Order by Customer Balance desc, then Name asc
        info: true,
        searching: true,
        responsive: true,
        autoWidth: false,
        dom: 'rtip',
        columnDefs: [
        {
            targets: 6, // Status column
            render: function (data, type) {
                if (type === 'filter' || type === 'search') {
                    // strip HTML and return plain text
                    return $('<div>').html(data).text().trim();
                }
                return data; // display unchanged
            }
        }
    ]
    });

    // INITIAL TOTALS (important)
    calculateTotals();

    // Recalculate totals on every draw
    table.on('draw', function () {
        calculateTotals();
    });

    // Global search
    $('#globalSearch').on('keyup', function () {
        table.search(this.value).draw();
    });

    // Sale Type filter
    $('#filterSaleType').on('change', function () {
        table.column(2).search(this.value).draw();
    });

    $('#filterStatus').on('change', function () {
    let val = this.value;

    if (val) {
        table.column(6)
            .search('^' + val + '$', true, false)
            .draw();
    } else {
        table.column(6).search('').draw();
    }
});




});

function calculateTotals() {

    let totalAmount = 0;
    let totalPaid = 0;
    let totalDiscount =0;
    let totalBalance = 0;

    table.rows({ search: 'applied' }).every(function () {

        let data = this.data();

        totalAmount   += parseFloat(data[5].replace(/,/g, '')) || 0;
        totalPaid     += parseFloat(data[6].replace(/,/g, '')) || 0;
        totalDiscount += parseFloat(data[7].replace(/,/g, '')) || 0;
        totalBalance  += parseFloat(data[8].replace(/,/g, '')) || 0;
    });

    $('#totalAmount').text(totalAmount.toLocaleString(undefined, { minimumFractionDigits: 2 }));
    $('#totalPaid').text(totalPaid.toLocaleString(undefined, { minimumFractionDigits: 2 }));
    $('#totalDiscount').text(totalDiscount.toLocaleString(undefined, { minimumFractionDigits: 2 }));
    $('#totalBalance').text(totalBalance.toLocaleString(undefined, { minimumFractionDigits: 2 }));
}   
</script>





</body>
</html>
