<?php 
include('menu_cashier.php');
include_once 'model/banking_model.php';

$banking_model = new banking_model();
$accounts = $banking_model->getAccounts();

// Totals for dashboard
$total_cash_sales     = $banking_model->getTotalCashSales($location);
$total_cash_deposited = $banking_model->getTotalCashDeposited($location);
$recorded_expenses    = $banking_model->getRecordedExpenses($location);
$outstanding_cash     = $total_cash_sales - ($total_cash_deposited + $recorded_expenses);
if ($outstanding_cash < 0) $outstanding_cash = 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Cash Deposit</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">
<div class="container-fluid">

    <!-- Page Header -->
    <div class="row mb-3">
        <div class="col-sm-6">
            <h3 class="m-0 text-dark">
                <i class="fas fa-university mr-2"></i>
                Cash Deposit Transaction
            </h3>
        </div>
    </div>

    <!-- SUMMARY CARDS -->
    <div class="row mb-4">

        <div class="col-md-3">
            <div class="small-box bg-success">
                <div class="inner">
                    <h4>MWK <?= number_format($total_cash_sales,2) ?></h4>
                    <p>Total Cash Sales</p>
                </div>
                <div class="icon">
                    <i class="fas fa-cash-register"></i>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h4>MWK <?= number_format($recorded_expenses,2) ?></h4>
                    <p>Recorded Expenses</p>
                </div>
                <div class="icon">
                    <i class="fas fa-university"></i>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h4>MWK <?= number_format($total_cash_deposited,2) ?></h4>
                    <p>Total Deposited</p>
                </div>
                <div class="icon">
                    <i class="fas fa-university"></i>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h4>MWK <?= number_format($outstanding_cash,2) ?></h4>
                    <p>Outstanding To Deposit</p>
                </div>
                <div class="icon">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
            </div>
        </div>

    </div>

    <div class="row">

    <!-- LEFT COLUMN: Deposit Form -->
    <div class="col-md-6">
        <div class="card card-primary shadow-sm">
            <div class="card-header bg-primary text-white">
                <h3 class="card-title"><i class="fas fa-university"></i> Deposit Details</h3>
            </div>

            <form method="POST" action="controllers/banks_controller.php">
                <input type="hidden" name="action" value="create_deposit">
                <input type="hidden" name="location" value="<?= $location ?>">

                <div class="card-body">

                    <!-- Row 1: Deposit Date + Account Deposited -->
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label><i class="fas fa-calendar-alt"></i> Deposit Date (stamp date)</label>
                            <input type="date" name="deposit_date" max="<?= date('Y-m-d') ?>" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label><i class="fas fa-university"></i> Account Deposited To</label>
                            <select name="account_id" class="form-control" required>
                                <option value="">Select Account</option>
                                <?php foreach($accounts as $acc): ?>
                                    <option value="<?= $acc['account_id'] ?>">
                                        <?= $acc['account_name'] ?> - <?= $acc['account_number'] ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Row 2: Reference Number + Amount -->
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label><i class="fas fa-hashtag"></i> Reference Number</label>
                            <input type="text" name="reference_number" class="form-control" placeholder="Transaction/deposit slip No.">
                        </div>
                        <div class="form-group col-md-6">
                            <label><i class="fas fa-money-bill-wave"></i> Amount To Deposit (Cash Only)</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">MWK</span>
                                </div>
                                <input type="number" 
                                    step="0.01" 
                                    min="0"
                                    max="<?= $outstanding_cash ?>"
                                    name="amount" 
                                    placeholder="Amount deposited"
                                    class="form-control" 
                                    required>
                            </div>
                            <small class="text-muted">
                                Maximum deposit allowed: MWK <?= number_format($outstanding_cash,2) ?>
                            </small>
                        </div>
                    </div>

                    <!-- Row 3: Deposited By + Description -->
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label><i class="fas fa-user"></i> Deposited By</label>
                            <input type="text" name="deposited_by" placeholder="Bank Tailor/shop assistant" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label><i class="fas fa-align-left"></i> Description / Narration</label>
                            <textarea name="description" class="form-control" rows="4" placeholder="Enter deposit details..."></textarea>
                        </div>
                    </div>

                </div>

                <div class="card-footer text-right">
                    <button type="reset" class="btn btn-secondary">
                        <i class="fas fa-undo"></i> Reset
                    </button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check-circle"></i> Confirm Deposit
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- RIGHT COLUMN: Deposit History -->
    <div class="col-md-6">
        <div class="card card-info shadow-sm">
            <div class="card-header bg-info text-white">
                <h3 class="card-title"><i class="fas fa-history"></i> Last 10 Deposits</h3>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive" style="max-height: 400px; overflow-y:auto;">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th><i class="fas fa-calendar-alt"></i> Date</th>
                                <th><i class="fas fa-money-bill-wave"></i> Amount</th>
                                <th><i class="fas fa-hashtag"></i> Ref No.</th>
                                <th><i class="fas fa-user"></i> Deposited By</th>
                                <th><i class="fas fa-align-left"></i> Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Fetch last 10 deposits for this location
                            $deposits = $banking_model->getLastDeposits($location, 10);
                            if(!empty($deposits)):
                                foreach($deposits as $dep):
                            ?>
                                <tr>
                                    <td><?= date('d M Y', strtotime($dep['date_deposited'])) ?></td>
                                    <td class="text-right">MWK <?= number_format($dep['amount_deposited'],2) ?></td>
                                    <td><?= $dep['reference_number'] ?></td>
                                    <td><?= htmlspecialchars($dep['deposited_by']) ?></td>
                                    <td><?= htmlspecialchars($dep['description']) ?></td>
                                </tr>
                            <?php
                                endforeach;
                            else:
                            ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">
                                        No deposits found.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>

</div>
</div>

<!-- SCRIPTS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>

</body>
</html>