<!DOCTYPE html>
<html lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" href="images/favicon.png" type="image/ico" />
  <title>Powertex LTD</title>

  <?php include_once 'css_links.php'; ?>
  <style>
    /* Align search area nicely */
#bankTable_wrapper .dt-search {
  display: flex;
  justify-content: flex-end;
  align-items: center;
  gap: 10px;
}

/* Fix label spacing */
#bankTable_wrapper .dt-search label {
  margin: 0;
  font-weight: normal;
}

/* Fix search input */
#bankTable_wrapper .dt-search .dt-input {
  margin-left: 6px;
}

/* Space the status dropdown */
#statusFilter {
  margin-left: 10px;
  min-width: 150px;
}

#bankTable_wrapper .dt-search .dt-input,
#statusFilter {
  height: 30px;
}

/* restore spacing inside button group */
#bankTable .btn-group {
  display: inline-flex;
  gap: 7px; /* adjust to taste */
}

/* prevent Bootstrap from merging borders */
#bankTable .btn-group .btn {
  border-radius: 3px !important;
}
#bankTable td:last-child {
  white-space: nowrap;
}
</style>
</head>

<body class="nav-md">
<div class="container body">
  <div class="main_container">

    <?php
    include 'menu_finance.php';
    include_once 'model/banking_model.php';

    $banking_model = new banking_model();
    $accounts = $banking_model->getBankAccounts();
    ?>

    <div class="right_col" role="main">
      <div class="">

        <!-- PAGE TITLE -->
        <div class="page-title">
          <div class="title_left">
            <h3>
              <i class="fa fa-university"></i> Accounts Management
            </h3>
          </div>
        </div>

        <div class="clearfix"></div>

        <div class="row">
          <div class="col-md-12 col-sm-12">

            <?php
            $totalAccounts = count($accounts);
            $activeAccounts = 0;
            $inactiveAccounts = 0;

            foreach ($accounts as $acc) {
              if ($acc['account_state'] == 1) {
                $activeAccounts++;
              } else {
                $inactiveAccounts++;
              }
            }
            ?>

            <!-- SUMMARY CARDS -->
            <div class="row tile_count">

              <div class="col-md-4 col-sm-4 col-xs-12 tile_stats_count">
                <span class="count_top"><i class="fa fa-database"></i> Total Accounts</span>
                <div class="count"><?php echo $totalAccounts; ?></div>
              </div>

              <div class="col-md-4 col-sm-4 col-xs-12 tile_stats_count">
                <span class="count_top"><i class="fa fa-check-circle text-success"></i> Active</span>
                <div class="count text-success"><?php echo $activeAccounts; ?></div>
              </div>

              <div class="col-md-4 col-sm-4 col-xs-12 tile_stats_count">
                <span class="count_top"><i class="fa fa-times-circle text-danger"></i> Inactive</span>
                <div class="count text-danger"><?php echo $inactiveAccounts; ?></div>
              </div>

            </div>

            <div class="x_panel">
              <div class="x_title">
                <h2><i class="fa fa-bank"></i> Bank Accounts</h2>

                <ul class="nav navbar-right panel_toolbox">
                  <li>
                    <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addAccountModal">
                      <i class="fa fa-plus"></i> Add New Account
                    </button>
                  </li>
                </ul>

                <div class="clearfix"></div>
              </div>

              <div class="x_content">



                <table id="bankTable" class="table table-striped table-bordered table-hover jambo_table">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Bank Name</th>
                      <th>Account Name</th>
                      <th>Account Number</th>
                      <th>Status</th>
                      <th style="width:120px; text-align:center;">Actions</th>
                    </tr>
                  </thead>
                  <tbody>

                  <?php if(!empty($accounts)) { ?>
                    <?php foreach($accounts as $index => $account) { ?>
                      <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td><?php echo $account['bank_name']; ?></td>
                        <td><?php echo $account['account_name']; ?></td>
                        <td><?php echo $account['account_number']; ?></td>

                        <td style="background-color: <?php echo ($account['account_state'] == 1) ? '#d4edda' : '#f8d7da'; ?>;
                            color: <?php echo ($account['account_state'] == 1) ? '#155724' : '#721c24'; ?>;
                            font-weight: bold;
                            text-align: center;
                        ">
                            <?php echo ($account['account_state'] == 1) ? 'Active' : 'Inactive'; ?>
                        </td>

                        <td style="text-align:center; white-space:nowrap;">
                          <div class="btn-group">

                            <!-- Edit Button -->
                            <button class="btn btn-primary btn-sm edit-account-btn" 
                                    data-id="<?php echo $account['account_id']; ?>" 
                                    data-bank_name="<?php echo htmlspecialchars($account['bank_name']); ?>" 
                                    data-account_name="<?php echo htmlspecialchars($account['account_name']); ?>" 
                                    data-account_number="<?php echo htmlspecialchars($account['account_number']); ?>">
                              <i class="fa fa-pencil-square-o"></i>
                            </button>

                            <!-- Suspend / Enable Button -->
                            <?php if($account['account_state'] == 1): ?>
                              <!-- Active: show Suspend -->
                              <button class="btn btn-danger btn-sm suspend-account-btn"
                                      data-id="<?php echo $account['account_id']; ?>"
                                      data-state="0">
                                <i class="fa fa-ban"></i>
                              </button>
                            <?php else: ?>
                              <!-- Inactive: show Enable -->
                              <button class="btn btn-success btn-sm suspend-account-btn"
                                      data-id="<?php echo $account['account_id']; ?>"
                                      data-state="1">
                                <i class="fa fa-check"></i>
                              </button>
                            <?php endif; ?>

                            <!-- Settings Button -->
                            <button class="btn btn-info btn-sm" onclick="showDisabledNotification()">
                              <i class="fa fa-cog"></i>
                            </button>

                          </div>
                        </td>

                      </tr>
                    <?php } ?>
                  <?php }  ?>

                  </tbody>
                </table>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <?php include_once 'footer.php'; ?>
  </div>

  <?php include_once 'libraries.php'; ?>

  <!-- ADD ACCOUNT MODAL -->
  <div class="modal fade" id="addAccountModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">

        <form method="post" action="controllers/banks_controller.php">

          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title"><i class="fa fa-plus"></i> Add New Bank Account</h4>
          </div>

          <div class="modal-body">

            <div class="form-group">
              <label>Bank Name</label>
              <input type="text" name="bank_name" class="form-control" required>
              <input type="hidden" name="action" value="add_bank">
            </div>

            <div class="form-group">
              <label>Account Name</label>
              <input type="text" name="account_name" class="form-control" required>
            </div>

            <div class="form-group">
              <label>Account Number</label>
              <input type="text" name="account_number" class="form-control" required>
            </div>

            <div class="form-group">
              <label>Status</label>
              <select name="status" class="form-control">
                <option value="1">Active</option>
                <option value="0">Inactive</option>
              </select>
            </div>

          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Save Account</button>
          </div>

        </form>

      </div>
    </div>
  </div>

  <!-- Update Bank Modal -->
<div class="modal fade" id="editBankModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="controllers/banks_controller.php">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title"><i class="fa fa-pencil-square-o"></i> Edit Bank Account</h4>
        </div>
        <div class="modal-body">
          <input type="hidden" name="action" value="update_bank">
          <input type="hidden" id="edit_bank_id" name="id">
          
          <div class="form-group">
            <label>Bank Name</label>
            <input type="text" id="edit_bank_name" name="bank_name" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Account Name</label>
            <input type="text" id="edit_account_name" name="account_name" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Account Number</label>
            <input type="text" id="edit_account_number" name="account_number" class="form-control" required>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Update Account</button>
        </div>
      </form>
    </div>
  </div>
</div>
  <!-- TOASTR NOTIFICATION -->
  <script>
    function showDisabledNotification() {
      toastr["warning"]("This feature is currently disabled.", "Feature Disabled");
    }
  </script>

  <!-- DATATABLES INIT -->
  <script>
 $(document).ready(function () {

  var table = $('#bankTable').DataTable({
    pageLength: 10,
    lengthChange: false,

    columnDefs: [
      { targets: 5, orderable: false, searchable: false, width: "120px" }
    ],

    // ✅ Correct Bootstrap 3 layout
    dom:
      "<'row'<'col-sm-6'f><'col-sm-6'>>" +
      "rt" +
      "<'row'<'col-sm-5'i><'col-sm-7'p>>",

    initComplete: function () {

      var statusFilter = $(
        '<select id="statusFilter" class="form-control input-sm" ' +
        'style="width:160px; display:inline-block; margin-left:8px;">' +
          '<option value="">All</option>' +
          '<option value="Active">Active</option>' +
          '<option value="Inactive">Inactive</option>' +
        '</select>'
      );

      // ✅ Append next to default search
      $('#bankTable_filter').append(statusFilter);

      $('#statusFilter').on('change', function () {
        table.column(4).search(this.value).draw();
      });

    }

  });

});

$(document).ready(function() {

  // Open Edit Modal
  $('#bankTable').on('click', '.edit-account-btn', function() {
    const button = $(this);

    // Fill modal inputs
    $('#edit_bank_id').val(button.data('id'));
    $('#edit_bank_name').val(button.data('bank_name'));
    $('#edit_account_name').val(button.data('account_name'));
    $('#edit_account_number').val(button.data('account_number'));

    // Show modal
    $('#editBankModal').modal('show');
  });

});
  </script>
  <script>
$(document).ready(function() {

    $('.suspend-account-btn').on('click', function() {
        var button = $(this);
        var accountId = button.data('id');
        var targetState = button.data('state');

        // Determine title, text, and confirm button dynamically
        var swalTitle = (targetState == 0) ? 'Suspend Account?' : 'Enable Account?';
        var swalText = (targetState == 0) 
            ? 'This account will be suspended and will no longer be used for deposits.'
            : 'This account will be enabled and can now be used for deposits.';
        var confirmText = (targetState == 0) ? 'Yes, suspend it!' : 'Yes, enable it!';
        var confirmColor = (targetState == 0) ? '#d33' : '#28a745'; // red for suspend, green for enable

        Swal.fire({
            title: swalTitle,
            text: swalText,
            icon: 'warning',
            showCancelButton: true,
            reverseButtons: true,
            confirmButtonColor: confirmColor,
            cancelButtonColor: '#3085d6',
            confirmButtonText: confirmText,
            cancelButtonText: 'No, cancel'
        }).then((result) => {
            if (result.isConfirmed) {

                // disable button to prevent multiple clicks
                button.prop('disabled', true);

                // send request to controller
                $.post('controllers/banks_controller.php', {
                    action: 'change_account_state',
                    id: accountId,
                    state: targetState
                }, function(response) {
                    try {
                        var data = JSON.parse(response);

                        if (data.success) {
                            Swal.fire(
                                (targetState == 0) ? 'Suspended!' : 'Enabled!',
                                data.message,
                                'success'
                            ).then(() => {
                                location.reload(); // reload to see changes
                            });
                        } else {
                            Swal.fire(
                                'Error!',
                                data.message,
                                'error'
                            );
                            button.prop('disabled', false); // re-enable on error
                        }

                    } catch (e) {
                        Swal.fire(
                            'Error!',
                            'Unexpected response from server.',
                            'error'
                        );
                        button.prop('disabled', false);
                    }
                });

            }
        });
    });

});
</script>

</body>
</html>