<?php
// Include necessary files, database models, and other required setups
include_once 'model/orders_model.php';  // Assuming you have an invoice model
include_once 'model/customers_model.php';  // If necessary for fetching customer details

$orders_model = new orders_model();
$customers_model = new customers_model();

// Fetch open invoices
$cancelled_invoices = $orders_model->getCancelledInvoices();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.png" type="image/ico" />
    <title>Powertex LTD - Cancelled Invoices</title>
    <?php include_once 'css_links.php'; ?>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <?php include 'menu_finance.php'; ?>

            <!-- page content -->
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title">
                        <div class="title_left">
                            <h3><small>Invoices </small></h3>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="row">
                        <div class="col-md-12 col-sm-12 ">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                    <!-- Left side: Title -->
                                    <div>
                                        <h2 class="mb-0">Cancelled Invoices</h2>
                                    </div>

                                    <!-- Center: Title -->
                                    <div class="text-center flex-grow-1">
                                        <h5 class="mb-0">Cancelled Invoices Overview</h5>
                                    </div>

                                    <!-- Right side: Back Button -->
                                    <ul class="nav navbar-right panel_toolbox mb-0">
                                        <li>
                                            <a class="dropdown-item" href="dashboard.php">
                                                <button class="btn btn-secondary btn-sm">
                                                    <i class="fa fa-arrow-left"></i> Back
                                                </button>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="clearfix"></div>

                                <div class="x_content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card-box table-responsive">                                                          
                                                <?php if (!empty($cancelled_invoices)) { ?>
                                                    <table class="table table-bordered table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th>Invoice Date</th>
                                                                <th>Invoice Number</th>
                                                                <th>Customer Name</th>
                                                                <th>Date Cancelled</th>
                                                                <th>Reason For Cancellation</th>
                                                                <th>Status</th>                                                                
                                                                <th>Invoice Amount</th>
                                                                <th style="text-align: center;">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($cancelled_invoices as $invoice) { ?>
                                                                <tr>
                                                                    
                                                                    <td><?php echo date('d F Y', strtotime($invoice['orderdate'])); ?></td>
                                                                    <td><?php echo htmlspecialchars($invoice['order_number']); ?></td>
                                                                    <td><?php echo htmlspecialchars($invoice['customer_name']); ?></td>
                                                                    <td><?php echo date('d F Y', strtotime($invoice['date_cancelled'])); ?></td>
                                                                    <td style="text-align: left;"><?php echo $invoice['reason']; ?></td>
                                                                    <td class="<?php
                                                                        // Adding color-coding based on invoice status
                                                                        $status = $invoice['invoice_state'];
                                                                        switch ($status) {
                                                                            case 0:
                                                                                echo 'bg-warning text-dark'; // Pending or unpaid invoices
                                                                                break;
                                                                            case 1:
                                                                                echo 'bg-info text-dark'; // Pending or unpaid invoices
                                                                                break;
                                                                            case 2:
                                                                                echo 'bg-success text-white'; // Paid invoices
                                                                                break;
                                                                            case 3:
                                                                                echo 'bg-danger text-white'; // Cancelled invoices
                                                                                break;
                                                                            default:
                                                                                echo '';
                                                                        }
                                                                    ?>">
                                                                        <?php echo htmlspecialchars(ucfirst($invoice['invoice_status'])); ?>
                                                                    </td>
                                                                    <td style="text-align: right;">
                                                                        <?php echo number_format($invoice['total_bill'], 2); ?>
                                                                    </td>
                                                                    <td style="text-align: center;">
                                                                        <?php
                                                                            $url = "invoice.php?invoice_number=" . $invoice['order_number'];
                                                                        ?>

                                                                        <a href="<?php echo $url; ?>" class="btn btn-info btn-sm" title="View Invoice Details">
                                                                            <i class="fa fa-receipt"></i>
                                                                        </a>
                                                                        <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                            <button class="btn btn-info btn-sm">
                                                                                <i class="fa fa-cog"></i>
                                                                            </button>
                                                                        </a>
                                                                    </td>
                                                                    
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                    </table>
                                                <?php } else { ?>
                                                    <div class="alert alert-info">
                                                        No Cancelled invoices available.
                                                    </div>
                                                <?php } ?>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /page content -->

            <?php include_once 'footer.php'; ?>
        </div>
    </div>

    <?php include_once 'libraries.php'; ?>
    <script>
        function showDisabledNotification() {
            const type = 'warning';
            const title = 'Feature Disabled';
            const message = 'This feature is currently disabled.';

            toastr[type](message, title);
        }
    </script>
</body>
</html>
