<?php
// Include necessary files, database models, and other required setups
include_once 'model/sales_model.php';  // Assuming you have a sales model
$sales_model = new sales_model();
$cash_sales = $sales_model->getcancelledPayments(); // Fetch daily sales data
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD - Cash Sales</title>
        <?php
            include_once 'css_links.php';
        ?>
    </head>

    <body class="nav-md">
        <div class="container body">
            <div class="main_container">

                <?php
                    include 'menu_finance.php';
                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="page-title">
                            <div class="title_left">
                                <h3><small>Sales </small></h3>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 ">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                        <!-- Left side: Title -->
                                        <div>
                                            <h2 class="mb-0">Manage Cash Sales</h2>
                                        </div>

                                        <!-- Center: Title -->
                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Sales Overview</h5>
                                        </div>

                                        <!-- Right side: Back Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                                <a class="dropdown-item" href="dashboard.php">
                                                    <button class="btn btn-secondary btn-sm">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="x_content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="card-box table-responsive">                                                          
                                                    <?php if (!empty($cash_sales)) { ?>
                                                        <table class="table table-bordered table-sm" id="cashSalesTable">
                                                            <thead>
                                                                <tr>
                                                                    <th style="text-align: center;">Transaction Date</th>
                                                                    <th>Customer Name</th>
                                                                    <th>Order Type</th>
                                                                    <th>Payment Method</th>
                                                                    <th>Transaction ID</th>
                                                                    <th>Cancelled By</th>
                                                                    <th>Reason</th>
                                                                    <th>Total Amount</th>
                                                                    <th>Sale Status</th>
                                                                    <th>Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach ($cash_sales as $sale) { ?>
                                                                    <tr>
                                                                        <td style="text-align: left;" data-order="<?= strtotime($sale['sale_date']) ?>">
                                                                            <?= date('d F Y H:i', strtotime($sale['sale_date'])) ?>
                                                                        </td>

                                                                        <td><?php echo htmlspecialchars($sale['customer_name']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['payment_type']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['payment_method']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['original_transaction_id']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['cancelled_by_operator']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['reason']); ?></td>
                                                                        <td style="text-align: right;">
                                                                            <?php echo number_format($sale['total_sales_amount'], 2); ?>
                                                                        </td>
                                                                        <td class="<?php
                                                                            $status = $sale['sale_status'];
                                                                            switch ($status) {
                                                                                case '0':
                                                                                    echo 'bg-success text-white';
                                                                                    break;
                                                                                case '1':
                                                                                    echo 'bg-danger text-white';
                                                                                    break;
                                                                                default:
                                                                                    echo '';
                                                                            }
                                                                        ?>">
                                                                            <span style="display: none;"><?php echo $sale['sale_status']; ?></span>
                                                                            <?php echo htmlspecialchars(ucfirst($sale['payment_status'])); ?>
                                                                        </td>

                                                                        <td>
                                                                            <?php
                                                                                $order_type = $sale['payment_type'];
                                                                                $cancel_state = $sale['sale_status'];
                                                                                $sale_id = $sale['sale_id'];

                                                                                // Determine the appropriate URL based on the order_type
                                                                                if ($order_type == 'Cash Sale') {
                                                                                    $url = "cash_sale_receipt.php?id=" . $sale['tx_id'];
                                                                                } elseif ($order_type == 'Customer Order') {
                                                                                    $url = "invoice_payment_receipt.php?receipt_number=" . $sale['receipt_number'];
                                                                                } else {
                                                                                    
                                                                                }
                                                                            ?>

                                                                                <a href="<?php echo $url; ?>" class="btn btn-info btn-sm" title="View Sale Receipt">
                                                                                    <i class="fa fa-receipt"></i>
                                                                                </a>

                                                                                <!-- Cancel/Resume Button based on payment state -->
                                                                                <?php if ($cancel_state == 1): ?>
                                                                                    <button 
                                                                                        class="btn btn-success btn-sm restore-payment" 
                                                                                        data-sale-id="<?= $sale_id ?>" 
                                                                                        data-action="restore"
                                                                                        data-customer="<?= htmlspecialchars($sale['customer_name']) ?>"
                                                                                        data-payment_method="<?= htmlspecialchars($sale['payment_method']) ?>"
                                                                                        data-amount="<?= number_format($sale['total_sales_amount'], 2) ?>"
                                                                                        data-receipt_number="<?= $sale['receipt_number'] ?>"
                                                                                        data-date="<?= date('d M Y H:i', strtotime($sale['sale_date'])) ?>"
                                                                                        data-transaction="<?= $sale['transction_id'] ?>"
                                                                                        title="Cancel Payment">
                                                                                        <i class="fa fa-check-circle"></i>
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                                <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                                    <button class="btn btn-info btn-sm">
                                                                                        <i class="fa fa-cog"></i>
                                                                                    </button>
                                                                                </a>
                                                                        </td>
                                                                    </tr>
                                                                <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    <?php } else { ?>
                                                        <div class="alert alert-info">
                                                            No cancelled payments data available.
                                                        </div>
                                                    <?php } ?>
                                                  
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->

                <?php
                    include_once 'footer.php';
                ?>
            </div>
        </div>

        <?php
            include_once 'libraries.php';
        ?>
        <script>
            function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
        </script>
        <script>
            $(document).ready(function () {
                $('#cashSalesTable').DataTable({
                    order: [
                        [6, 'desc'], // First: payment_state (1 at top)
                        [0, 'desc']  // Second: sale date (latest first)
                    ],
                    pageLength: 25,
                    responsive: true,
                    language: {
                        searchPlaceholder: "Search any field...",
                        search: ""
                    }
                });
            });
        </script>

        <script>
            $(document).on('click', '.restore-payment', function () {
                const receiptNumber = $(this).data('receipt_number');
                const saleId = $(this).data('sale-id');
                const customer = $(this).data('customer');
                const amount = $(this).data('amount');
                const date = $(this).data('date');
                const transaction = $(this).data('transaction');
                const payment_method = $(this).data('payment_method');
                $payment_state = 1;

                const detailsHtml = `
                    <div style="text-align: left;">
                        <p><strong>Customer:</strong> ${customer}</p>
                        <p><strong>Amount:</strong> ${amount}</p>
                        <p><strong>Date:</strong> ${date}</p>
                        <p><strong>Payment Method:</strong> ${payment_method}</p>
                        <p><strong>Transaction ID:</strong> ${transaction}</p>
                    </div>`;

                Swal.fire({
                    title: 'Restore payment?',
                    html: detailsHtml,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Restore',
                    cancelButtonText: 'No, go back'
                }).then((result) => {
                    if (result.isConfirmed) {
                        const targetUrl = `controllers/sales_controller.php?status=${$payment_state}&action=restorepayment&receipt_number=${receiptNumber}`;
                        window.location.href = targetUrl;
                    }
                });
            });


        </script>





    </body>
</html>
