<?php
    // Detect current script name (e.g., invoice.php, cash_sale_receipt.php)
    $current_page = basename($_SERVER['PHP_SELF']);

    // Prepare variable placeholders
    $query_params = '';
    $customer_id = $customer_id ?? null;

    // Map parameter based on page type
    if ($current_page === 'invoice_payment_receipt.php' && isset($receipt_number)) {
        $query_params = "receipt_number=$receipt_number&source=invoice_payment_receipt";
    } elseif ($current_page === 'invoice.php' && isset($invoice_number)) {
        $query_params = "invoice_number=$invoice_number&source=invoice";
    } elseif ($current_page === 'cash_sale_receipt.php' && isset($_GET['id'])) {
        $query_params = "id=$transaction_id&source=cash_sale_receipt";
    }

    if ($customer_id) {
        $query_params .= "&customer_id=$customer_id";
    }
?>

<li>
    <a href="send_whatsapp_handler.php?<?= $query_params ?>" title="Send to WhatsApp">
        <button class="btn btn-success btn-sm">
            <i class="fab fa-whatsapp"></i>
        </button>
        
    </a>
</li>

<li>
    <a href="email_invoice_handler.php?<?= $query_params ?>" title="Email Customer">
        <button class="btn btn-info btn-sm">
           <i class="fa fa-envelope"></i>
        </button>
    </a>
</li>

<li>
    <button class="btn btn-primary btn-sm print-btn" title="Print Document">
        <i class="fa fa-print"></i> Print
    </button>
</li>
