<?php
session_start();
include_once '../model/banking_model.php';
date_default_timezone_set('Africa/Blantyre');

$banking_model = new banking_model();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {

    $action = $_POST['action'];

    switch ($action) {

        case 'add_bank':
            addBankAccount($banking_model);
        break;

        case 'update_bank':
            updateBankAccount($banking_model);
        break;

        case 'change_account_state':
            changeAccountState($banking_model);
        break;

        case 'cancel_deposit':
            cancelDeposit($banking_model);  
        break;
    }
}

function cancelDeposit($banking_model) {
    $id = intval($_POST['id']);

    $result = $banking_model->cancelDeposit($id);

    echo json_encode([
        'success' => $result,
        'message' => $result ? 'Deposit cancelled successfully.' : 'Unable to cancel.'
    ]);
}

function changeAccountState($banking_model) {
    $id = $_POST['id'] ?? null;
    $state = isset($_POST['state']) ? intval($_POST['state']) : null;

    if (!$id || $state === null) {
        echo json_encode(['success' => false, 'message' => 'Invalid data']);
        exit;
    }

    $success = $banking_model->updateBankState($id, $state);

    if ($success) {
        echo json_encode(['success' => true, 'message' => 'Account state updated']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update account']);
    }

    exit;
}

function updateBankAccount($banking_model) {
    $id = $_POST['id'] ?? null;
    $bank_name = trim($_POST['bank_name'] ?? '');
    $account_name = trim($_POST['account_name'] ?? '');
    $account_number = trim($_POST['account_number'] ?? '');

    if (!$id || !$bank_name || !$account_name || !$account_number) {
        $_SESSION['notification'] = [
            'title' => 'Error',
            'type' => 'error',
            'message' => 'All fields are required.'
        ];
        header('Location: ../accounts.php');
        exit;
    }

    $success = $banking_model->updateBank($id, $bank_name, $account_name, $account_number);

    if ($success) {
        $_SESSION['notification'] = [
            'title' => 'Success',
            'type' => 'success',
            'message' => 'Bank account updated successfully.'
        ];
    } else {
        $_SESSION['notification'] = [
            'title' => 'Error',
            'type' => 'error',
            'message' => 'Failed to update bank account.'
        ];
    }

    header('Location: ../accounts.php');
    exit;
}


/* ===============================
   ADD BANK ACCOUNT FUNCTION
=================================*/
function addBankAccount($banking_model)
{
    $bank_name      = trim($_POST['bank_name']);
    $account_name   = trim($_POST['account_name']);
    $account_number = trim($_POST['account_number']);
    $bank_state     = intval($_POST['status']);
    $datecreated    = date('Y-m-d H:i:s');
    $operator       = $_SESSION['sess_employeecode'];

    // Validation
    if (empty($bank_name) || empty($account_name) || empty($account_number)) {

        $_SESSION['notification'] = [
            'type'    => 'error',
            'title'   => 'FAILED',
            'message' => 'Fill all required fields'
        ];

        header("Location: ../bank_accounts.php");
        exit();
    }

    $result = $banking_model->addBankAccount($bank_name, $account_name, $account_number, $bank_state, $datecreated, $operator);

    if ($result) {

        $_SESSION['notification'] = [
            'type'    => 'success',
            'title'   => 'SUCCESS',
            'message' => 'Bank account added successfully'
        ];

    } else {

        $_SESSION['notification'] = [
            'type'    => 'error',
            'title'   => 'FAILED',
            'message' => 'Failed to add bank account'
        ];
    }

    header("Location: ../accounts.php");
    exit();
}
?>