<?php
    session_start();
    date_default_timezone_set('Africa/Blantyre'); // Set your default timezone

    include_once '../model/customers_model.php';
    include_once '../model/common_model.php';

    $customers_model = new customers_model();
    $common_model = new common_model();

    // Check if form was submitted
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        $action = $_POST['action'];
        
        switch($action){
            case 'update_customer':
                updateCustomersDetails($customers_model);
            break;

            case 'deny_customer':
                denyCustomer($customers_model);
            break;

            case 'approve_customer':
                approveTransfer($customers_model);
            break;

            case 'check_duplicate':
                checkIFValuesExist($customers_model);
            break;

            case 'add_customer':
                addCustomer($customers_model, $common_model);
            break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FATAL ERROR!!',
                    'message' => 'Undefined action!!!'
                ];
                header('location:../manage_customers.php');
                exit();
        }
        
    }

    function checkIFValuesExist($customers_model){
        
        $fieldType = $_POST['field_type'];
        $value = $_POST['value'];
        $customer_id = 1;

        // Prepare response
        $response = 'available'; // Default response

        // Check based on field type
        if ($fieldType == 'phone') {
            $exists = $customers_model->checkphoneExists($value);
        } elseif ($fieldType == 'whatsapp') {
            $exists = $customers_model->checkWhatsaAppNumberExists($value);
        } elseif ($fieldType == 'email') {
            $exists = $customers_model->checkEmailExists($value);
        } else {
            $exists = false;
        }

        // If exists, set response to 'exists'
        if ($exists) {
            $response = 'exists';
        }

        // Return response
        echo $response;
        exit;

    }

    function approveTransfer($customers_model) {
        $customer_id = $_POST['customer_id'] ?? '';
        $customer_ty = $_POST['customer_ty'] ?? '';

        if (empty($customer_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Customer ID',
                'message' => 'Customer ID is required to approve a customer.'
            ];
            header("Location: ../managge_customers.php");
            exit();
        }

        $result = $customers_model->approveCustomer($customer_id);

        if ($result) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => 'Customer approved successfully.'
            ];
            if($customer_ty =='Indivdual'){
                header('location:../customer_account.php?customer_id='.$customer_id);
                exit;
            }else{
                header('location:../customer_details.php?customer_id='.$customer_id);
                exit;
            }
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Failed',
                'message' => 'Failed to approve customer.'
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        
    }
    
    function denyCustomer($customers_model) {
        $customer_id = $_POST['customer_id'] ?? '';

        if (empty($customer_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Customer ID',
                'message' => 'Customer ID is required to deny a customer.'
            ];
            header("Location: ../review_customer_approvals.php");
            exit();
        }

        $result = $customers_model->denyCustomer($customer_id);

        if ($result) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => 'Ammendments have been made successfully.'
            ];
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Failed',
                'message' => 'Failed to ammend customer.'
            ];
        }

        header("Location: ../review_customer_approvals.php");
        exit();
    }

    function updateCustomersDetails($customers_model) {
        $customer_id       = $_POST['customer_id'] ?? '';
        $customer_name     = trim($_POST['customer_name'] ?? '');
        
        $raw_phone_number = trim($_POST['contact_number'] ?? '');

        // Ensure it doesn't already start with +265
        if (strpos($raw_phone_number, '+265') !== 0) {
            $phone_number = '+265' . $raw_phone_number;
        } else {
            $phone_number = $raw_phone_number; // already prefixed correctly
        }

        $email_address     = isset($_POST['email']) && (!empty($_POST['email'])) ? trim($_POST['email']): null;
        $gender            = $_POST['gender'] ?? '';
        $location          = $_POST['location'] ?? '';
        $customer_address  = isset($_POST['customer_address']) && (!empty($_POST['customer_address'])) ? trim($_POST['customer_address']) :null;
        $nationality       = isset($_POST['nationality']) && (!empty($_POST['whatsapp_number'])) ? $_POST['whatsapp_number'] : null;
        $type_customer     = trim($_POST['type_customer'] ?? '');
        $customer_state    = $_POST['customer_state'] ?? 1;
        $whatsapp_number   = isset($_POST['whatsapp_number']) && (!empty($_POST['whatsapp_number'])) ? $_POST['whatsapp_number'] : null;
        // Validation
        if (empty($customer_id) || empty($customer_name) || empty($phone_number) || empty($gender) || empty($location)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Fields',
                'message' => 'Please fill in all required fields.'
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        if ($customers_model->phoneExists($phone_number, $customer_id)) {
                $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Phone',
                'message' => 'The entered phone number already exists for another customer.'
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        if ($customers_model->checkWhatappNumber($whatsapp_number, $customer_id)) {
                $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Phone',
                'message' => 'That phone number already registered for a different Client.'
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        // Check if email already exists for another customer
        if (!empty($email_address) && $customers_model->emailExists($email_address, $customer_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Email',
                'message' => 'That email address already exists for another customer.'
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        $data = [
            'customer_id'       => $customer_id,
            'customer_name'     => $customer_name,
            'contact_number'    => $phone_number,
            'email'             => $email_address,
            'gender'            => $gender,
            'location'          => $location,
            'cust_address'      => $customer_address,
            'nationality'       => $nationality,
            'type_customer'     => $type_customer,
            'customer_state'    => $customer_state,
            'whatsapp_number'   => $whatsapp_number
        ];

        $result = $customers_model->updateCustomer($data);

        if ($result) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Updated',
                'message' => 'Customer details updated successfully.'
            ];
            header("Location: ../customer_details.php?customer_id=" . $customer_id);
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Failed',
                'message' => 'Failed to update customer.'
            ];
            header("Location: ../manage_customers.php");
            exit();
        }
    }


    function addCustomer($customers_model, $common_model){
    // Capture form inputs
    $customer_name       = trim($_POST['customer_name']);
    $phone = trim($_POST['phone']);

    // Remove any leading zeros or non-digit characters
    $phone = preg_replace('/[^0-9]/', '', $phone);

    // Ensure it starts with +265
    if (substr($phone, 0, 3) !== '265') {
        // Remove leading 0 if present
        if (substr($phone, 0, 1) === '0') {
            $phone = substr($phone, 1);
        }
        $phone = '265' . $phone;
    }

    // Add the + sign
    $phone = '+' . $phone;

    $whatsapp            = trim($_POST['whatsapp']);
    $email = isset($_POST['email']) && trim($_POST['email']) !== ''  ? strtolower(trim($_POST['email'])) : null;
    $gender              = trim($_POST['gender']);
    $customer_type       = trim($_POST['customer_type']);
    $location            = $_POST['location'];
    // Normalize nationality (optional field)
    $nationality = !empty($nationality) ? (int)$nationality : null;

    $customer_address    = trim($_POST['customer_address']);

    // Handle adding a NEW location
    if ($location === "ADD_NEW") {

        $new_location_name     = trim($_POST['new_location_name']);
        $new_location_district = trim($_POST['new_location_district']);
        $loc_id                = $common_model->getNextLocationId();
        $loc_state             = 1; // Active state

        // Validation for new location
        if ($new_location_name === "" || $new_location_district === "") {
            $_SESSION['notification'] = [
                "type" => "error",
                "title" => "Missing Fields",
                "message" => "New location name and district are required."
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        // Insert new location
        $insert_location_success = $common_model->addNewLocation($loc_id, $new_location_name, $new_location_district, $loc_state);

        // Ensure insertion succeeded
        if (!$insert_location_success) {
            $_SESSION['notification'] = [
                "type" => "error",
                "title" => "Database Error",
                "message" => "Failed to create new location."
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        // Use the generated loc_id as the customer location
        $location = $loc_id;
    }

    // Final server-side validation
    if ($customer_name === "" || $phone === "" || $gender === "" || 
        $customer_type === "" || $location === "") {

        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Validation Error",
            "message" => "Required fields are missing."
        ];
        header("Location: ../manage_customers.php");
        exit();
    }

    // Check if email already exists (ONLY if email is provided)
    if (!empty($email) && $customers_model->emailExists($email)) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Duplicate Email",
            "message" => "This email address is already registered."
        ];
        header("Location: ../manage_customers.php");
        exit();
    }



    $customer_state = ($customer_type === "Walk-in") ? 1 : 1;
    $customer_id = $customers_model->getNextCustomerId();

    // Prepare data for insertion
    $customerData = [
        'customer_id'      => $customer_id,
        'customer_name'    => $customer_name,
        'contact_number'   => $phone,
        'whatsapp_number'  => $whatsapp,
        'email'            => $email,
        'gender'           => $gender,
        'customer_address' => $customer_address,
        'location'         => $location,
        'type_customer'    => $customer_type,
        'nationality'      => $nationality,
        'operator'         => $_SESSION['sess_employeecode'], 
        'datecreated'      => date('Y-m-d H:i:s'),
        'customer_state'   => $customer_state
    ];

    // Insert customer record
    $result = $customers_model->addCustomer($customerData);

    if ($result) {
        $_SESSION['notification'] = [
            "type" => "success",
            "title" => "Success",
            "message" => "Customer added successfully."
        ];
        header("Location: ../customer_details.php?customer_id=".$customer_id);
        exit();
    } else {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Database Error",
            "message" => "Failed to add customer."
        ];
        header("Location: ../manage_customers.php");
        exit();
    }
}
