<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <title>Customer Transactions</title>
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <?php include_once 'css_links.php'; ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">

                    <?php
                        include 'menu_finance.php';
                        include_once 'model/customers_model.php';

                        $customers_model = new customers_model();

                        $customer_id = $_GET['customer_id'] ?? '';
                        $from_date   = $_GET['from_date'] ?? '';
                        $to_date     = $_GET['to_date'] ?? '';
                        $filter_type = $_GET['filter_type'] ?? 'all'; // NEW


                        $customer_name    = $customers_model->getCustomerName($customer_id);
                        $customer_details = $customers_model->getCustomerDetails($customer_id);
                        $transactions = $customers_model->getCustomerTransactions($customer_id, $from_date, $to_date, $filter_type);


                        $company_logo = 'images/companies/default_customers.png';

                        $total_sales = 0;
                        $total_payments = 0;
                    ?>

                    <div class="right_col" role="main">

                        <div class="page-title">
                            <div class="title_left">
                                <h3>Customer Account Statement</h3>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div class="x_panel">

                            <div class="x_title">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4><?php echo $customer_name; ?></h4>
                                    </div>

                                    <div class="col-md-6 text-right">
                                        <a href="#" class="btn btn-danger btn-sm">
                                            <i class="fa fa-file-pdf-o"></i> Export PDF
                                        </a>

                                        <a href="#" class="btn btn-success btn-sm">
                                            <i class="fab fa-whatsapp"></i> WhatsApp
                                        </a>

                                        <a href="javascript:void(0);" class="btn btn-info btn-sm" onclick="history.go(-1);">
                                            Back <i class="fa fa-history"></i> 
                                        </a>
                                    </div>

                                </div>
                                <div class="clearfix"></div>
                            </div>

                            <div class="x_content">

                                <!-- CUSTOMER DETAILS -->
                                <div class="row">
                                    <div class="col-md-2">
                                        <img src="<?php echo $company_logo; ?>" class="img-responsive img-thumbnail">
                                    </div>
                                    <div class="col-md-10">
                                        <strong><?php echo $customer_name; ?></strong><br>
                                        <?php echo $customer_details['customer_address']; ?><br>
                                        <?php echo $customer_details['email']; ?> |
                                        <?php echo $customer_details['phone_number']; ?>
                                    </div>
                                </div>

                                <hr>
                                <div class="panel-body">
                                    <div class="row">

                                        <!-- DATE FILTER FORM (LEFT SIDE) -->
                                        <div class="col-md-9">
                                            <form method="get" class="form-horizontal">

                                                <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">

                                                <div class="row">

                                                    <!-- FROM DATE -->
                                                    <div class="col-md-4">
                                                        <label class="control-label">From Date</label>
                                                        <input type="date"
                                                            name="from_date"
                                                            class="form-control input-sm"
                                                            value="<?php echo htmlspecialchars($from_date); ?>"
                                                            <?php echo ($filter_type === 'balances') ? 'disabled' : ''; ?>>
                                                    </div>

                                                    <!-- TO DATE -->
                                                    <div class="col-md-4">
                                                        <label class="control-label">To Date</label>
                                                        <input type="date"
                                                            name="to_date"
                                                            class="form-control input-sm"
                                                            value="<?php echo htmlspecialchars($to_date); ?>"
                                                            <?php echo ($filter_type === 'balances') ? 'disabled' : ''; ?>>
                                                    </div>

                                                    <!-- BUTTON -->
                                                    <div class="col-md-2">
                                                        <label class="control-label">&nbsp;</label>
                                                        <button type="submit" class="btn btn-primary btn-block">
                                                            <i class="fa fa-search"></i> Apply
                                                        </button>
                                                    </div>

                                                </div>
                                            </form>
                                        </div>

                                        <!-- FILTER TYPE DROPDOWN (RIGHT SIDE, OUTSIDE FORM) -->
                                        <div class="col-md-3">
                                            <label class="control-label">Filter Type</label>
                                            <select id="invoice-filter" class="form-control input-sm">
                                                <option value="all" <?php if ($filter_type === 'all') echo 'selected'; ?>>
                                                    All Transactions
                                                </option>
                                                <option value="balances" <?php if ($filter_type === 'balances') echo 'selected'; ?>>
                                                    View Outstanding Invoices
                                                </option>
                                            </select>
                                        </div>

                                    </div>
                                </div>



                                
                                <!-- SAGE-STYLE STATEMENT -->
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr class="info">
                                            <th width="130">Transaction No</th>
                                            <th width="110">Date</th>
                                            <th>Activity</th>
                                            <th class="text-right" width="140">Sales</th>
                                            <th class="text-right" width="140">Payments</th>
                                            <th width="120">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                        <?php
                                            $totalSales = 0;
                                            $totalPayments  =0;
                                            $currentGroup = null;
                                            $groupSales = $groupPayments = 0;

                                            foreach ($transactions as $index => $row):

                                                if ($currentGroup !== $row['group_key']) {

                                                    // Close previous group totals
                                                    if ($currentGroup !== null) {
                                                        ?>
                                                        <tr class="active" data-group-key="<?php echo $currentGroup; ?>">
                                                            <td colspan="3" class="text-right"><strong>Total</strong></td>
                                                            <td class="text-right"><strong><?php echo number_format($groupSales, 2); ?></strong></td>
                                                            <td class="text-right"><strong><?php echo number_format($groupPayments, 2); ?></strong></td>
                                                            <td></td>
                                                        </tr>
                                                        <tr data-group-key="<?php echo $currentGroup; ?>"><td colspan="6"></td></tr>
                                                        <?php
                                                    }

                                                    $currentGroup = $row['group_key'];
                                                    $groupSales = $groupPayments = 0;
                                                    ?>

                                                    <!-- Transaction header -->
                                                    <tr class="warning" data-group-key="<?php echo $currentGroup; ?>">
                                                        <td><strong><?php echo htmlspecialchars($row['transaction_no']); ?></strong></td>
                                                        <td><?php echo htmlspecialchars($row['actual_date']); ?></td>
                                                        <td colspan="4"><strong>Transaction Summary</strong></td>
                                                    </tr>

                                                <?php } ?>

                                                <!-- Activity row -->
                                                <tr class="invoice-row" data-group-key="<?php echo $currentGroup; ?>"
                                                    data-outstanding-balance="<?php echo (float)$row['sales_amount'] - (float)$row['payments_amount']; ?>">
                                                    <td></td>
                                                    <td><?php echo htmlspecialchars($row['actual_date']); ?></td>
                                                    <td>
                                                        <?php echo htmlspecialchars($row['activity']); ?><br>
                                                        <small class="text-muted">
                                                            Ref: <?php echo htmlspecialchars($row['reference_number']); ?> |
                                                            By: <?php echo htmlspecialchars($row['operator']); ?>
                                                        </small>
                                                    </td>
                                                    <td class="text-right">
                                                        <?php
                                                            $sale = (float)$row['sales_amount'];
                                                            if ($sale > 0) echo number_format($sale, 2);
                                                            $groupSales += $sale;
                                                            $totalSales += $sale;
                                                        ?>
                                                    </td>
                                                    <td class="text-right">
                                                        <?php
                                                            $pay = (float)$row['payments_amount'];
                                                            if ($pay > 0) echo number_format($pay, 2);
                                                            $groupPayments += $pay;
                                                            $totalPayments += $pay;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                            if ($row['source'] === 'invoice') echo '<span class="label label-primary">Invoice</span>';
                                                            elseif ($row['source'] === 'invoice_payment') echo '<span class="label label-success">Payment</span>';
                                                            elseif ($row['source'] === 'cash_sale') echo '<span class="label label-warning">Cash Sale</span>';
                                                        ?>
                                                    </td>
                                                </tr>

                                            <?php endforeach; ?>

                                            <!-- Final group totals -->
                                            <?php if ($currentGroup !== null): ?>
                                            <tr class="active" data-group-key="<?php echo $currentGroup; ?>">
                                                <td colspan="3" class="text-right"><strong>Transaction Totals</strong></td>
                                                <td class="text-right"><strong><?php echo number_format($groupSales, 2); ?></strong></td>
                                                <td class="text-right"><strong><?php echo number_format($groupPayments, 2); ?></strong></td>
                                                <td></td>
                                            </tr>
                                            <?php endif; ?>


                                        <!-- OVERALL TOTALS -->
                                        <tr class="success">
                                            <td colspan="3" class="text-right"><strong>OVERALL TOTALS</strong></td>
                                            <td class="text-right"><strong class="total-sales"><?php echo number_format($totalSales, 2); ?></strong></td>
                                            <td class="text-right"><strong class="total-payments"><?php echo number_format($totalPayments, 2); ?></strong></td>
                                            <td></td>
                                        </tr>

                                        <tr class="danger">
                                            <td colspan="3" class="text-right"><strong>OUTSTANDING BALANCE</strong></td>
                                            <td colspan="2" class="text-right">
                                                <strong class="outstanding-balance"><?php echo number_format($totalSales - $totalPayments, 2); ?></strong>
                                            </td>
                                            <td></td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <?php include 'footer.php'; ?>
                </div>
            </div>
            <?php include_once 'libraries.php'; ?>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const filterDropdown = document.getElementById('invoice-filter');
                    if (!filterDropdown) return;

                    // Formatter for displaying numbers with commas and 2 decimal places
                    const formatNumber = (number) => {
                        return new Intl.NumberFormat('en-US', { style: 'decimal', minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(number);
                    };

                    function applyFilter() {
                        console.log("applyFilter triggered");
                        const filterValue = filterDropdown.value;
                        console.log("Selected filter value:", filterValue);

                        const allRows = document.querySelectorAll('tr[data-group-key]');
                        const groups = {};

                        let filteredSalesTotal = 0;
                        let filteredPaymentsTotal = 0;

                        // Group rows by group key
                        allRows.forEach(row => {
                            const key = row.dataset.groupKey;
                            if (!groups[key]) groups[key] = [];
                            groups[key].push(row);
                        });

                        // For each group, calculate the net outstanding balance and update totals
                        Object.keys(groups).forEach(key => {
                            const groupRows = groups[key];
                            let groupBalance = 0;

                            groupRows.forEach(row => {
                                if (row.classList.contains('invoice-row')) {
                                    const bal = parseFloat(row.dataset.outstandingBalance) || 0;
                                    groupBalance += bal;
                                }
                            });

                            console.log("Group:", key, "net balance:", groupBalance);

                            const show = filterValue === 'all' || (filterValue === 'balances' && groupBalance > 0);
                            
                            groupRows.forEach(row => {
                                // Show or hide based on filter
                                row.style.display = show ? '' : 'none';

                                if (row.style.display !== 'none') {
                                    // Get sales and payments cells
                                    const saleCell = row.querySelector('td:nth-child(4)');
                                    const paymentCell = row.querySelector('td:nth-child(5)');
                                    
                                    // Ensure cells exist before trying to access textContent
                                    if (saleCell && paymentCell) {
                                        // Parse values with proper handling for commas
                                        const saleText = saleCell.textContent.replace(/,/g, '').trim();
                                        const paymentText = paymentCell.textContent.replace(/,/g, '').trim();

                                        // Convert to float and check for valid number
                                        const sale = isNaN(parseFloat(saleText)) ? 0 : parseFloat(saleText);
                                        const payment = isNaN(parseFloat(paymentText)) ? 0 : parseFloat(paymentText);

                                        // Accumulate the sales and payments
                                        filteredSalesTotal += sale;
                                        filteredPaymentsTotal += payment;
                                    }
                                }
                            });
                        });

                        // Update the "Overall Totals" section dynamically with formatted numbers
                        document.querySelector('.total-sales').textContent = formatNumber(filteredSalesTotal);
                        document.querySelector('.total-payments').textContent = formatNumber(filteredPaymentsTotal);
                        document.querySelector('.outstanding-balance').textContent = formatNumber(filteredSalesTotal - filteredPaymentsTotal);
                    }

                    // Event listener
                    filterDropdown.addEventListener('change', applyFilter);

                    // Trigger initial filter
                    applyFilter();
                });


            </script>

        </body>
    </html>
