<?php
session_start();
header('Content-Type: application/json');
include_once 'model/employees_model.php';

date_default_timezone_set('Africa/Blantyre');

$data = json_decode(file_get_contents('php://input'), true);

$employees_model = new employees_model();

// Required inputs
$requestId = $data['requestId'] ?? null;
$reason = trim($data['reason'] ?? '');
$leave_state = 3; // Disapproved
$disapprovedBy = $_SESSION['sess_employeecode'] ?? null;
$disapprovedDate = date('Y-m-d H:i:s');

// Validate inputs
if (!$requestId || !$reason || !$disapprovedBy) {
    echo json_encode(['success' => false, 'message' => 'Missing required data.']);
    exit;
}

try {
    $success = $employees_model->disapproveLeaveRequest($requestId, $reason, $leave_state, $disapprovedBy, $disapprovedDate);

    echo json_encode(['success' => $success]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
