<?php
	session_start();
	include_once 'model/common_model.php';
	$common_model = new common_model();

	$location_id = $_GET['loc_id'];
	$locationDetails = $common_model->getlocationDetails($location_id);
	$districts = $common_model->getDistricts();

        $location_states = [
            1 => 'Active Location',
            0 => 'Disable Location'
        ];
?>
<html>
<head>
	<title>Warehouse</title>
	<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
</head>
<body>
	<form action="controllers/locations_controller.php" method="post">
		<center>
			<h2 class="page_titles">EDIT LOCATION DETAILS</h2>
			<hr>
            
			<span style="float:left;margin-left:20px;">Location Name</span>
			<input type="text" name="location_name" id="location_name" class="form-control" style="width:320px;height:40px;" value="<?= $locationDetails['location_name'] ?>" required>
			<br>

			<span style="float:left;margin-left:20px;">District</span>
			<select name="district" class="form-control" style="width:320px;height:40px;" required>
				<option value="<?= $locationDetails['loc_dist'] ?>"><?= $locationDetails['district_name'] ?></option>
				<?php foreach($districts as $dis): ?>
					<?php if($dis['id'] != $locationDetails['loc_dist']): ?>
						<option value="<?= $dis['id'] ?>"><?= $dis['district'] ?></option>
					<?php endif; ?>
				<?php endforeach; ?>
			</select>
			<br>

            <select name="location_state" class="form-control" style="width:320px;height:40px" required>
                <option value="" disabled selected>Select Location Status</option>
                <?php foreach($location_states as $key => $value): ?>
                    <option value="<?= $key ?>" <?= (isset($locationDetails['location_state']) && $locationDetails['location_state'] == $key) ? 'selected' : '' ?>>
                        <?= $value ?>
                    </option>
                <?php endforeach; ?>
            </select>
			<br>    

			<input type="hidden" name="editLocation" value="editproduct">
            <input type="hidden" name="location_id" value="<?php echo $locationDetails['loc_id']?>">
			<button type="submit" id="SaveButton" class="btn btn-success btn-block" style="width:320px;font-size:18px;">SAVE CHANGES</button>
		</center>
	</form>

	<script>
	function checkProductFields() {
		const product_id = $('input[name="product_id"]').val();
		const product_code = $('#product_code').val();
		const product_name = $('#product_name').val();

		console.log('Checking fields...');
		console.log('Product ID:', product_id);
		console.log('Product Code:', product_code);
		console.log('Product Name:', product_name);

		$.post('controllers/products_controller.php', {
			action: 'check_product',
			product_id: product_id,
			product_code: product_code,
			product_name: product_name
		}, function(data) {
			console.log('Server Response:', data);

			if (data.code_exists) {
				console.log('Product code already exists.');
				$('#Error').text('Product code already exists.');
				$('#SaveButton').prop('disabled', true);
			} else if (data.name_exists) {
				console.log('Product name already exists.');
				$('#Error').text('Product name already exists.');
				$('#SaveButton').prop('disabled', true);
			} else {
				console.log('Both code and name are unique.');
				$('#Error').text('');
				$('#SaveButton').prop('disabled', false);
			}
		}, 'json');
	}

	$(document).ready(function() {
		$('#product_code').on('input', function () {
			console.log('Product code changed.');
			checkProductFields();
		});

		$('#product_name').on('input', function () {
			console.log('Product name changed.');
			checkProductFields();
		});
	});
</script>


</body>
</html>
