<?php
	session_start();
	include_once 'model/stock_model.php';
	$stock_model = new stock_model();

	$product_id = $_GET['product_id'];
	$productDetails = $stock_model->getProductDetailsbyID($product_id);
	$categories = $stock_model->getCategories();
	$units = $stock_model->getUnits();

        $product_states = [
            1 => 'Active Product',
            0 => 'Disabled Product'
        ];
?>
<html>
<head>
	<title>Warehouse</title>
	<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
</head>
<body>
	<form action="controllers/products_controller.php" method="post">
		<center>
			<h2 class="page_titles">EDIT PRODUCT DETAILS</h2>
			<hr>
            
			
			<!-- Product Code -->
			<span style="float:left;margin-left:40px;">Product Code</span>
			<input type="text" name="product_code" id="product_code" class="form-control" style="width:280px;height:40px;" value="<?= $productDetails['product_code'] ?>" required>
			<br>

			<!-- Product Name -->
			<span style="float:left;margin-left:40px;">Product Name</span>
			<input type="text" name="product_name" id="product_name" class="form-control" style="width:280px;height:40px;" value="<?= $productDetails['product_name'] ?>" required>
			<span id="Error" style="color:red;"></span>
			<br>

			<span style="float:left;margin-left:40px;">Selling Price</span>
			<input type="number" min="1000" step="0.01" name="selling_price" id="selling_price" class="form-control" style="width:280px;height:40px;" value="<?= $productDetails['selling_price'] ?>" required>

			<!-- Product Category -->
			<span style="float:left;margin-left:40px;">Product Category</span>
			<select name="category" class="form-control" style="width:280px;height:40px;" required>
				<option value="<?= $productDetails['category'] ?>"><?= $productDetails['categoryname'] ?></option>
				<?php foreach($categories as $cat): ?>
					<?php if($cat['category_id'] != $productDetails['category']): ?>
						<option value="<?= $cat['category_id'] ?>"><?= $cat['categoryname'] ?></option>
					<?php endif; ?>
				<?php endforeach; ?>
			</select>
			<br>

			<!-- Product Unit -->
			<span style="float:left;margin-left:40px;">Product Unit</span>
			<select name="unit" class="form-control" style="width:280px;height:40px;" required>
				<option value="<?= $productDetails['unit'] ?>"><?= $productDetails['unitname'] ?></option>
				<?php foreach($units as $unit): ?>
					<?php if($unit['unit_id'] != $productDetails['unit']): ?>
						<option value="<?= $unit['unit_id'] ?>"><?= $unit['unitname'] ?></option>
					<?php endif; ?>
				<?php endforeach; ?>
			</select>
			<br>

			<!-- Minimum Level -->
			<span style="float:left;margin-left:40px;">Overall Stock Level</span>
			<input type="number" class="form-control" style="width:280px;height:40px;" name="minimum_level" min="10" required value="<?= $productDetails['min_order_level'] ?>" placeholder="Enter minimum Stock Level">
			<br>

			<!-- Product State -->
			<span style="float:left;margin-left:40px;">Product State</span>
			<select name="product_state" class="form-control" style="width:280px;height:40px;" required>
                <?php foreach($product_states as $key => $value): ?>
                    <option value="<?= $key ?>" <?= (isset($productDetails['product_state']) && $productDetails['product_state'] == $key) ? 'selected' : '' ?>>
                        <?= $value ?>
                    </option>
                <?php endforeach; ?>
            </select>

			<br>

			<input type="hidden" name="editproduct" value="editproduct">
            <input type="hidden" name="product_id" value="<?php echo $productDetails['product_id']?>">
			<button type="submit" id="SaveButton" class="btn btn-success btn-block" style="width:282px;font-size:18px;">SAVE CHANGES</button>
		</center>
	</form>

	<script>
	function checkProductFields() {
		const product_id = $('input[name="product_id"]').val();
		const product_code = $('#product_code').val();
		const product_name = $('#product_name').val();

		console.log('Checking fields...');
		console.log('Product ID:', product_id);
		console.log('Product Code:', product_code);
		console.log('Product Name:', product_name);

		$.post('controllers/products_controller.php', {
			action: 'check_product',
			product_id: product_id,
			product_code: product_code,
			product_name: product_name
		}, function(data) {
			console.log('Server Response:', data);

			if (data.code_exists) {
				console.log('Product code already exists.');
				$('#Error').text('Product code already exists.');
				$('#SaveButton').prop('disabled', true);
			} else if (data.name_exists) {
				console.log('Product name already exists.');
				$('#Error').text('Product name already exists.');
				$('#SaveButton').prop('disabled', true);
			} else {
				console.log('Both code and name are unique.');
				$('#Error').text('');
				$('#SaveButton').prop('disabled', false);
			}
		}, 'json');
	}

	$(document).ready(function() {
		$('#product_code').on('input', function () {
			console.log('Product code changed.');
			checkProductFields();
		});

		$('#product_name').on('input', function () {
			console.log('Product name changed.');
			checkProductFields();
		});
	});
</script>


</body>
</html>
