<?php
	session_start();
    include_once 'model/warehouse_model.php';
    include_once 'model/employees_model.php';
    include_once 'model/common_model.php';
	
?>
<html>
	<head>
		<title>Warehouses</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 20px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
	<body>
		<?php
			$warehouse_id = $_GET['id'];
            $warehouse_model = new warehouse_model();
            $employees_model = new employees_model();
            $common_model = new common_model();

            $warehouseDetails = $warehouse_model->getWarehouseDetails($warehouse_id);
			$supervisors = $employees_model->getSupervisors();
			$locations = $common_model->getAllLocations();
		?>
		
		<form action="controllers/warehouse_controller.php" method="POST">
			
				<center>
					<h2 class="page_titles">EDIT WAREHOUSE DETAILS <i class="fa fa-mug-hot"></i></h2>
					<hr>
					
					<input type="text" style="width: 280px; height:40px;" autocomplete="off" id="warehousename" name="warehouse_name" value="<?php echo $warehouseDetails['warehouse_name']?>" class="form-control" required placeholder="Enter New Warehouse Name">
					<span id="Error" style="color: red;"></span><br>
					
					<select name="supervisor" class="form-control" style="width: 280px; height:40px;" required>
						<option value="<?php echo $warehouseDetails['supervisor']?>"><?php echo $warehouseDetails['supervisor_name']?></option>
						<?php
							foreach($supervisors as $supervisor):
								if($warehouseDetails['supervisor'] != $supervisor['employee_code']):
						?>
									<option value="<?php echo $supervisor['employee_code']?>"><?php echo $supervisor['fullname']?></option>
						<?php
								endif;
							endforeach;
						?>
					</select>
					<br>

					<select name="location" class="form-control" style="width: 280px; height:40px;" required>
						<option value="<?php echo $warehouseDetails['location']?>"><?php echo $warehouseDetails['location_name']?></option>
						<?php
							foreach($locations as $location):
								if($warehouseDetails['location'] != $location['loc_id']):
						?>
									<option value="<?php echo $location['loc_id']?>"><?php echo $location['location_name']?></option>
						<?php
								endif;
							endforeach;
						?>
					</select>
					<br>

                    <input type="hidden" name="edit_warehouse" value="edit_warehouse" readonly>
                    <input type="hidden" name="warehouse_id" value="<?php echo $warehouse_id ?>" readonly>

					<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:282px;font-size: 18px;">SAVE DETAILS <i class="fa fa-save"></i></button>
				</center>
			
		</form>	
	</body>
</html>