<?php

    session_start();
    require 'vendor/autoload.php'; // PHPMailer (via Composer)
    require('fpdf/fpdf.php'); // For generating PDFs

    include_once 'model/customers_model.php';
    include_once 'model/common_model.php';
    include_once 'model/sales_model.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;

    $customers_model = new customers_model();
    $common_model = new common_model();
    $sales_model = new sales_model();

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['customer_id'])) {

        $customer_id = intval($_POST['customer_id']);

        $customer = $customers_model->getCustomerDetails($customer_id);
        $invoices = $customers_model->getActiveInvoicesByCustomer($customer_id);

        $company_details = $common_model->getCompanyDetails();

        if (!$customer || empty($invoices)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => 'No customer or invoices found.'
            ];
            header("Location: manage_customers.php");
            exit;
        }

        $pdfFiles = [];
        $outputDir = __DIR__ . '/emailinvoices/';
        if (!file_exists($outputDir)) {
            mkdir($outputDir, 0777, true);
        }

        foreach ($invoices as $invoice) {
            $invoiceNumber = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $invoice['invoice_number']);
            $fileName = "powertex_invoice_{$invoiceNumber}.pdf";
            $filePath = $outputDir . $fileName;
            $logo = $common_model->getlogo();

            $company_details = $common_model->getCompanyDetails();
            $signature_file = $company_details['directors_signature']; // or similar key name

            $balance = 0;
            foreach ($invoices as $invoice) {
                $balance += floatval($invoice['balance']);
            }


            $logo_path = __DIR__ . '/images/' . $logo; // Adjust as needed
            $signature_path = __DIR__ . '/signatures/' . $signature_file;


            $items = $sales_model->getReceiptItems($invoice['invoice_number']);

            $pdf = new FPDF();
            $pdf->AddPage();

            // Company Header: INVOICE No. | LOGO | TPIN No.
            $pdf->SetY(10); // Optional: Set Y position at the top of page
            $pdf->SetFont('Arial', 'B', 12);

            // Column 1: INVOICE No.
            $pdf->Cell(60, 15, 'INVOICE No. ' . $invoice['invoice_number'], 0, 0, 'L');

            // Column 2: LOGO
            if (!empty($logo_path) && file_exists($logo_path)) {
                $pdf->Image($logo_path, $pdf->GetX(), $pdf->GetY(), 80); // Width = 30mm
            }
            $pdf->Cell(60, 15, '', 0, 0); // Spacer to preserve structure

            // Column 3: TPIN No.
            $pdf->Cell(70, 15, 'TPIN No. ' . $company_details['tpin'], 0, 1, 'R');


            // Company Offices Section - 3 Column Layout
            $pdf->Ln(2);
            $pdf->SetFont('Arial', '', 9);

            $column1 = "Corporate Office\nAREA 47/3/1210 HSE68\nLILONGWE\nTel: " . $company_details['phone_number'] . "\nEmail: " . $company_details['email'] . "\nWebsite: www.powertexmw.com";

            $column2 = "Blantyre Office\nClaim Building\nGly Jones Road\nTel: 0887 626 530\nEmail: powertexmw@gmail.com";

            $column3 = "BRANCHES\nZomba - 0883 742 305\nMurray Road (LLZ) - 0887 626 529\nArea 13 (LLZ) - 0887 626 528\nLimbe - 0887 361 420";

            // Set initial Y position
            $startY = $pdf->GetY();
            $startX = $pdf->GetX();

            // Column 1
            $pdf->SetXY($startX, $startY);
            $pdf->MultiCell(63, 5, $column1, 0);

            // Column 2
            $pdf->SetXY($startX + 70, $startY);
            $pdf->MultiCell(63, 5, $column2, 0);

            // Column 3
            $pdf->SetXY($startX + 140, $startY);
            $pdf->MultiCell(63, 5, $column3, 0);

            // Move below the tallest column
            $pdf->Ln(8);

            // Customer Name (left)
            $pdf->SetFont('Arial', 'B', 11);
            $pdf->Cell(130, 8, strtoupper($invoice['customer_name']), 0, 0, 'L');

            // Underlined Date (right)
            $pdf->SetFont('Arial', 'BU', 11); // B = bold, U = underline
            $date = date('d F Y', strtotime($invoice['invoice_date']));
            $pdf->Cell(60, 8, 'Date: ' . $date, 0, 1, 'R');

            // Separator Line
            $pdf->Ln(1);
            $pdf->SetDrawColor(0, 0, 0); // Black line
            $pdf->Line(10, $pdf->GetY(), 200, $pdf->GetY()); // Left to right margin

            $pdf->Ln(5); // Space after


            // Table Header
            $pdf->SetFont('Arial', 'B', 10);
            $pdf->SetFillColor(240, 240, 240);
            $pdf->Cell(20, 8, 'QTY', 1, 0, 'C', true);
            $pdf->Cell(95, 8, 'DESCRIPTION', 1, 0, 'L', true);
            $pdf->Cell(30, 8, '@', 1, 0, 'R', true);
            $pdf->Cell(45, 8, 'TOTAL', 1, 1, 'R', true);

            // Table Data
            $pdf->SetFont('Arial', '', 10);
            foreach ($items as $item) {
                $pdf->Cell(20, 8, $item['quantity'], 1, 0, 'C');
                $pdf->Cell(95, 8, $item['description'], 1, 0);
                $pdf->Cell(30, 8, number_format($item['selling_price'], 2), 1, 0, 'R');
                $pdf->Cell(45, 8, number_format($item['total'], 2), 1, 1, 'R');
            }

            // Totals
            $pdf->Ln(3);
            $pdf->Cell(145, 8, 'Sub-Total', 1);
            $pdf->Cell(45, 8, number_format($invoice['subtotal'], 2), 1, 1, 'R');

            $pdf->Cell(145, 8, 'Plus 16.5% VAT', 1);
            $pdf->Cell(45, 8, number_format($invoice['vat'], 2), 1, 1, 'R');

            $pdf->Cell(145, 8, 'Grand Total', 1);
            $pdf->Cell(45, 8, number_format($invoice['grand_total'], 2), 1, 1, 'R');
            
            $pdf->Cell(145, 8, 'Total Amount Paid', 1);
            $pdf->Cell(45, 8, number_format($invoice['total_paid'], 2), 1, 1, 'R');
            
            $pdf->Cell(145, 8, 'Balance', 1);
            $pdf->Cell(45, 8, number_format($invoice['balance'], 2), 1, 1, 'R');

            // Footer
            $pdf->Ln(10);
            $pdf->SetFont('Arial', '', 10);
            $pdf->Cell(95, 6, 'Customer Tel: ' . $invoice['customer_contact'], 0);

            if (!empty($signature_file) && file_exists($signature_path)) {
                // Insert image as signature, width = 40 (adjust if needed)
                $pdf->Image($signature_path, $pdf->GetX() + 50, $pdf->GetY() - 2, 25); 
               
            } else {
                $pdf->Cell(95, 6, 'Signature: ___________________________', 0, 1, 'R');
            }


            $pdf->Ln();

            $pdf->Output($filePath, 'F');

            $pdfFiles[] = $filePath;

            $mail = new PHPMailer(true);

            $mail->Username   = 'noreply@smartplus-mw.com';
            $mail->Password   = '#2024!@EMAIL';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port = 465; 

        $mail->setFrom('noreply@smartplus-mw.com', 'Smart Plus');

            try {
                // SMTP Configuration
                $mail->isSMTP();
                $mail->Host       = 'llgolf.smartplus-mw.com';      // e.g. smtp.gmail.com
                $mail->SMTPAuth   = true;
                $mail->Username   = 'noreply@smartplus-mw.com';
                $mail->Password   = '#2024!@EMAIL';
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Or PHPMailer::ENCRYPTION_STARTTLS
                $mail->Port       = 465;

                // Sender & Recipient
                $mail->setFrom('noreply@smartplus-mw.com', 'Powertex Ltd');
                $mail->addAddress($customer['email'], $customer['customer_name']);

                // Email Subject & Body
                $mail->isHTML(true);
                $mail->Subject = 'Outstanding Invoices from Powertex Ltd';
                

                $mail->Body = "
                    <p>Dear <strong>{$customer['customer_name']}</strong>,</p>

                    <p>We hope this message finds you well.</p>

                    <p>We would like to kindly remind you that your account currently has an outstanding balance of <strong>MWK {$balance}</strong> with Powertex Ltd.</p>

                    <p>Please find attached your unpaid invoice(s) for your reference. We kindly request that you review and settle these balances at your earliest convenience.</p>

                    <p>If you have already made a payment, please disregard this notice or contact our finance team to confirm receipt.</p>

                    <p>Thank you for your continued business and partnership.</p>

                    <p>Best regards,<br>
                    <strong>Powertex Ltd – Finance Team</strong></p>
                ";


                // Attach all invoice PDFs
                foreach ($pdfFiles as $pdfPath) {
                    if (file_exists($pdfPath)) {
                        $mail->addAttachment($pdfPath);
                    }
                }

                // Send email
                $mail->send();

                $_SESSION['notification'] = [
                    'type' => 'success',
                    'title' => 'Email Sent',
                    'message' => 'Invoices successfully sent to ' . $customer['email']
                ];
            } catch (Exception $e) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Email Failed',
                    'message' => 'Error: ' . $mail->ErrorInfo
                ];
            }/* 

            // Optionally delete PDFs after sending (cleanup)
            foreach ($pdfFiles as $pdfPath) {
                if (file_exists($pdfPath)) {
                    unlink($pdfPath); // Only if you don't want to keep them
                }
            } */

            header('Location: manage_customers.php');
            exit;

        }
    
        
        

    }else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Invalid Request',
            'message' => 'Customer not specified.'
        ];
        header("Location: manage_customers.php");
        exit;
    }
?>