<?php
    if (!isset($_GET['employee_code'])) {
        $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Error',
        'message' => 'Employee code not provided.'
        ];
        header('location:manage_employees.php');
        exit();
    }

    include_once 'model/employees_model.php';
    $employees_model = new employees_model();
    $employee = $employees_model->getEmployeeDetails($_GET['employee_code']); // Make sure this method exists

    if (!$employee) {
        $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Not Found',
        'message' => 'Employee not found.'
        ];
        header('location:manage_employees.php');
        exit();
    }
    $employee_code = $_GET['employee_code'];
    $leave_data = $employees_model->newleaveformula($employee_code);
?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>Employee Profile</title>
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <?php include_once 'css_links.php'; ?>

            <style>
                .custom-card-header {
                    padding: 15px 15px; /* Reduces the top and bottom padding */
                    text-align: center;
                }

                .custom-card-header h3 {
                    margin-bottom: 0; /* Removes bottom margin for a tighter look */
                    font-size: 1.5rem; /* Optional: You can reduce the font size if you want */
                }
            </style>
        </head>
        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
                    <?php 
                        include 'menu_finance.php'; 
                    ?>

                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Details of <?php echo $employee['fullname']; ?></small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Title -->
                                            <div>
                                                <h2 class="mb-0">Employees </h2>
                                            </div>

                                            <!-- Center: Title -->
                                            <div class="text-center flex-grow-1">
                                                <h5 class="mb-0">Employee Details</h5>
                                            </div>

                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0 d-flex gap-2">
                                                    
                                                <li>
                                                    <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#editEmployeeModal">
                                                        <i class="fa fa-edit"></i> Edit Employee
                                                    </button>
                                                </li>
                                                <li>
                                                    <button class="btn btn-secondary btn-sm" onclick="history.back();">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="x_content">
                                            <div class="col-md-3 col-sm-3 profile_left">
                                                <div class="profile_img">
                                                    <div id="crop-avatar">
                                                        <?php 
                                                            if (!empty($employee['picture']) && file_exists("images/employees/" . $employee['picture'])): 
                                                        ?>
                                                            <img class="img-responsive avatar-view" src="images/employees/<?php echo $employee['picture']; ?>" alt="Avatar">
                                                        <?php else: ?>
                                                            <img class="img-responsive avatar-view" src="images/default_avatar.png" alt="Avatar">
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <h3><?php echo $employee['fullname']; ?></h3>
                                                <ul class="list-unstyled user_data">
                                                    <li><i class="fa fa-map-marker user-profile-icon"></i> <?php echo $employee['location_name']; ?></li>
                                                    <li><i class="fa fa-sitemap user-profile-icon"></i> <?php echo $employee['department_name']; ?></li>
                                                    <li><i class="fa fa-briefcase user-profile-icon"></i> <?php echo $employee['postname']; ?></li>
                                                    <li><i class="fa fa-calendar user-profile-icon"></i> Start Date: <?php echo date('d F Y', strtotime($employee['start_date'])); ?></li>
                                                </ul>

                                               <div class="mt-3">
                                                    <button class="btn btn-warning btn-block" data-toggle="modal" data-target="#salaryModal">Change Salary</button>

                                                    <?php if ($employee['employee_state'] == 1): ?>
                                                        <button class="btn btn-danger btn-block" data-toggle="modal" data-target="#suspendModal">Suspend Employee</button>
                                                    <?php else: ?>
                                                        
                                                        <button class="btn btn-success btn-block" data-toggle="modal" data-target="#resumeModal">Resume Employee</button>
                                                    <?php endif; ?>
                                                    
                                                    
                                                </div>

                                            </div>

                                            <div class="container mt-4">
                                                <div class="row">
                                                    <!-- Left Column (Personal & Contract Details) -->
                                                    <div class="col-md-6">
                                                        <div class="profile_title">
                                                            <h2>Personal & Contract Details</h2>
                                                        </div>
                                                        <table class="table table-striped">
                                                            <tr><th>Gender</th><td><?php echo $employee['gender']; ?></td></tr>
                                                            <tr><th>National ID Number</th><td><?php echo $employee['national_id_number']; ?></td></tr>
                                                            <tr><th>Date of Birth</th><td><?php echo date('d F, Y',strtotime($employee['date_of_birth'])); ?></td></tr>
                                                            <tr><th>Phone Number</th><td><?php echo $employee['phone_number']; ?></td></tr>
                                                            <tr><th>Email Address</th><td><?php echo $employee['email_address']; ?></td></tr>
                                                            <tr><th>Nationality</th><td><?php echo $employee['nationality']; ?></td></tr>
                                                            <tr><th>Village</th><td><?php echo $employee['home_village']; ?></td></tr>
                                                            <tr><th>Home District</th><td><?php echo $employee['district_name']; ?></td></tr>
                                                            <tr><th>Contract Type</th><td><?php echo $employee['contract_type']; ?></td></tr>
                                                            <tr><th>Gross Salary</th><td>MK <?php echo number_format($employee['gross_salary'], 2); ?></td></tr>
                                                            <tr class="<?php 
                                                                if ($employee['employee_state'] == 1) {
                                                                    echo 'bg-success text-white'; // Active (green)
                                                                } elseif ($employee['employee_state'] == 2) {
                                                                    echo 'bg-warning text-black'; // Suspended (yellow)
                                                                } elseif ($employee['employee_state'] == 3) {
                                                                    echo 'bg-danger text-white'; // Disabled (red)
                                                                } else {
                                                                    echo 'bg-light text-black'; // Default (light background)
                                                                }
                                                                ?>">
                                                                <th>Employee Status</th>
                                                                <td><?php echo $employee['employee_status']; ?></td>
                                                            </tr>

                                                            <tr><th>Captured By</th><td><?php echo $employee['operator_name']; ?></td></tr>
                                                        </table>
                                                    </div>

                                                    <!-- Right Column (Leave Data & Graph) -->
                                                    <div class="col-md-6">
                                                        <div class="card mb-3">
                                                            <div class="card-header bg-success text-white custom-card-header">
                                                                <h3>Leave Data</h3>
                                                            </div>
                                                            <div class="card-body">
                                                                <table class="table">
                                                                    <tr><th>Leave Type</th><td>Annual Leave</td></tr>
                                                                    <tr><th>Total Allocated Days</th><td><?php echo $leave_data['total_accrued']?></td></tr>
                                                                    <tr><th>Days Approved</th><td><?php echo $leave_data['total_taken']?></td></tr>
                                                                    <tr><th>Remaining Days</th><td><?php echo $leave_data['total_left']?></td></tr>
                                                                </table>
                                                            </div>
                                                        </div>

                                                        <!-- Graph Card -->
                                                        <div class="card">
                                                            <div class="card-header bg-info text-white">
                                                                <h3>Leave Graph</h3>
                                                            </div>
                                                            <div class="card-body">
                                                                <!-- Add your graph here (example: using Chart.js or another library) -->
                                                                <canvas id="leaveGraph" width="400" height="200"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal for Changing Salary -->
                                        <div class="modal fade" id="salaryModal" tabindex="-1" role="dialog" aria-labelledby="salaryModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="salaryModalLabel">Change Salary</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form action="controllers/employees_controller.php" method="POST">
                                                            <div class="form-group">
                                                                <label for="salaryAmount">New Salary Amount (MK)</label>
                                                                <input type="text" name="old_salary" class="form-control" value="<?php echo $employee['gross_salary']?>" readonly><br>
                                                                <input type="number" class="form-control" id="salaryAmount" name="new_salary" required>
                                                                <input type="hidden" name="employee_code" value="<?php echo $employee['employee_code']; ?>">
                                                                <input type="hidden" name="action" value="update_salary">
                                                            </div>
                                                            <button type="submit" class="btn btn-primary">Update Salary</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal for Suspending Employee -->
                                        <div class="modal fade" id="suspendModal" tabindex="-1" role="dialog" aria-labelledby="suspendModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="suspendModalLabel">Suspend Employee</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Are you sure you want to suspend this employee?</p>
                                                        <form action="controllers/employees_controller.php" method="POST">
                                                            <input type="hidden" name="employee_code" value="<?php echo $employee['employee_code']; ?>">
                                                            <input type="hidden" name="action" value="change_state">
                                                            <input type="hidden" name="value" value="0">
                                                            <button type="submit" class="btn btn-danger">Suspend</button>
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal for Resuming an Employee -->
                                        <div class="modal fade" id="resumeModal" tabindex="-1" role="dialog" aria-labelledby="resumeModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="resumeModalLabel">Resume Employee</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Are you sure you want to resume this employee?</p>
                                                        <form action="controllers/employees_controller.php" method="POST">
                                                            <input type="hidden" name="employee_code" value="<?php echo $employee['employee_code']; ?>">
                                                            <input type="hidden" name="action" value="change_state">
                                                            <input type="hidden" name="value" value="1"> <!-- Assuming 1 means active/resumed -->
                                                            <button type="submit" class="btn btn-success">Resume</button>
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php 
                        include_once 'footer.php'; 
                    ?>
                </div>
            </div>
            <?php 
                include_once 'libraries.php'; 
            ?>
            <!-- Modal for Editing Employee Details -->
            <div class="modal fade" id="editEmployeeModal" tabindex="-1" role="dialog" aria-labelledby="editEmployeeModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <form method="POST" action="controllers/employees_controller.php">
                        <div class="modal-content">
                            <div class="modal-header">
                            <h5 class="modal-title">Edit Employee Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span>&times;</span>
                            </button>
                            </div>

                            <div class="modal-body">
                            <!-- Hidden inputs -->
                            <input type="hidden" name="action" value="update_employee_details">
                            <input type="hidden" name="employee_code" id="employee_code" value="<?php echo htmlspecialchars($employee['employee_code']); ?>">

                            <!-- National ID & Full Name -->
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                <label for="national_id_number">National ID</label>
                                <input type="text" class="form-control" name="national_id_number" id="national_id_number" value="<?php echo htmlspecialchars($employee['national_id_number']); ?>" required>
                                </div>
                                <div class="form-group col-md-6">
                                <label for="fullname">Full Name</label>
                                <input type="text" class="form-control" name="fullname" id="fullname" value="<?php echo htmlspecialchars($employee['fullname']); ?>" required>
                                </div>
                            </div>

                            <!-- Phone Number & Email Address -->
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                <label for="phone_number">Phone Number</label>
                                <input type="text" class="form-control" name="phone_number" id="phone_number" value="<?php echo htmlspecialchars($employee['phone_number']); ?>" required>
                                </div>
                                <div class="form-group col-md-6">
                                <label for="email_address">Email Address</label>
                                <input type="email" class="form-control" name="email_address" id="email_address" value="<?php echo htmlspecialchars($employee['email_address']); ?>" required>
                                </div>
                            </div>

                            <!-- Gender & Date of Birth -->
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                <label for="gender">Gender</label>
                                <select class="form-control" name="gender" id="gender" required>
                                    <option value="">-- Select --</option>
                                    <option value="Male" <?php if ($employee['gender'] === 'Male') echo 'selected'; ?>>Male</option>
                                    <option value="Female" <?php if ($employee['gender'] === 'Female') echo 'selected'; ?>>Female</option>
                                </select>
                                </div>
                                <div class="form-group col-md-6">
                                <label for="date_of_birth">Date of Birth</label>
                                <input type="date" class="form-control" name="date_of_birth" id="date_of_birth" value="<?php echo htmlspecialchars($employee['date_of_birth']); ?>" required>
                                </div>
                            </div>

                            <!-- Current Location & Nationality (Dropdowns) -->
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                <label for="current_location">Current Location</label>
                                <select class="form-control" name="current_location" id="current_location" required>
                                    <option value="<?php echo $employee['current_location']; ?>" selected><?php echo $employee['location_name']; ?></option>
                                </select>
                                </div>
                                <div class="form-group col-md-6">
                                <label for="nationality">Nationality</label>
                                <select class="form-control" name="nationality" id="nationality" required>
                                    <option value="<?php echo $employee['nationality_id']; ?>" selected><?php echo $employee['nationality']; ?></option>
                                </select>
                                </div>
                            </div>

                            <!-- Home Village & Home District -->
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                <label for="home_village">Home Village</label>
                                <input type="text" class="form-control" name="home_village" id="home_village" value="<?php echo htmlspecialchars($employee['home_village']); ?>" required>
                                </div>
                                <div class="form-group col-md-6">
                                <label for="home_district">Home District</label>
                                <select class="form-control" name="home_district" id="home_district" required>
                                    <option value="<?php echo $employee['home_district']; ?>" selected><?php echo $employee['district_name']; ?></option>
                                </select>
                                </div>
                            </div>
                            </div>

                            <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Update Employee</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <script>
                // Get data from PHP (ensure that PHP variables are properly echoed into JavaScript)
                var totalAllocated = <?php echo $leave_data['total_accrued']; ?>;
                var totalTaken = <?php echo $leave_data['total_taken']; ?>;
                var totalLeft = <?php echo $leave_data['total_left']; ?>;

                // Set up the chart
                var ctx = document.getElementById('leaveGraph').getContext('2d');
                var leaveGraph = new Chart(ctx, {
                    type: 'bar', // You can also use 'line', 'pie', etc.
                    data: {
                        labels: ['Total Allocated', 'Total Taken', 'Total Left'],
                        datasets: [{
                            label: 'Leave Data',
                            data: [totalAllocated, totalTaken, totalLeft],
                            backgroundColor: ['#33C9FF', '#FF5733', '#66FF33'], // Colors for each bar
                            borderColor: ['#33C9FF', '#FF5733', '#66FF33'], // Border colors for each bar
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true, // Makes the chart responsive
                        scales: {
                            y: {
                                beginAtZero: true, // Ensure the Y-axis starts from 0
                                title: {
                                    display: true,
                                    text: 'Number of Days' // Y-axis label
                                }
                            },
                            x: {
                                title: {
                                    display: true,
                                    text: 'Leave Categories' // X-axis label
                                }
                            }
                        },
                        plugins: {
                            legend: {
                                position: 'top' // Position of the legend
                            }
                        }
                    }
                });
            </script>
            <script>
                function populateSelect(endpoint, selectId, selectedValue = null, idField = 'id') {
                    $.getJSON(endpoint, function(data) {
                        const $select = $('#' + selectId);
                        $select.empty();

                        // Determine how to label each item
                        function getLabel(item) {
                            return item.name || item.district || item.nationality || item.location_name || 'Unnamed';
                        }

                        // If selected value exists, find and append it
                        if (selectedValue !== null) {
                            const selectedItem = data.find(item => item[idField] == selectedValue);
                            if (selectedItem) {
                                $select.append($('<option>', {
                                    value: selectedItem[idField],
                                    text: getLabel(selectedItem),
                                    selected: true
                                }));
                            }
                        } else {
                            $select.append('<option value="">-- Select --</option>');
                        }

                        // Filter out the selected value to avoid duplication
                        const filteredData = data.filter(item => item[idField] != selectedValue);

                        // Append remaining options
                        filteredData.forEach(item => {
                            $select.append($('<option>', {
                                value: item[idField],
                                text: getLabel(item)
                            }));
                        });
                    });
                }




                $('#editEmployeeModal').on('show.bs.modal', function () {
                    const currentLocationId = "<?php echo $employee['current_location']; ?>";
                    const nationalityId     = "<?php echo $employee['nationality_id']; ?>";
                    const homeDistrictId    = "<?php echo $employee['home_district']; ?>";

                    // Pass appropriate ID field names per endpoint
                    populateSelect('get_locations.php',   'current_location', currentLocationId, 'loc_id');
                    populateSelect('get_nationalities',   'nationality',       nationalityId,     'id');
                    populateSelect('get_districts.php',   'home_district',     homeDistrictId,    'id');
                });

            </script>

        </body>
    </html>