<?php
    require_once 'model/finance_model.php';
    require_once 'model/employees_model.php';
    require_once 'model/sales_model.php';

    header('Content-Type: application/json');

    $start = $_GET['start'] ?? null;
    $end = $_GET['end'] ?? null;
    $graph = $_GET['graph'] ?? null;

    if (!$start || !$end || !$graph) {
        echo json_encode(['error' => 'Missing parameters']);
        exit;
    }

    $finance_model = new finance_model();
    $employees_model = new employees_model();
    $sales_model = new sales_model();

    $response = [
        'labels' => [],
        'data' => [],
        'total_days' => [],
        'approved_days' => [],
        'remaining_days' => []
    ];


    switch ($graph) {   
        case 'sales_activity':
        $currentYear = date('Y');
        $currentMonth = date('m');
        $startYear = date('Y', strtotime($start));
        $endYear = date('Y', strtotime($end));

        // Check if transactions are requested
        $includeTransactions = $_GET['include_transactions'] ?? 0;
        if ($includeTransactions) {
            $transactions = $sales_model->getsalesTransactionsByDate($start, $end);
            $response['transactions'] = $transactions; // include in the JSON
        }

        $includePayments = $_GET['include_payments'] ?? 0;
        if($includePayments){
            $payments = $sales_model->getPaymentsByDate($start, $end);
            $response['payments'] = $payments;
        }

        $includedLocations = $_GET['fetch_locations'];
        if($includedLocations){
            $locations = $finance_model->getDistinctLocationsByDate($start, $end);
            $response['locations'] = $locations;
        }


        if ($start === date('Y-01-01') && $end === date('Y-m-d')) {
            $data = $finance_model->getSalesDataByDateRange($start, $end); // daily data
            foreach ($data as $row) {
                $response['labels'][] = $row['date']; 
                $response['data'][] = floatval($row['value']);
            }
        }

        // Default case for handling other date ranges
        else if (1> 0) {
            // Check if range is today only
            if ($start === $end && $start === date('Y-m-d')) {
                // Return hourly sales data for today
                $data = $finance_model->getSalesDataPerHour($start);
                foreach ($data as $row) {
                    $response['labels'][] = $row['hour'] . ':00';
                    $response['data'][] = floatval($row['value']);
                }
            } else {
                // Default: sales per day (using existing method)
                $data = $finance_model->getSalesDataByDateRange($start, $end);
                foreach ($data as $row) {
                    $response['labels'][] = $row['date'];
                    $response['data'][] = floatval($row['value']);
                }
            }
        } else {
            // Other cases can be handled here (for example, if the date range is not in the current year)
            $response['error'] = 'The selected date range is not valid for this query.';
        }
        break;

        case 'salary_projection':
            // You can either use the start and end to get a dynamic range,
            // or simply use the current year for standard projections.
            
            $startYear = date('Y', strtotime($start));

            // Get monthly projections for the given year
            $data = $finance_model->getSalaryProjections($startYear);

            foreach ($data as $row) {
                $response['labels'][] = $row['month']; // e.g., 'Jan', 'Feb'
                $response['data'][] = floatval($row['amount']); // projected amount
            }
        break;


        case 'top_customers':
            $data = $finance_model->getTopCustomers($start, $end);
            foreach ($data as $row) {
                $response['labels'][] = $row['customer_name'];
                $response['data'][] = floatval($row['total_spent']);
            }
        break;
    
        case 'employee_leaves':
        $data = $employees_model->newLeavecalculation($start, $end); // Optional: add range
        foreach ($data as $row){
            $response['labels'][] = $row['fullname'];
            $response['total_days'][] = (int)$row['total_days'];
            $response['approved_days'][] = (int)$row['total_taken'];
            $response['remaining_days'][] = (int)$row['total_left'];
        }
        break;


        default:
            echo json_encode(['error' => 'Unknown graph type']);
            exit;
    }


    echo json_encode($response);
