<?php
    session_start();

    require_once __DIR__ . '/vendor/autoload.php';

    include_once 'model/customers_model.php';
    include_once 'model/sales_model.php';
    include_once 'model/common_model.php';

    $customer_id = isset($_GET['customer_id']) ? intval($_GET['customer_id']) : 0;

    if ($customer_id === 0) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED!',
            'message' => 'Error generating PDF files, missing customer ID'
        ];
        header('location:manage_customers.php');
        exit();
    }

    $customers_model = new customers_model();
    $sales_model = new sales_model();
    $common_model = new common_model();


    $company = $common_model->getCompanyDetails();
    $invoices = $customers_model->getActiveInvoicesByCustomer($customer_id);

    $output_dir = __DIR__ . '/invoices/';
    if (!file_exists($output_dir)) {
        mkdir($output_dir, 0755, true);
    }

    $ftp_server = "poweronline-mw.com";
    $ftp_user_name = "smplus";
    $ftp_user_pass = "Grace@2024";
    $ftp_remote_dir = "/powertex/invoices/";

    $ftp_conn = ftp_connect($ftp_server);
    $ftp_login = false;
    if ($ftp_conn) {
        $ftp_login = ftp_login($ftp_conn, $ftp_user_name, $ftp_user_pass);
        ftp_pasv($ftp_conn, true);
    }

    if (count($invoices) > 0) {
        foreach ($invoices as $inv) {
            $invoice_number = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $inv['invoice_number']);
            $filename_local = $output_dir . "invoice_{$invoice_number}.pdf";

            // ✅ Get items for this invoice
            $items = $sales_model->getReceiptItems($inv['invoice_number']);

            $mpdf = new \Mpdf\Mpdf();

                $html = '
                <h2 style="text-align:center;">INVOICE</h2>
                <table width="100%">
                    <tr>
                        <td><strong>INVOICE No.</strong> ' . htmlspecialchars($inv['invoice_number']) . '</td>
                        <td><strong>TPIN No.</strong> 20205854</td>
                    </tr>
                </table>

                <p>
                    <strong>Corporate Office</strong><br>
                    AREA 47/3/1210 HSE68, LILONGWE<br>
                    Tel: 0880 006 822, Hotline: 0883 742 305<br>
                    Email: powertexmw@gmail.com<br>
                    Website: www.powertexmw.com
                </p>

                <p>
                    <strong>Blantyre Office</strong><br>
                    Claim Building, Gly Jones Road<br>
                    Tel: 0887 626 530</p>

                <p>
                    <strong>Branches:</strong><br>
                    Zomba - 0883 742 305 | 
                    Murray Road (LLZ) - 0887 626 529 | 
                    Area 13 (LLZ) - 0887 626 528 | 
                    Limbe - 0887 361 420
                </p>

                <p>
                    <strong>Customer:</strong> ' . htmlspecialchars($inv['customer_name']) . '<br>
                    <strong>Date:</strong> ' . date('d F Y', strtotime($inv['invoice_date'])) . '<br>
                    <strong>Tel/Cell:</strong> ' . htmlspecialchars($inv['customer_contact']) .    '
                </p>

                <table border="1" cellpadding="8" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>QTY</th>
                            <th>DESCRIPTION</th>
                            <th>@ (Unit Price)</th>
                            <th>TOTAL</th>
                        </tr>
                    </thead>
                    <tbody>';

                        foreach ($items as $item) {
                            $html .= '
                            <tr>
                                <td>' . htmlspecialchars($item['quantity']) . '</td>
                                <td>' . htmlspecialchars($item['description']) . '</td>
                                <td style="text-align:right;">' . number_format($item['selling_price'], 2) . '</td>
                                <td style="text-align:right;">' . number_format($item['total'], 2) . '</td>
                            </tr>';
                        }
                            

                        $html = '
                        <div style="font-family: Arial, sans-serif; font-size: 14px; max-width: 1200px; margin: auto;">

                            <!-- Header Section -->
                            <table width="100%" style="border-collapse: collapse; margin-bottom: 15px;">
                                <tr>
                                    <!-- TPIN (left-aligned, middle-aligned to logo) -->
                                    <td style="width: 33%; vertical-align: middle; font-size: 18px;">
                                        <strong>TPIN No.</strong> '.htmlspecialchars($company['tpin']).'
                                    </td>

                                    <!-- Logo (centered) -->
                                    <td style="width: 33%; text-align: center;">
                                        <img src="images/'.htmlspecialchars($company['logo']).'" style="height: 50px;"><br>
                                    </td>

                                    <!-- Invoice Number (top-right corner) -->
                                    <td style="width: 33%; text-align: right; vertical-align: top; font-size: 16px;">
                                        <strong>INVOICE No. </strong> ' . htmlspecialchars($inv['invoice_number']) . '
                                    </td>
                                </tr>
                            </table>

                            <!-- Office Info -->
                            <div style="width:100%; margin-top: 10px;">
                                <table width="100%" style="border-collapse: collapse; font-size: 13px;">
                                    <tr>
                                        <td style="vertical-align: top; width: 33%;">
                                            <strong>Corporate Office</strong><br>
                                            AREA 47/3/1210 HSE68<br>
                                            LILONGWE<br>
                                            Tel: 0 880 006 822, Hotline: 0883 742 305<br>
                                            Email: powertexmw@gmail.com<br>
                                            Website: www.powertexmw.com
                                        </td>
                                        <td style="vertical-align: top; text-align: center; width: 33%;">
                                            <strong>Blantyre Office</strong><br>
                                            Claim Building<br>
                                            Gly Jones Road<br>
                                            Tel: 0 887 626 530<br>
                                            Email: powertexmw@gmail.com
                                        </td>
                                        <td style="vertical-align: top; width: 33%; text-align:right;">
                                            <strong>BRANCHES</strong><br>
                                            Zomba - 0 883 742 305<br>
                                            Murray Road (LLZ) - 0 887 626 529<br>
                                            Area 13 (LLZ) - 0 887 626 528<br>
                                            Limbe - 0 887 361 420
                                        </td>
                                    </tr>
                                </table>
                            </div>

                            <!-- Customer Name -->
                            <p style="font-weight: bold; font-size: 13px; margin-top: 8px; margin-bottom: 2px;">
                                ' . strtoupper(htmlspecialchars($inv['customer_name'])) . '
                            </p>

                            <!-- Thin Line Separator -->
                            <hr style="margin: 3px 0;">

                            <!-- Date (Right-aligned) -->
                            <p style="text-align: right; font-size: 11px; margin-top: 2px; margin-bottom: 8px;">
                                <strong><u>Date:</u></strong><u> ' . date('d M Y', strtotime($inv['invoice_date'])) . '</u>
                            </p>

                            <!-- Items Table -->
                            <table border="1" cellpadding="8" cellspacing="0" width="100%" style="font-size: 13px; border-collapse: collapse;">
                                <thead style="background: #f2f2f2;">
                                    <tr>
                                        <th style="text-align:center;">QTY</th>
                                        <th>DESCRIPTION</th>
                                        <th style="text-align:right;">Selling Price</th>
                                        <th style="text-align:right;">TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>';
                                    foreach ($items as $item) {
                                        $html .= '
                                        <tr>
                                            <td style="width: 10%; text-align: center;">' . htmlspecialchars($item['quantity']) . '</td>
                                            <td style="width: 50%;">' . htmlspecialchars($item['description']) . '</td>
                                            <td style="width: 20%; text-align: right;">' . number_format($item['selling_price'], 2) . '</td>
                                            <td style="width: 20%; text-align: right;">' . number_format($item['total'], 2) . '</td>
                                        </tr>';
                                    }
                                    $html .= 
                                '</tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2"></td>
                                        <td style="text-align:right;"><strong>Subtotal</strong></td>
                                        <td style="text-align:right;"><strong>' . number_format($inv['subtotal'], 2) . '</strong></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"></td>
                                        <td style="text-align:right;"><strong>Plus 16.5% VAT</strong></td>
                                        <td style="text-align:right;"><strong>' . number_format($inv['vat'], 2) . '</strong></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"></td>
                                        <td style="text-align:right;"><strong>Grand Total</strong></td>
                                        <td style="text-align:right;"><strong>' . number_format($inv['grand_total'], 2) . '</strong></td>
                                    </tr>
                                </tfoot>
                            </table>

                            <table width="100%" style="margin-top: 20px; font-size: 12px;">
                                <tr>
                                    <td style="text-align: left;">
                                        <strong>Customer Tel:</strong> ' . htmlspecialchars($inv['customer_contact']) . '
                                    </td>
                                    <td style="text-align: right;">Signature: ';
                                        if (!empty($company['directors_signature']) && file_exists(__DIR__ . '/signatures/' . $company['directors_signature'])) {
                                            $html .= '<img src="signatures/' . $company['directors_signature'] . '" width="80">';
                                        } else {
                                            $html .= 
                                            '____________________________';
                                        }

                                    $html .= '
                                    </td>
                                </tr>
                            </table>';


            $mpdf->WriteHTML($html);
            $mpdf->Output($filename_local, \Mpdf\Output\Destination::FILE);

            if ($ftp_conn && $ftp_login) {
                $remote_file = $ftp_remote_dir . "invoice_{$invoice_number}.pdf";
                $upload = ftp_put($ftp_conn, $remote_file, $filename_local, FTP_BINARY);
                if (!$upload) {
                    error_log("FTP upload failed for file: $filename_local");
                }
            }
        }

        if ($ftp_conn) {
            ftp_close($ftp_conn);
        } 

        http_response_code(200);
        echo json_encode(['status' => 'success']);
        exit();

    } else {
        http_response_code(404);
        echo json_encode(['status' => 'no_invoices']);
        exit();

    }

?>