<?php
    session_start();
    require('fpdf/fpdf.php'); // Include the FPDF library
    require('pdf_header.php');

    include_once 'model/common_model.php';
    $common_model = new common_model();

    // Get logo dynamically
    $logo = $common_model->getlogo();
    $logo_path = 'images/'.$logo;
    $company_name = $common_model->getCompanyName();
    $company_details = $common_model->getCompanyDetails();
    $company_address = $company_details['address'];
    $country = $company_details['country'];
    $phone_number = $company_details['phone_number'];
    $email = $company_details['email'];
    $company_website = $company_details['website'];




    if (isset($_POST['warehouse_stock'])) {
        
        include_once 'model/warehouse_model.php';
        $warehouse_model = new warehouse_model();
        $warehouse_id = $_POST['warehouse_id'];
        $warehouseDetails = $warehouse_model->getwarehouseDetails($warehouse_id);
        $warehouse_stock = $warehouse_model->warehouse_stock($warehouse_id);

        if (!empty($warehouse_stock)) {
            // Initialize PDF
            $pdf = new FPDF();
            $pdf->AddPage();

            addPDFHeader($pdf, $warehouseDetails['warehouse_name'], $logo_path, $company_address, $country, $phone_number, $email, $company_website);


            $pdf->SetFont('Courier', 'B', 10); // Use Courier font

            // Set the font for the card number (left aligned)
            $pdf->SetFont('Courier', '', 10);

            // Set the width of the cell to span the whole line (adjust this as needed)
            $pdf->Cell(90, 10, 'Current Warehouse Stock: ' . $warehouseDetails['warehouse_name'], 0, 0); // Card number aligned to the left

            // Set the font for today's date (right aligned)
            $pdf->SetFont('Courier', '', 10);
            $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R'); // Date aligned to the right
            $pdf->Ln(3); // Add a bit of space after the row    


            // Set thinner border lines
            $pdf->SetLineWidth(0.1); // Reduce line thickness (default is 0.2)

            // Table Header
            $pdf->SetFont('Courier', 'B', 8);
            $pdf->Cell(40, 7, 'Product Name', 1);
            $pdf->Cell(30, 7, 'Category', 1);
            $pdf->Cell(25, 7, 'Unit', 1); // Wider column for description
            $pdf->Cell(40, 7, 'Warehouse', 1, 0, 'L');
            $pdf->Cell(30, 7, 'Opening Stock', 1, 0, 'R');
            $pdf->Cell(25, 7, 'Quantity', 1, 0, 'R');
            $pdf->Ln();

            // Table Rows
            $pdf->SetFont('Courier', '', 8);
            foreach ($warehouse_stock as $transaction) {
                $pdf->Cell(40, 7, $transaction['product_name'], 1);
                $pdf->Cell(30, 7, $transaction['categoryname'], 1);
                $pdf->Cell(25, 7, $transaction['unitname'], 1);
                $pdf->Cell(40, 7, $transaction['warehouse_name'], 1, 0, 'L');
                $pdf->Cell(30, 7, $transaction['opening_stock'], 1, 0, 'R');
                $pdf->Cell(25, 7, $transaction['quantity'], 1, 0, 'R');
                $pdf->Ln();
            }

            $warehouseName = str_replace(' ', '_', $warehouseDetails['warehouse_name']); // replace spaces with underscores
            $dateTime = date('Y-m-d_H-i-s'); // format: 2025-04-16_14-30-55

            $filename = "Warehouse_Stock_{$warehouseName}_{$dateTime}.pdf";

            $pdf->Output('D', $filename);
        } else {
            echo "No transactions found for this Warehouse.";
        }
    } 

    if (isset($_POST['branch_stock'])) {
        
        include_once 'model/branch_model.php';
        $branch_model = new branch_model();
        $branch_id = $_POST['branch_id'];
        $branchDetails = $branch_model->getBranchDetails($branch_id);
        $branch_stock = $branch_model->branch_stock($branch_id);

        if (!empty($branch_stock)) {
            // Initialize PDF
            $pdf = new FPDF();
            $pdf->AddPage();

            addPDFHeader($pdf, $branchDetails['branch_name'], $logo_path, $company_address, $country, $phone_number, $emai, $company_website);


            $pdf->SetFont('Courier', 'B', 10); // Use Courier font

            // Set the font for the card number (left aligned)
            $pdf->SetFont('Courier', '', 10);

            // Set the width of the cell to span the whole line (adjust this as needed)
            $pdf->Cell(90, 10, 'Current Branch Stock: ' . $branchDetails['branch_name'], 0, 0); // Card number aligned to the left

            // Set the font for today's date (right aligned)
            $pdf->SetFont('Courier', '', 10);
            $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R'); // Date aligned to the right
            $pdf->Ln(3); // Add a bit of space after the row    


            // Set thinner border lines
            $pdf->SetLineWidth(0.1); // Reduce line thickness (default is 0.2)

            // Table Header
            $pdf->SetFont('Courier', 'B', 8);
            $pdf->Cell(40, 7, 'Product Name', 1);
            $pdf->Cell(30, 7, 'Category', 1);
            $pdf->Cell(25, 7, 'Unit', 1); // Wider column for description
            $pdf->Cell(40, 7, 'Branch', 1, 0, 'L');
            $pdf->Cell(30, 7, 'Opening Stock', 1, 0, 'R');
            $pdf->Cell(25, 7, 'Quantity', 1, 0, 'R');
            $pdf->Ln();

            // Table Rows
            $pdf->SetFont('Courier', '', 8);
            foreach ($branch_stock as $transaction) {
                $pdf->Cell(40, 7, $transaction['product_name'], 1);
                $pdf->Cell(30, 7, $transaction['categoryname'], 1);
                $pdf->Cell(25, 7, $transaction['unitname'], 1);
                $pdf->Cell(40, 7, $transaction['branch_name'], 1, 0, 'L');
                $pdf->Cell(30, 7, $transaction['opening_stock'], 1, 0, 'R');
                $pdf->Cell(25, 7, $transaction['quantity'], 1, 0, 'R');
                $pdf->Ln();
            }

            $branch_name = str_replace(' ', '_', $branchDetails['branch_name']); // replace spaces with underscores
            $dateTime = date('Y-m-d_H-i-s'); // format: 2025-04-16_14-30-55

            $filename = "Warehouse_Stock_{$branch_name}_{$dateTime}.pdf";

            $pdf->Output('D', $filename);
        } else {
            echo "No transactions found for this Warehouse.";
        }
    } 

    if(isset($_POST['leave_summary'])){
        include_once 'model/employees_model.php';  

        $employees_model = new employees_model();
        $leave_data = $employees_model->getLeaveData();

        if (!empty($leave_data)) {
            $pdf = new FPDF();
            $pdf->AddPage();

            addPDFHeader($pdf, 'Powertex Limited', $logo_path, $company_address, $country, $phone_number, $email, $company_website);


            $pdf->SetFont('Courier', 'B', 10); // Use Courier font

            // Set the font for the card number (left aligned)
            $pdf->SetFont('Courier', '', 10);

            // Set the width of the cell to span the whole line (adjust this as needed)
            $pdf->Cell(90, 10, 'Leave Summary - Powertex Ltd', 0, 0); // Card number aligned to the left

            // Set the font for today's date (right aligned)
            $pdf->SetFont('Courier', '', 10);
            $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R'); // Date aligned to the right
            $pdf->Ln(3); // Add a bit of space after the row    


            // Set thinner border lines
            $pdf->SetLineWidth(0.1); // Reduce line thickness (default is 0.2)
            // Table Header
            $pdf->SetFont('Courier', 'B', 8);
            $pdf->Cell(30, 7, 'Employee Name', 1);
            $pdf->Cell(30, 7, 'Requested', 1, 0, 'C');
            $pdf->Cell(25, 7, 'Allocated', 1, 0, 'C'); // Wider column for description
            $pdf->Cell(30, 7, 'Taken', 1, 0, 'C');
            $pdf->Cell(30, 7, 'Days Remaining', 1, 0, 'C');
            $pdf->Cell(20, 7, 'Usage', 1, 0, 'C');
            $pdf->Cell(25, 7, 'Status', 1, 0, 'C');
            $pdf->Ln();

            $pdf->SetFont('Courier', '', 8);
            foreach ($leave_data as $transaction) {
                // Calculate usage percentage
                $usage_percentage = 0;
                $total_left = 0;
                $percent_left = 100 - $usage_percentage;
                if (!empty($transaction['total_days']) && $transaction['total_days'] > 0) {
                    $usage_percentage = round(($transaction['total_taken'] / $transaction['total_days']) * 100, 2);
                    $total_left = $transaction['total_days'] - $transaction['total_taken'];
                }

                if ($percent_left > 70) {
                    if ($total_left >= 30) {
                        $status_message = 'Plenty of Days';
                    } elseif ($total_left >= 18) {
                        $status_message = 'Comfortable Balance';
                    } else {
                        $status_message = 'Good Balance';
                    }
                } elseif ($percent_left > 50) {
                    $status_message = 'Days Available';
                } elseif ($percent_left > 20) {
                    $status_message = 'Days Depreciating';
                } elseif ($percent_left > 5) {
                    $status_message = 'Few Days Remaining';
                } else {
                    $status_message = 'Days Exhausted';
                }

                // Output PDF cells
                $pdf->Cell(30, 7, $transaction['fullname'], 1);
                $pdf->Cell(30, 7, $transaction['leave_requests_count'], 1, 0, 'C');
                $pdf->Cell(25, 7, $transaction['total_days'], 1, 0, 'C');
                $pdf->Cell(30, 7, $transaction['total_taken'], 1, 0, 'C');
                $pdf->Cell(30, 7, $transaction['total_left'], 1, 0, 'C');
                $pdf->Cell(20, 7, $usage_percentage . '%', 1, 0, 'C');
                $pdf->Cell(25, 7, $status_message, 1, 0, 'L');
                $pdf->Ln();
            }


            $filename = "leave_summary_powertex_" . date('Y-m-d') . ".pdf";

            $pdf->Output('D', $filename);
        }
    }

    if(isset($_POST['low_stock_items'])){
        $pdf = new FPDF();
        $pdf->AddPage();
        include_once 'model/stock_model.php';  

        $stock_model = new stock_model();
        $low_stock_items = $stock_model->getproductsBelowMinStockLevel();

        addPDFHeader($pdf, 'Powertex Limited', $logo_path, $company_address, $country, $phone_number, $email, $company_website);


        $pdf->SetFont('Courier', 'B', 10); // Use Courier font

            // Set the font for the card number (left aligned)
            $pdf->SetFont('Courier', '', 10);

            // Set the width of the cell to span the whole line (adjust this as needed)
            $pdf->Cell(90, 10, 'Overall Products, Items Running out of stock - Powertex Ltd', 0, 0); // Card number aligned to the left

            // Set the font for today's date (right aligned)
            $pdf->SetFont('Courier', '', 10);
            $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R'); // Date aligned to the right
            $pdf->Ln(3); // Add a bit of space after the row    


            // Set thinner border lines
            $pdf->SetLineWidth(0.1); // Reduce line thickness (default is 0.2)
            // Table Header
            $pdf->SetFont('Courier', 'B', 8);
            $pdf->Cell(35, 7, 'Product name', 1);
            $pdf->Cell(20, 7, 'Code', 1, 0, 'C');
            $pdf->Cell(25, 7, 'Category', 1, 0, 'C'); // Wider column for description
            $pdf->Cell(25, 7, 'Unit', 1, 0, 'C');
            $pdf->Cell(30, 7, 'Overall Stock', 1, 0, 'C');
            $pdf->Cell(30, 7, 'Minimum Level', 1, 0, 'C');
            $pdf->Cell(25, 7, 'Status', 1, 0, 'C');
            $pdf->Ln();

            $pdf->SetFont('Courier', '', 8);
            foreach ($low_stock_items as $transaction) {
                // Output PDF cells
                $pdf->Cell(35, 7, $transaction['product_name'], 1);
                $pdf->Cell(20, 7, $transaction['product_code'], 1, 0, 'C');
                $pdf->Cell(25, 7, $transaction['categoryname'], 1, 0, 'C');
                $pdf->Cell(25, 7, $transaction['unitname'], 1, 0, 'C');
                $pdf->Cell(30, 7, $transaction['overall_stock'], 1, 0, 'C');
                $pdf->Cell(30, 7, $transaction['min_order_level'], 1, 0, 'C');
                $pdf->Cell(25, 7, $transaction['product_status'], 1, 0, 'C');
                $pdf->Ln();
            }


            $filename = "powertex_items_running_out_of_stock_" . date('Y-m-d') . ".pdf";

            $pdf->Output('D', $filename);
    }


    if (isset($_POST['overall_stock'])) {
        $pdf = new FPDF();
        $pdf->AddPage();
        include_once 'model/stock_model.php';  

        $stock_model = new stock_model();
        $products = $stock_model->getAllProducts();

        // Add PDF Header
        addPDFHeader($pdf, 'Powertex Limited', $logo_path, $company_address, $country, $phone_number, $email, $company_website);

        $pdf->SetFont('Courier', 'B', 10); // Use Courier font

        // Set the font for the card number (left aligned)
        $pdf->SetFont('Courier', '', 10);

        // Set the width of the cell to span the whole line (adjust this as needed)
        $pdf->Cell(90, 10, 'Overall Products Overview - Powertex Ltd', 0, 0); // Card number aligned to the left

        // Set the font for today's date (right aligned)
        $pdf->SetFont('Courier', '', 10);
        $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R'); // Date aligned to the right
        $pdf->Ln(3); // Add a bit of space after the row    

        // Set thinner border lines
        $pdf->SetLineWidth(0.1); // Reduce line thickness (default is 0.2)
        
        // Table Header
        $pdf->SetFont('Courier', 'B', 8);
        $pdf->Cell(45, 7, 'Product Name', 1);
        $pdf->Cell(15, 7, 'Code', 1, 0, 'C');
        $pdf->Cell(30, 7, 'Branch Stock', 1, 0, 'C'); 
        $pdf->Cell(30, 7, 'Warehouse Stock', 1, 0, 'C');
        $pdf->Cell(35, 7, 'Third party Stock', 1, 0, 'C');
        $pdf->Cell(35, 7, 'Overall Stock', 1, 0, 'C');
        $pdf->Ln();

        $pdf->SetFont('Courier', '', 8);

        // Loop through the products and filter out those with zero stock
        foreach ($products as $transaction) {
            // Only include products with stock greater than 0
            if ((int)$transaction['overall_stock'] > 0) {
                // Determine row background color based on stock levels
                if ((int)$transaction['overall_stock'] == 0) {
                    $pdf->SetFillColor(220, 53, 69); // Bootstrap's bg-danger (Red)
                    $pdf->SetTextColor(255, 255, 255); // White text
                } elseif ((int)$transaction['overall_stock'] <= (int)$transaction['min_order_level']) {
                    $pdf->SetFillColor(255, 193, 7); // Bootstrap's bg-warning (Yellow)
                    $pdf->SetTextColor(0, 0, 0); // Black text
                } else {
                    $pdf->SetFillColor(255, 255, 255); // Default white
                    $pdf->SetTextColor(0, 0, 0); // Default black
                }

                // Output PDF cells with fill set to true
                $pdf->Cell(45, 7, $transaction['product_name'], 1, 0, 'L', true);
                $pdf->Cell(15, 7, $transaction['product_code'], 1, 0, 'C', true);
                $pdf->Cell(30, 7, $transaction['total_branch_stock'], 1, 0, 'C', true);
                $pdf->Cell(30, 7, $transaction['total_warehouse_stock'], 1, 0, 'C', true);
                $pdf->Cell(35, 7, $transaction['total_third_party_stock'], 1, 0, 'C', true);
                $pdf->Cell(35, 7, $transaction['overall_stock'], 1, 0, 'C', true);

                // Move to next line
                $pdf->Ln();
            }
        }

        $filename = "powertex_overall_products_overview_" . date('Y-m-d') . ".pdf";

        // Output the PDF to the browser with the correct headers
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Cache-Control: no-cache, no-store, must-revalidate');
        header('Pragma: no-cache');
        header('Expires: 0');

        $pdf->Output('D', $filename); // D will force the download in most browsers
    }


    if (isset($_POST['third_company_products'])) {

        $pdf = new FPDF();
        $pdf->AddPage();

        include_once 'model/company_model.php';

        $companies_model = new company_model();

        $company_id = $_POST['company_id']; // Ensure this is posted via hidden input
        $company = $companies_model->getThirdPartyCompanyDetails($company_id);
        $products = $companies_model->getProductsByCompanyId($company_id);
        $third_party_company_name = $company['company_name'];

        // Add header
        addPDFHeader($pdf, 'Powertex Limited', $logo_path, $company_address, $country, $phone_number, $email, $company_website);

        $pdf->SetFont('Courier', '', 10);
        $pdf->Cell(90, 10, 'Stock List for - ' . $third_party_company_name, 0, 0);
        $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R');
        $pdf->Ln(5);

        // Set thinner border lines
        $pdf->SetLineWidth(0.1);

        // Column headers
        $pdf->SetFont('Courier', 'B', 8);
        $pdf->Cell(25, 7, 'Product Code', 1, 0, 'C');
        $pdf->Cell(60, 7, 'Product Name', 1, 0, 'L');
        $pdf->Cell(40, 7, 'Category', 1, 0, 'L');
        $pdf->Cell(20, 7, 'Qty', 1, 0, 'C');
        $pdf->Cell(20, 7, 'Min Lvl', 1, 0, 'C');
        $pdf->Cell(25, 7, 'Status', 1, 1, 'C');

        $pdf->SetFont('Courier', '', 8);

        foreach ($products as $product) {
            $product_code = $product['product_code'];
            $product_name = $product['product_name'];
            $category = $product['category'];
            $quantity = (int) $product['quantity'];
            $min_level = (int) $product['min_level'];

            // Determine row background color
            if ($quantity <= 0) {
                $status = 'Out of Stock';
                $pdf->SetFillColor(220, 53, 69); // Red
                $pdf->SetTextColor(255, 255, 255); // White
            } elseif ($quantity <= $min_level) {
                $status = 'Low Stock';
                $pdf->SetFillColor(255, 193, 7); // Yellow
                $pdf->SetTextColor(0, 0, 0); // Black
            } else {
                $status = 'OK';
                $pdf->SetFillColor(255, 255, 255); // White
                $pdf->SetTextColor(0, 0, 0); // Black
            }

            // Output row with fill color
            $pdf->Cell(25, 7, $product_code, 1, 0, 'C', true);
            $pdf->Cell(60, 7, $product_name, 1, 0, 'L', true);
            $pdf->Cell(40, 7, $category, 1, 0, 'L', true);
            $pdf->Cell(20, 7, $quantity, 1, 0, 'C', true);
            $pdf->Cell(20, 7, $min_level, 1, 0, 'C', true);
            $pdf->Cell(25, 7, $status, 1, 1, 'C', true);
        }

        // Clean file name
        $safe_company_name = preg_replace('/[^a-zA-Z0-9_-]/', '_', $third_party_company_name);
        $filename = "stock_list_" . $safe_company_name . "_" . date('Y-m-d') . ".pdf";

        $pdf->Output('D', $filename);
    }


