<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Initiate Stock Transfer | Powertex LTD</title>
            <?php include_once 'css_links.php'; ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">

                    <?php 
                        include 'menu_finance.php';
                        include_once 'model/stock_model.php';
                        include_once 'model/transfers_model.php';
                        include_once 'model/companies_model.php';

                        $stock_model = new stock_model();
                        $transfers_model = new transfers_model();
                        $companies_model = new companies_model();

                        $orderNumber = $_GET['order_number'];
                        
                        $third_party_companies = $companies_model->getThirdpartyCompanies();
                        $destinations = $stock_model->getDestinations();

                        $transfer_items = $transfers_model->getTransferItems($orderNumber);

                        $hasItems = $transfers_model->orderHasItems($orderNumber);

                        $preselected_company_id = '';
                        $preselected_date = '';
                        $preselected_destination_id = '';

                        if ($hasItems && !empty($transfer_items)) {
                            $first_item = $transfer_items[0];
                            $preselected_company_id = $first_item['transfer_from'];
                            $preselected_date = $first_item['transfer_date'];
                            $preselected_destination_id = $first_item['destination_id']; // ⚠️ Make sure your SQL includes this field
                        }



                    ?>

                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Initiate Stock Transfer</small></h3>
                                </div>
                                <div class="title_right"></div>
                            </div>

                            <div class="clearfix"></div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <div class="x_panel">
                                        <div class="x_title">
                                            <h2>New Stock Transfer - Initiate transfer from selected third party company to selected warehouse/branch</h2>
                                            <div class="clearfix"></div>
                                        </div>
                                        <div class="x_content">

                                            <form method="post" action="controllers/transfer_controller.php" class="form-horizontal">
                                                <input type="hidden" name="order_number" value="<?php echo $_GET['order_number']; ?>" />
                                                <input type="hidden" name="action" value="initiate_transfer" />

                                                <div class="form-row">

                                                    <div class="form-group col-md-2">
                                                        <label for="company_id">Company</label>
                                                        <select id="company_id" name="company_id" class="form-control" required <?= $hasItems ? 'disabled' : '' ?>>
                                                            <option value="" selected disabled>-- Select Company --</option>
                                                                <?php foreach($third_party_companies as $company): ?>
                                                                    <option value="<?= $company['company_id']?>" 
                                                                        <?= $hasItems && $company['company_id'] == $preselected_company_id ? 'selected' : '' ?>>
                                                                        <?= $company['company_name']?>
                                                            </option>
                                                            <?php endforeach; ?>

                                                        </select>
                                                        <?php if ($hasItems): ?>
                                                            <input type="hidden" name="company_id" value="<?= $preselected_company_id ?>">
                                                        <?php endif; ?>

                                                    </div>

                                                    <div class="form-group col-md-2">
                                                        <label for="product_id">Product</label>
                                                        <select id="product_id" name="product_id" class="form-control" required>
                                                        <option value="">-- Select Company first --</option>
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-md-1">
                                                        <label for="quantity_remaining">Remaining</label>
                                                        <input type="text" step=".001" name="remaining" id="quantity_remaining" class="form-control" required readonly>
                                                    </div>

                                                    <div class="form-group col-md-1">
                                                        <label for="quantity">Qty</label>
                                                        <input type="number" step=".001" name="quantity" min="1" placeholder="Qty" autocomplete="off" class="form-control" required>
                                                    </div>

                                                    <div class="form-group col-md-2">
                                                        <label for="destination">Destination</label>
                                                        <select id="destination" name="destination" class="form-control" <?= $hasItems ? 'disabled' : 'required'; ?>>
                                                            <option value="" selected disabled>Select Destination</option>
                                                            <?php foreach ($destinations as $destiny): ?>
                                                                <option value="<?= $destiny['destiny_id']?>" 
                                                                    <?= $hasItems && $destiny['destiny_id'] == $preselected_destination_id ? 'selected' : '' ?>>
                                                                    <?= $destiny['destiny_name']?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>

                                                    </div>

                                                    <div class="form-group col-md-2">
                                                        <label for="transfer_date">Date</label>
                                                        <input type="date" id="transfer_date" name="transfer_date" max="<?= date('Y-m-d') ?>" class="form-control" value="<?= $hasItems ? date('Y-m-d', strtotime($preselected_date)) : date('Y-m-d') ?>"  <?= $hasItems ? 'readonly' : 'required' ?>>

                                                    </div>

                                                    <!-- ✅ FIXED: Perfectly Aligned Button -->
                                                    <div class="form-group col-md-2">
                                                        <label>&nbsp;</label> <!-- creates space just like other inputs -->
                                                        
                                                        <?php if ($hasItems): ?>
                                                            <input type="hidden" name="destination" value="<?= $preselected_destination_id ?>">
                                                        <?php endif; ?>

                                                        <button type="submit" class="btn btn-info btn-block" style="height: 38px;">
                                                        Add Item <i class="fa fa-plus-circle"></i>
                                                        </button>
                                                    </div>

                                                    </div>

                                            </form>
                                            <hr>

                                            <!-- Items Table -->
                                            <h4>Transferred Items</h4>
                                            <?php if (empty($transfer_items)): ?>
                                                <div class="alert alert-warning text-center">This order is empty. Please add items to continue.</div>
                                            <?php else: ?>
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <tr class="bg-info text-white" style="text-align: center;">
                                                            <th>Action</th>                                                            
                                                            <th>Date</th>
                                                            <th>Remarks</th>
                                                            <th>Product</th>
                                                            <th>Transfer from</th>
                                                            <th>Destination</th>
                                                            <th>Destination Type</th>
                                                            <th>Quantity</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($transfer_items as $index => $item): ?>
                                                            <tr>
                                                                
                                                                <td style="text-align: center;">
                                                                    <form method="post" action="controllers/transfer_controller.php" class="delete-form" id="delete-form-<?= $item['item_id'] ?>">
                                                                        <input type="hidden" name="action" value="delete_item">
                                                                        <input type="hidden" name="item_id" value="<?= $item['item_id'] ?>" readonly>
                                                                        <input type="hidden" name="transfer_id" value="<?= $item['transfer_id'] ?>" readonly>
                                                                        <input type="hidden" name="company_id" value="<?= $item['transfer_from'] ?>"  readonly>
                                                                        <input type="hidden" name="product_id" value="<?= $item['product_id'] ?>"  readonly>
                                                                        <input type="hidden" name="quantity" value="<?= $item['quantity'] ?>"  readonly>
                                                                        <button type="button"
                                                                                class="btn btn-sm btn-danger delete-item-btn"
                                                                                data-item-id="<?= $item['item_id'] ?>"
                                                                                title="Remove Item">
                                                                            <i class="fa fa-trash"></i>
                                                                        </button>
                                                                    </form>
                                                                </td>

                                                                    <td>
                                                                        <a href="#" data-toggle="modal" data-target="#editDateModal<?= $index ?>" title="Change Transfer Date">
                                                                            <?= date('d M Y',strtotime(htmlspecialchars($item['transfer_date']))) ?>
                                                                        </a>
                                                                    </td>
                                                                <td><?= htmlspecialchars($item['remarks'] ?? '') ?></td>

                                                                
                                                                <td><?= htmlspecialchars($item['product_name']) ?></td>

                                                                <td><?= htmlspecialchars($item['company_name']) ?></td>

                                                                
                                                                <td><?= htmlspecialchars($item['destination']) ?></td>
                                                                <td><?= htmlspecialchars($item['destination_type']) ?></td>

                                                                <td style="text-align: center;">
                                                                    <a href="#" data-toggle="modal" data-target="#editQuantityModal<?= $index ?>" title="Edit Quantity">
                                                                        <?= number_format($item['quantity'], 2) ?>
                                                                    </a>
                                                                </td>

                                                                
                                                                
                                                            </tr>

                                                            
                                                            

                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>

                                                <?php if (!empty($transfer_items)): ?>
                                                <form method="post" action="controllers/transfer_controller.php" class="mt-3">
                                                    <div class="row justify-content-end align-items-center">

                                                        <!-- Driver Name (smaller width) -->
                                                        <div class="col-md-2 col-sm-4 col-3">
                                                            <input type="text" 
                                                                name="driver" 
                                                                class="form-control" 
                                                                placeholder="Driver Name" 
                                                                required>
                                                        </div>

                                                        <!-- Button -->
                                                        <div class="col-auto">
                                                            <button type="submit" class="btn btn-success">
                                                                <i class="fa fa-check-circle"></i> Complete Transfer
                                                            </button>
                                                        </div>
                                                    </div>

                                                    <input type="hidden" name="action" value="finalize_transfer">
                                                    <input type="hidden" name="transfer_id" value="<?= htmlspecialchars($orderNumber) ?>">
                                                </form>

                                            <?php endif; ?>


                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php foreach ($transfer_items as $index => $item): ?>
    <!-- ✅ Edit Quantity Modal -->
    <div class="modal fade" id="editQuantityModal<?= $index ?>" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form method="post" action="controllers/transfer_controller.php" class="modal-content">
                <input type="hidden" name="action" value="update_quantity" readonly>
                <input type="hidden" name="item_id" value="<?= $item['item_id'] ?>" readonly>
                <input type="hidden" name="transfer_id" value="<?= $item['transfer_id'] ?>" readonly>
                <input type="hidden" name="company_id" value="<?= $item['transfer_from'] ?>"  readonly>
                <input type="hidden" name="product_id" value="<?= $item['product_id'] ?>"  readonly>
                <input type="hidden" name="old_quantity" value="<?= $item['quantity'] ?>" readonly>


                <div class="modal-header">
                    <h5 class="modal-title">Edit Quantity</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <div class="form-group">
                        <label>Quantity for: <strong><?= htmlspecialchars($item['product_name']) ?></strong></label>
                        <input type="number" name="new_quantity" class="form-control" min="1" step="0.001"
                               value="<?= $item['quantity'] ?>" required>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Update</button>
                </div>
            </form>
        </div>
    </div>

    <!-- ✅ Edit Date Modal -->
    <div class="modal fade" id="editDateModal<?= $index ?>" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form method="post" action="controllers/transfer_controller.php" class="modal-content">
                <input type="hidden" name="action" value="update_date">
                <input type="hidden" name="transfer_id" value="<?= $item['transfer_id'] ?>">

                <div class="modal-header">
                    <h5 class="modal-title">Edit Transfer Date</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <div class="form-group">
                        <label>New Transfer Date for all items in <strong><?= htmlspecialchars($item['transfer_id']) ?></strong></label>
                        <input type="date" name="new_date" class="form-control"
                               max="<?= date('Y-m-d') ?>"
                               value="<?= date('Y-m-d', strtotime($item['transfer_date'])) ?>" required>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Update</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
<?php endforeach; ?>



                    <?php include_once 'footer.php'; ?>
                </div>
            </div>

            <?php include_once 'libraries.php'; ?>

            <script>
                const productDropdown = document.getElementById('product_id');
                const companyDropdown = document.getElementById('company_id');
                const remainingInput = document.getElementById('quantity_remaining');
                const transferForm = document.querySelector('form');
                const submitBtn = transferForm.querySelector('button[type="submit"]');
                const destinationDropdown = document.getElementById('destination');

                // Auto-load products if company is preselected and dropdown is disabled
                if (companyDropdown.disabled && companyDropdown.value) {
                    fetch(`fetch_products.php?company_id=${companyDropdown.value}`)
                        .then(response => response.json())
                        .then(data => {
                            productDropdown.innerHTML = '<option value="">-- Select Product --</option>';
                            data.forEach(product => {
                                const opt = document.createElement('option');
                                opt.value = product.product_id;
                                opt.textContent = product.product_name;
                                productDropdown.appendChild(opt);
                            });
                        });
                }


                let destinationError = false;

                // Fetch product list when company changes
                companyDropdown.addEventListener('change', function () {
                    const companyId = this.value;
                    productDropdown.innerHTML = '<option>Loading...</option>';

                    fetch(`fetch_products.php?company_id=${companyId}`)
                        .then(response => response.json())
                        .then(data => {
                            productDropdown.innerHTML = '<option value="">-- Select Product --</option>';
                            data.forEach(product => {
                                const opt = document.createElement('option');
                                opt.value = product.product_id;
                                opt.textContent = product.product_name;
                                productDropdown.appendChild(opt);
                            });
                        });

                    remainingInput.value = '';
                    resetRemainingStyle();
                    submitBtn.disabled = false;
                    destinationError = false;
                    resetDestinationStyle();
                });

                // Check quantity and destination on product change
                productDropdown.addEventListener('change', function () {
                    const companyId = companyDropdown.value;
                    const productId = this.value;

                    if (companyId && productId) {
                        fetch(`fetch_company_quantity.php?company_id=${companyId}&product_id=${productId}`)
                            .then(response => response.json())
                            .then(data => {
                                const quantity = parseFloat(data.quantity).toFixed(2);
                                remainingInput.value = quantity;

                                if (quantity == 0) {
                                    highlightRemainingDanger();
                                    submitBtn.disabled = true;
                                } else {
                                    resetRemainingStyle();
                                    validateDestinationProduct();
                                }
                            });
                    } else {
                        remainingInput.value = '';
                        resetRemainingStyle();
                        resetDestinationStyle();
                        submitBtn.disabled = false;
                    }
                });

                // Check if product exists at selected destination
                destinationDropdown.addEventListener('change', validateDestinationProduct);

                function validateDestinationProduct() {
                    const productId = productDropdown.value;
                    const destinationId = destinationDropdown.value;

                    if (productId && destinationId) {
                        fetch(`check_destination_product.php?product_id=${productId}&destination_id=${destinationId}`)
                            .then(res => res.json())
                            .then(data => {
                                if (!data.exists) {
                                    destinationError = true;
                                    highlightDestinationError();
                                    submitBtn.disabled = true;
                                } else {
                                    destinationError = false;
                                    resetDestinationStyle();

                                    if (parseFloat(remainingInput.value) > 0) {
                                        submitBtn.disabled = false;
                                    }
                                }
                            });
                    }
                }

                function highlightRemainingDanger() {
                    remainingInput.classList.add('border-danger');
                    remainingInput.classList.add('text-danger');
                    remainingInput.title = 'This product has zero stock and cannot be transferred.';
                }

                function resetRemainingStyle() {
                    remainingInput.classList.remove('border-danger', 'text-danger');
                    remainingInput.title = '';
                }

                function highlightDestinationError() {
                    destinationDropdown.classList.add('border-danger');
                    destinationDropdown.title = 'This product does not exist in the selected destination.';
                }

                function resetDestinationStyle() {
                    destinationDropdown.classList.remove('border-danger');
                    destinationDropdown.title = '';
                }

                // Final validation on form submit
                transferForm.addEventListener('submit', function (e) {
                    const remainingQty = parseFloat(remainingInput.value);
                    if (remainingQty === 0) {
                        e.preventDefault();
                        alert("Cannot transfer: Product has zero stock.");
                    } else if (destinationError) {
                        e.preventDefault();
                        alert("Cannot transfer: Product does not exist at destination.");
                    }
                });
            </script>
            <script>
                document.addEventListener('DOMContentLoaded', function () {
                    const deleteButtons = document.querySelectorAll('.delete-item-btn');

                    deleteButtons.forEach(button => {
                        button.addEventListener('click', function () {
                            const itemId = this.dataset.itemId;
                            const form = document.getElementById('delete-form-' + itemId);

                            Swal.fire({
                                title: 'Are you sure?',
                                text: "This item will be removed from the transfer list.",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#d33',
                                cancelButtonColor: '#3085d6',
                                confirmButtonText: 'Yes, remove it!'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    form.submit(); // 🔥 Submit the form via POST
                                }
                            });
                        });
                    });
                });
            </script>




        </body>
    </html>
