

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                        include_once 'model/sales_model.php';
                        include_once 'model/customers_model.php';
                        include_once 'model/common_model.php';

                        $common_model = new common_model();
                        $sales_model = new sales_model();
                        $customers_model = new customers_model();
                        $invoice_number = isset($_GET['invoice_number']) ? $_GET['invoice_number'] : '';

                        $invoiceDetails = $sales_model->getInvoiceDetails($invoice_number);
                        $invoice_number = $invoiceDetails['order_number'];
                        $customer_id = $invoiceDetails['customer'];
                        $invoice_items = $sales_model->getReceiptitems($invoice_number);
                        $customerDetails = $customers_model->getCustomerDetails($customer_id);

                        $companyDetails = $common_model->getCompanyDetails();
                        

                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Sales </small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Customer Name -->
                                            <div>
                                                <h2 class="mb-0">Sales Invoice</h2>
                                            </div>
                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0 d-flex align-items-center" style="gap: 8px;">
                                                <?php include 'components/action_buttons.php'; ?>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:void(0);" onclick="history.back();">
                                                        <button class="btn btn-secondary btn-sm">
                                                            <i class="fa fa-arrow-left"></i> Back
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>

                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">  
                                                        <div id="print-area"> 
                                                            <?php if ($invoiceDetails['order_state'] == 3): ?>
                                                                <div style=" position: absolute; top: 220px; left: 300px; right: 0; text-align: left; z-index: 1000; pointer-events: none; ">
                                                                    <span style=" display: inline-block; transform: rotate(-30deg); font-size: 50px; color: rgba(220, 53, 69, 0.3); font-weight: bold; border: 4px dashed rgba(220, 53, 69, 0.4); padding: 10px 40px; background-color: rgba(255, 255, 255, 0.2); ">CANCELLED INVOICE</span>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="x_panel" style="font-family: Arial, sans-serif; font-size: 14px; max-width: 1200px; margin: auto;">
                                                            <!-- Header Section -->
                                                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                                                <div>
                                                                    <p><strong>TPIN No.</strong> 20205854</p>
                                                                </div>
                                                                <div style="text-align: center;">
                                                                    <img src="images/logo.png" alt="Logo" style="height: 60px;"><br>
                                                                </div>
                                                                <div style="text-align: right;">
                                                                    <p><strong>INVOICE NUMBER</strong> No. <?= $invoiceDetails['order_number'] ?></p>
                                                                    
                                                                </div>
                                                            </div>

                                                            <!-- Office Info -->
                                                            <div style="display: flex; justify-content: space-between; font-size: 15px; margin-bottom: 10px;">
                                                                <div>
                                                                    <strong>Corporate Office</strong><br>
                                                                    AREA 47/3/1210 HSE68<br>
                                                                    LILONGWE<br>
                                                                    Tel: 0 880 006 822, Hotline: 0883 742 305<br>
                                                                    Email: powertexmw@gmail.com<br>
                                                                    Website: www.powertexmw.com
                                                                </div>
                                                                <div style="text-align: center;">
                                                                    <strong>Blantyre Office</strong><br>
                                                                    Claim Building<br>
                                                                    Gly Jones Road<br>
                                                                    Tel: 0 887 626 530<br>
                                                                    Email: powertexmw@gmail.com<br>
                                                                    Website: www.powertexmw.com
                                                                </div>
                                                                <div style="text-align: right;">
                                                                    <strong>BRANCHES</strong><br>
                                                                    Zomba - 0 883 742 305<br>
                                                                    Murray Road (LLZ) - 0 887 626 529<br>
                                                                    Area 13 (LLZ) - 0 887 626 528<br>
                                                                    Limbe - 0 887 361 420
                                                                </div>
                                                            </div>

                                                            <hr style="margin: 10px 0;">

                                                            <br>

                                                            <!-- Customer -->
                                                            <p><strong><?= strtoupper($invoiceDetails['customer_name']) ?></strong></p>
                                                            <hr style="margin: 10px 0;">
                                                            <p class="text-right"><strong>Date:</strong> <?= date('d M Y', strtotime($invoiceDetails['orderdate'])) ?></p>

                                                            <!-- Items Table -->
                                                            <table class="table table-bordered" style="width: 100%; font-size: 13px; border-collapse: collapse;">
                                                                <thead style="background: #f2f2f2;">
                                                                    <tr>
                                                                        <th style="text-align:center;">QTY</th>
                                                                        <th>DESCRIPTION</th>
                                                                        <th style="text-align:right;">Selling Price</th>
                                                                        <th style="text-align:right;">TOTAL</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php foreach ($invoice_items as $item): ?>
                                                                    <tr>
                                                                        <td style="text-align:center;"><?= $item['quantity'] ?></td>
                                                                        <td><?= $item['description'] ?></td>
                                                                        <td style="text-align:right;"><?= number_format($item['selling_price'], 2) ?></td>
                                                                        <td style="text-align:right;"><?= number_format($item['total'], 2) ?></td>
                                                                    </tr>
                                                                    <?php endforeach; ?>
                                                                </tbody>
                                                                <tfoot>
                                                                    <tr>
                                                                        <td colspan="2">
                                                                            Customer Tel:Cell: <?php echo $customerDetails['phone_number']?>
                                                                        </td>
                                                                        <td style="text-align:right;"><strong>Subtotal</strong></td>
                                                                        <td style="text-align:right;"><strong><?= number_format($invoiceDetails['subtotal'], 2) ?></strong></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td colspan="2"></td>
                                                                        <td style="text-align: right;"><strong>Plus 16.5% VAT</strong></td>
                                                                        <td style="text-align:right;"><strong><?= number_format($invoiceDetails['total_tax'], 2) ?></strong></td>
                                                                    </tr>
                                                                    
                                                                    <tr>
                                                                        <td colspan="2"></td>
                                                                        <td style="text-align: right;"><strong>Grand Total</strong></td>
                                                                        <td style="text-align:right;"><strong><?= number_format($invoiceDetails['total_bill'], 2) ?></strong></td>
                                                                    </tr>
                                                                </tfoot>
                                                            </table>
                                                            
                                                            <p>
                                                                <strong>Customer Tel:</strong> <?= $customerDetails['phone_number'] ?? 'N/A' ?>
                                                                <span style="margin-left:400px">Signature</span>
                                                                <img src="signatures/<?php echo $companyDetails['directors_signature']?>" width="80">
                                                            </p>
                                                            
                                                        </div>
                                                        
                                                        
                                                     
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>

            <?php
                include_once 'libraries.php';
            ?>
            <script>
                function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
            </script>
        </body>
    </html>
