<?php
include_once 'model/employees_model.php';
$employees_model = new employees_model();

// Get today's month-day
$date_today = date('m-d');

// Fetch birthday employees
$birthday_employees = $employees_model->getTodayBirthdayEmployees($date_today);

// Utility function to calculate age
function calculateAge($dob) {
    if (!$dob || $dob == '0000-00-00') return null;
    $dobObj = new DateTime($dob);
    $now = new DateTime();
    return $dobObj->diff($now)->y;
}

// Utility function to calculate duration in company
function calculateWorkDuration($startDate) {
    if (!$startDate || $startDate == '0000-00-00') return null;
    $start = new DateTime($startDate);
    $now = new DateTime();
    $interval = $start->diff($now);

    $parts = [];
    if ($interval->y > 0) $parts[] = $interval->y . ' yr' . ($interval->y > 1 ? 's' : '');
    if ($interval->m > 0) $parts[] = $interval->m . ' month' . ($interval->m > 1 ? 's' : '');

    return implode(', ', $parts);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Today's Birthdays | Powertex LTD</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once 'css_links.php'; ?>
    <style>
        .birthday-card {
            border: 1px solid #ddd;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            background: #f9f9f9;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.1);
        }
        .birthday-card h4 {
            margin-bottom: 5px;
        }
        .birthday-icon {
            font-size: 20px;
            color: #ff4d4d;
        }
    </style>
</head>
<body class="nav-md">
<div class="container body">
    <div class="main_container">

        <?php include 'menu_finance.php'; ?>

        <!-- Page Content -->
        <div class="right_col" role="main">
            <div class="page-title">
                <div class="title_left">
                    <h3><small>🎂 Employees with Birthdays Today</small></h3>
                </div>
            </div>
            <div class="clearfix"></div>

            <div class="row">
                <div class="col-md-10 offset-md-1 col-sm-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Birthdays - <?= date('F j') ?></h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
    <?php if (!empty($birthday_employees)): ?>
        <div class="row">
            <?php foreach ($birthday_employees as $emp): 
                $age = calculateAge($emp['date_of_birth'] ?? '');
                $worked = calculateWorkDuration($emp['start_date'] ?? '');
            ?>
                <div class="col-md-6">
                    <div class="card shadow-sm" style="border: 1px solid #ccc; border-radius: 8px; overflow: hidden; margin-bottom: 20px;">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">
                                <i class="fa fa-birthday-cake"></i> <?= htmlspecialchars($emp['fullname']) ?>
                            </h5>
                        </div>
                        <div class="card-body">
                            <p><strong>Employee ID:</strong> <?= htmlspecialchars($emp['employee_code']) ?></p>
                            <?php if (!empty($emp['position'])): ?>
                                <p><strong>Post:</strong> <?= htmlspecialchars($emp['position']) ?></p>
                            <?php endif; ?>
                            <?php if ($age): ?>
                                <p><strong>Age:</strong> <?= $age ?> years</p>
                            <?php endif; ?>
                            <?php if ($worked): ?>
                                <p><strong>With Us For:</strong> <?= $worked ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="card-footer text-muted text-center">
                            🎉 Let’s make their day extra special! 🎁
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="alert alert-info text-center" style="padding: 20px; font-size: 16px;">
            <i class="fa fa-info-circle"></i> No birthdays today. 🎉
        </div>
    <?php endif; ?>
</div>

                    </div>
                </div>
            </div>

        </div>
        <!-- /Page Content -->

        <?php include_once 'footer.php'; ?>
    </div>
</div>

<?php include_once 'libraries.php'; ?>
</body>
</html>
