<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                    include 'menu_finance.php';
                    include_once 'model/stock_model.php';

                    $stock_model = new stock_model();
                    $list_products = $stock_model->getproductsBelowMinStockLevel();

                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center">
                                            <!-- Left Title -->
                                            <h2 class="mb-0">Manage Products</h2>

                                            <!-- Center Title -->
                                            <h2 class="mb-0 text-center flex-grow-1">Products below minimum stock level</h2>

                                            <!-- Buttons (Right Aligned) -->
                                            <div class="d-flex gap-2 align-items-center">
                                                <!-- Generate PDF -->
                                                <form action="generate_pdf.php" method="post" class="d-inline mb-0">
                                                    <input type="hidden" name="low_stock_items" value="low_stock_items" readonly>
                                                    <button type="submit" class="btn btn-info d-flex align-items-center">
                                                        Generate&nbsp;PDF&nbsp;<i class="fa fa-file-pdf ms-1"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>

                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">
                                                        <table id="products-table" class="table table-striped table-bordered table-sm" style="width:100%">
                                                            <thead>
                                                                <tr class="bg-warning">
                                                                    <th class="text-left">Product Name</th>
                                                                    <th class="text-center">Product Code</th>
                                                                    <th class="text-center">Category</th>
                                                                    <th class="text-center">Unit</th>
                                                                    <th class="text-center">Overall Stock</th>
                                                                    <th class="text-center">Minimum Level</th>
                                                                    <th class="text-center">Status</th>
                                                                    <th class="text-center" style="width:120px; white-space: nowrap;">Action</th>

                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                    <?php
                                                                        foreach($list_products as $data):
                                                                    ?>
                                                                        <tr style="font-size: 13px; padding: 4px 8px; height: 25px;">
                                                                            <td style="text-align: left;"><?php echo $data['product_name']?></td>
                                                                            <td><?php echo $data['product_code']?></td>
                                                                            <td><?php echo $data['categoryname']?></td>
                                                                            <td><?php echo $data['unitname']?></td>
                                                                            <td style="text-align: center;"><?php echo $data['overall_stock']?></td>
                                                                            <td style="text-align: center;"><?php echo $data['min_order_level']?></td>
                                                                            <td class="<?= $data['product_state'] == 0 ? 'bg-danger text-white' : ($data['product_state'] == 1 ? 'bg-success text-white' : '') ?>">
                                                                                <?= htmlspecialchars($data['product_status']) ?>
                                                                            </td>
                                                                            <td>
                                                                                <a href="product_details.php?product_id=<?php echo $data['product_id']?>">
                                                                                    <button class="btn btn-info btn-sm">Product Details</button>
                                                                                </a>
                                                                                <a rel="facebox" href="edit_product.php?product_id=<?php echo $data['product_id']?>">
                                                                                    <button class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                                                                </a>
                                                                                <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                                <button class="btn btn-info btn-sm">
                                                                                    <i class="fa fa-cog"></i>
                                                                                </button>
                                                                                </a>
                                                                            </td>
                                                                        </tr>
                                                                    <?php
                                                                        endforeach;
                                                                    ?>
                            
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>

            <?php
                include_once 'libraries.php';
            ?>
            <script>
                function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
            </script>
            <script>
                $(document).ready(function () {
                    let table = $('#products-table').DataTable({
                        responsive: true,
                        ordering: true,
                        pageLength: 100,
                        columnDefs: [{
                            targets: -1, // Assuming "Action" is the last column; use correct index if different
                            width: "250px",
                            className: "text-center",
                            orderable: false // Usually actions shouldn't affect sorting
                        }]
                    });

                    // Search across all columns using external input
                    $('#search_query').on('keyup', function () {
                        table.search(this.value).draw();
                    });
                });
            </script>
        </body>
    </html>
