    <!DOCTYPE html>
        <html lang="en">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
                <!-- Meta, title, CSS, favicons, etc. -->
                <meta charset="utf-8">
                <meta http-equiv="X-UA-Compatible" content="IE=edge">
                <meta name="viewport" content="width=device-width, initial-scale=1">
                    <link rel="icon" href="images/favicon.png" type="image/ico" />
                    
                <title>Powertex LTD</title>
                <?php
                    include_once 'css_links.php';
                ?>
                <style>
                    #fullscreen-loader {
                        position: fixed;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100%;
                        background: rgba(0, 0, 0, 0.6);
                        display: none;
                        align-items: center;
                        justify-content: center;
                        z-index: 9999;
                    }

                    .loader-content {
                        color: #fff;
                        text-align: center;
                        font-size: 18px;
                    }

                    .loader-content i {
                        font-size: 50px;
                        margin-bottom: 15px;
                    }
                </style>

                
            </head>

            <body class="nav-md">
                <div class="container body">
                    <div class="main_container">
                
                        <?php
                            include 'menu_finance.php';
                            include_once 'model/customers_model.php';

                            $customers_model = new customers_model();
                            $customers = $customers_model->getCustomers(['Dealer', 'Corporate', 'Individual'], [1,2]);

                            
                            $locations = $common_model->getAllLocations(); 
                            $districts = $common_model->getDistricts(); // <-- NEW
                            $nationalities = $common_model->getNationalities(); // <-- NEW

                        ?>
                        <!-- page content -->
                        <div class="right_col" role="main">
                            <div class="">
                                <div class="page-title">
                                    <div class="title_left">
                                        <h3><small>Customers </small></h3>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <div class="row">
                                    <div class="col-md-12 col-sm-12 ">
                                        <div class="x_panel">
                                            <div class="x_title">
                                                <h2>Manage Customers</h2>
                                                <ul class="nav navbar-right panel_toolbox">
                                                    <li>
                                                        <button class="btn btn-success d-flex align-items-center" 
                                                            data-toggle="modal" data-target="#addCustomerModal"
                                                            style="height: 40px;">
                                                            <i class="fa fa-plus-circle mr-1"></i> Add Customer
                                                        </button>
                                                    </li>
                                                </ul>
                                                <div class="clearfix"></div>
                                            </div>
                                            <div class="x_content">
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div class="card-box table-responsive">
                                                            <table id="customers-table" class="table table-striped table-bordered" style="width:100%">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Customer Name</th>
                                                                        <th>Phone Number</th>
                                                                        <th>Location</th>
                                                                        <th>Type of Customer</th>
                                                                        <th style="text-align: center;">Current Balance</th>
                                                                        <th>Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php
                                                                        foreach($customers as $data):
                                                                    ?>
                                                                    <tr>
                                                                        <td><?php echo $data['customer_name']?></td>
                                                                        <td><?php echo $data['email']?></td>
                                                                        <td><?php echo $data['location']?></td>
                                                                        <td><?php echo $data['type_customer']?></td>
                                                                        <td style="text-align: right;"><?php echo number_format($data['outstanding_balance'],2)?></td>
                                                                        <?php 
                                                                            if($data['customer_state']==1){ ?>

                                                                            

                                                                            <td style="display: flex; gap: 0px; align-items: center;">
                                                                                <?php
                                                                                    if ($data['type_customer'] === 'Individual') {
                                                                                        $url = "customer_account.php?customer_id=" . $data['customer_id'];
                                                                                    } else {
                                                                                        $url = "customer_details.php?customer_id=" . $data['customer_id'];
                                                                                    }
                                                                                    ?>

                                                                                <a href=<?=$url ?>>
                                                                                    <button class="btn btn-info btn-sm">
                                                                                        <i class="fa fa-eye"></i>
                                                                                    </button>
                                                                                </a>
                                                                                
                                                                                <a href="customer_transactions.php?customer_id=<?php echo $data['customer_id']; ?>">
                                                                                    <button class="btn btn-info btn-sm" title="View Transactions">
                                                                                        <i class="fa fa-list"></i>
                                                                                    </button>
                                                                                </a>

                                                                                <form class="email-customer-form" action="email_invoices.php" method="POST" style="margin: 0;">
                                                                                    <input type="hidden" name="customer_id" value="<?php echo $data['customer_id']; ?>">
                                                                                    <button type="submit"
                                                                                            class="btn btn-info btn-sm"
                                                                                            title="Send Email"
                                                                                            data-balance="<?php echo $data['outstanding_balance']; ?>"
                                                                                            data-email="<?php echo htmlspecialchars($data['email']); ?>">
                                                                                        <i class="fa fa-envelope"></i>
                                                                                    </button>
                                                                                </form>


                                                                                

                                                                                    <a href="whatsapp_send_handler.php?customer_id=<?php echo $data['customer_id']; ?>"
                                                                                    class="btn btn-success btn-sm send-whatsapp"
                                                                                    data-balance="<?php echo $data['outstanding_balance']; ?>"
                                                                                    title="Send WhatsApp">
                                                                                        <i class="fab fa-whatsapp"></i>
                                                                                    </a>


                                                                                    
                                                                                    <button class="btn btn-warning btn-sm editCustomerBtn" data-id="<?= $data['customer_id'] ?>" data-name="<?= htmlspecialchars($data['customer_name']) ?>" data-number="<?= $data['phone'] ?>" data-email="<?= $data['email'] ?>" data-gender="<?= $data['gender'] ?>" data-address="<?= $data['customer_address'] ?>" data-location="<?= $data['current_location'] ?>" data-type="<?= $data['type_customer'] ?>" data-location_name=<?= $data['location'] ?> data-nationality_id="<?= $data['nationality'] ?>" data-nationality_name="<?= $data['nationality_name'] ?>" data-state="<?= $data['customer_state'] ?>" data-whatsapp_number="<?= $data['whatsapp_number'] ?>" title="Update Customer Details">
                                                                                        <i class="fa fa-edit"></i>
                                                                                    </button>

                                                                                    
                                                                                    <a href="javascript:void(0);" onclick="showDisabledNotification()" title="Disabled Option">
                                                                                        <button class="btn btn-info btn-sm">
                                                                                            <i class="fa fa-cog"></i>
                                                                                        </button>
                                                                                    </a>
                                                                            </td>
                                                                            <?php
                                                                            }else{ ?>
                                                                                <td>
                                                                                    <div class="d-flex w-100">
                                                                                        <form method="POST" action="controllers/customer_controller.php" class="w-50 pr-1">
                                                                                            <input type="hidden" name="action" value="approve_customer">
                                                                                            <input type="hidden" name="customer_id" value="<?= $data['customer_id'] ?>">
                                                                                            <input type="hidden" name="customer_ty" value="<?= $data['type_customer'] ?>">
                                                                                            <button class="btn btn-success btn-sm w-100" type="submit">
                                                                                                <i class="fa fa-check"></i> Approve
                                                                                            </button>
                                                                                        </form>

                                                                                        <form method="POST" action="controllers/customer_controller.php" class="w-50 pl-1 deny-customer-form">
                                                                                            <input type="hidden" name="action" value="deny_customer">
                                                                                            <input type="hidden" name="customer_id" value="<?= $data['customer_id'] ?>">
                                                                                            <input type="hidden" name="customer_ty" value="<?= $data['type_customer'] ?>">
                                                                                            <button class="btn btn-danger btn-sm w-100" type="button" onclick="confirmDeny(this)">
                                                                                                <i class="fa fa-times"></i> Deny
                                                                                            </button>
                                                                                        </form>
                                                                                    </div>
                                                                                </td>


                                                                            <?php 
                                                                            }
                                                                            ?>


                                                                    </tr>
                                                                    <?php
                                                                        endforeach;
                                                                    ?>
                                                                
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- /page content -->

                        <?php
                            include_once 'footer.php';
                        ?>
                    </div>
                </div>
                <div id="fullscreen-loader">
                    <div class="loader-content">
                        <i class="fas fa-spinner fa-spin"></i>
                        <p>Please wait, generating invoices…</p>
                    </div>
                </div>

                <!-- Edit Customer Modal -->
                <div class="modal fade" id="editCustomerModal" tabindex="-1" role="dialog" aria-labelledby="editCustomerLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <form id="editCustomerForm" method="POST" action="controllers/customer_controller.php">
                            <div class="modal-content">
                                <div class="modal-header bg-warning">
                                    <h5 class="modal-title text-dark" id="editCustomerLabel">Edit Customer Details</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span>&times;</span>
                                    </button>
                                </div>
                        
                                <div class="modal-body row">
                                    <input type="hidden" name="customer_id" id="edit_customer_id">
                                    <input type="hidden" name="action" value="update_customer">

                                    <div class="form-group col-md-6">
                                        <label>Customer Name</label>
                                        <input type="text" class="form-control" name="customer_name" id="edit_customer_name" required>
                                    </div>

                                    

                                    <div class="form-group col-md-6">
                                        <label>Email Address</label>
                                        <input type="email" class="form-control" name="email" id="edit_email">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Contact Number</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">+265</span>
                                            </div>
                                            <input type="text" class="form-control" maxlength="9" minlength="5" name="contact_number" id="edit_contact_number" placeholder="991234567">
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Special Whatsapp Number</label>
                                        <input type="text" class="form-control" name="whatsapp_number" id="edit_whatsapp_number">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Gender</label>
                                        <select class="form-control" name="gender" id="edit_gender">
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Customer Address</label>
                                        <input type="text" class="form-control" name="customer_address" id="edit_customer_address">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Location</label>
                                        <select class="form-control" name="location" id="edit_location">
                                        <!-- Dynamically populate this using PHP or JS -->
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Type of Customer</label>
                                        <select class="form-control" name="type_customer" id="edit_type_customer">
                                            <option value="Retail">Retail</option>
                                            <option value="Wholesale">Wholesale</option>
                                            <option value="Corporate">Corporate</option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Nationality</label>
                                        <select class="form-control" name="nationality" id="edit_nationality">
                                        <!-- Dynamically populate this using PHP or JS -->
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Customer State</label>
                                        <select class="form-control" name="customer_state" id="edit_customer_state">
                                            <option value="1">Active</option>
                                            <option value="0">Inactive</option>
                                        </select>
                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-warning">Update Customer</button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>


                <?php
                    include_once 'libraries.php';
                ?>

                <!-- Modal: Add Customer -->
    <div class="modal fade" id="addCustomerModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                
                <form id="addCustomerForm" method="POST" action="controllers/customer_controller.php">
                    
        <div class="modal-header">
            <h5 class="modal-title">
                <i class="fa fa-user-plus mr-2"></i> Add New Customer
            </h5>
            <button type="button" class="close text-white" data-dismiss="modal">
                <i class="fa fa-times"></i>
            </button>
        </div>

        <div class="modal-body p-4">
            <input type="hidden" name="action" value="add_customer">

            <div class="row">

                <!-- LEFT COLUMN (unchanged) -->
                <div class="col-md-6">
                    <div class="fancy-section-title">Personal Information</div>

                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" name="customer_name" class="form-control" placeholder="Enter customer name" autofocus required>
                        <input type="hidden" name="action" value="add_customer">
                    </div>

                    <div class="form-group">
                    <label>Phone Number</label>

                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text p-1">
                                <img src="images/malawi.png" height="20">
                            </span>
                        </div>
                        <div class="input-group-prepend">
                            <span class="input-group-text">+265</span>
                        </div>
                        <input type="text" name="phone" id="phone" maxlength="9"
                            class="form-control" required placeholder="xxx xxx xxx">
                    </div>

                    <!-- ✅ ERROR BELOW INPUT -->
                    <small id="phonenumberErrorDisplay" class="text-danger d-block mt-1"></small>
                </div>


                    <!-- WhatsApp WITH ICON -->
                    <div class="form-group">
                        <label>WhatsApp (Optional)</label>

                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fab fa-whatsapp text-success"></i>
                                </span>
                            </div>
                            <div class="input-group-prepend">
                                <span class="input-group-text">+</span>
                            </div>
                            <input type="text" name="whatsapp" id="whatsapp" class="form-control"
                                placeholder="if whatsApp number used is different from shared phone number">
                        </div>

                        <!-- ✅ ERROR BELOW INPUT -->
                        <small id="whatsAppNumberErrorDisplay" class="text-danger d-block mt-1"></small>
                    </div>


                    <!-- Email WITH ENVELOPE ICON - NOW MANDATORY -->
                    <div class="form-group">
                        <label>Email</label>

                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fa fa-envelope"></i>
                                </span>
                            </div>
                            <input type="email" name="email" id="email" class="form-control"
                                placeholder="example@email.com">
                        </div>

                        <!-- ✅ ERROR BELOW INPUT -->
                        <small id="emailErrorDisplay" class="text-danger d-block mt-1"></small>
                    </div>


                    <div class="form-group">
                        <label>Gender</label>
                        <select name="gender" class="form-control" required>
                            <option value="">--Select--</option>
                            <option>Male</option>
                            <option>Female</option>
                            <option>Other</option>
                        </select>
                    </div>
                </div>

                <!-- RIGHT COLUMN (rearranged) -->
                <div class="col-md-6">
                    <div class="fancy-section-title">Customer Details</div>

                    <!-- 1. CUSTOMER TYPE (Mandatory) -->
                    <div class="form-group">
                        <label>Customer Type</label>
                        <select name="customer_type" class="form-control" required>
                            <option value="">-- Select Customer Type --</option>
                            <option value="Walk-in">Walk-in Customer</option>
                            <option value="Individual">Individual Credit Customers</option>
                            <option value="Dealer">Dealer</option>
                            <option value="Corporate">Corporate Customer</option>
                        </select>
                    </div>

                    <!-- 2. LOCATION -->
                    <div class="form-group">
                        <label>Location</label>
                        <select name="location" id="locationSelect" class="form-control select2" style="width: 100%;" required>
                            <option value="">-- Select Location --</option>
                            <?php foreach($locations as $loc): ?>
                                <option value="<?= $loc['loc_id'] ?>">
                                    <?= $loc['location_name'] ?>
                                </option>
                            <?php endforeach; ?>
                            <option value="ADD_NEW">➕ Add New Location</option>
                        </select>
                    </div>

                    <!-- NEW LOCATION INPUTS -->
                    <div id="newLocationFields" style="display:none;">
                        <div class="form-group">
                            <label>New Location Name</label>
                            <input type="text" name="new_location_name" class="form-control">
                        </div>

                        <div class="form-group">
                            <label>Select District</label>
                            <select name="new_location_district" class="form-control">
                                <option value="">--Select District--</option>
                                <?php foreach($districts as $d): ?>
                                    <option value="<?= $d['id'] ?>"><?= $d['district'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- 3. NATIONALITY -->
                    <div class="form-group">
                        <label>Nationality</label>
                        <select name="nationality" class="form-control select2">
                            <option value="">-- Select Nationality --</option>
                            <?php foreach ($nationalities as $nationality): ?>
                                <option value="<?= $nationality['id'] ?>">
                                    <?= htmlspecialchars($nationality['country_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- 4. CUSTOMER ADDRESS (optional - moved to bottom) -->
                    <div class="form-group">
                        <label>Customer Address (Optional)</label>
                        <textarea name="customer_address" class="form-control" rows="3"></textarea>
                    </div>

                </div>

            </div>
        </div>

        <div class="modal-footer">
            <button class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            
                            <button type="submit" id="submitButton" class="btn btn-success mr-1" disabled>Submit</button>
        </div>

    </form>


            </div>
        </div>
    </div>
    <script>
document.addEventListener("DOMContentLoaded", function () {
    const buttons = document.querySelectorAll(".send-whatsapp");
    let isProcessing = false;

    buttons.forEach(button => {
        button.addEventListener("click", function (e) {

            const balance = parseFloat(this.dataset.balance || 0);

            // ❌ No balance → block action
            if (isNaN(balance) || balance <= 0) {
                e.preventDefault();
                toastr.error('Customer has no Outstanding invoices', 'FAILED');
                return false;
            }

            // ❌ Already processing → block
            if (isProcessing) {
                e.preventDefault();
                return false;
            }

            // ✅ Lock further clicks
            isProcessing = true;

            // ✅ Show loader
            document.getElementById("fullscreen-loader").style.display = "flex";

            // ✅ Disable all WhatsApp buttons
            buttons.forEach(btn => {
                btn.style.pointerEvents = "none";
                btn.style.opacity = "0.6";
            });
        });
    });
});
</script>



    <script>
function confirmDeny(button) {
    Swal.fire({
        title: 'Confirm Action',
        text: 'Are you sure you want to deny this customer? This action cannot be undone.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, deny',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            button.closest('form').submit();
        }
        // Cancel = do nothing
    });
}
</script>

                <script>
                    $(document).on('click', '.editCustomerBtn', function () {
                        const locationId = $(this).data('location');
                        const locationName = $(this).data('location_name');
                        const currentType = $(this).data('type');
                        const nationalityId = $(this).data('nationality_id');
                        const nationalityName = $(this).data('nationality_name');
                        const allTypes = ['Walk-In', 'Individual Credit Customers', 'Dealer', 'Corporate'];
                        const customerState = $(this).data('state'); // either 1 or 0
                        let contact = $(this).data('number').replace(/^(\+265)/, ''); // strip +265 if present
                        $('#edit_contact_number').val(contact);


                        let stateOptions = '';

                        if (customerState == 1) {
                            stateOptions = `
                                <option selected hidden value="1">Active Customer</option>
                                <option value="0">Deactivate Customer</option>`;
                        } else {
                            stateOptions = `
                                <option selected hidden value="0">Deactivated Customer</option>
                                <option value="1">Activate Customer</option>`;
                        }

                        $('#edit_customer_state').html(stateOptions);

                        // Set default selected location as the first option
                        $('#edit_location').html(`<option selected hidden value="${locationId}">${locationName}</option>`);

                        // ✅ Now this works correctly
                        $('#edit_nationality').html(`<option selected hidden value="${nationalityId}">${nationalityName}</option>`);
                        
                        // Load other locations via AJAX
                        $.ajax({
                            url: 'get_locations.php',
                            method: 'GET',
                            success: function (data) {
                                const options = JSON.parse(data);
                                let locationOptions = '';

                                options.forEach(function (loc) {
                                    if (loc.loc_id != locationId) {
                                        locationOptions += `<option value="${loc.loc_id}">${loc.location_name}</option>`;
                                    }
                                });

                                $('#edit_location').append(locationOptions);
                            }
                        });

                        // Load other nationalities via AJAX
                        $.ajax({
                            url: 'get_nationalities.php',
                            method: 'GET',
                            success: function (data) {
                                const nations = JSON.parse(data);
                                let options = '';
                                nations.forEach(function (nat) {
                                    if (nat.id !== nationalityId) {
                                        options += `<option value="${nat.id}">${nat.nationality}</option>`;
                                    }
                                });
                                $('#edit_nationality').append(options);
                            }
                        });

                        // Populate Type of Customer
                        let typeOptions = `<option selected value="${currentType}">${currentType}</option>`;
                        allTypes.forEach(function(type) {
                            if (type !== currentType) {
                                typeOptions += `<option value="${type}">${type}</option>`;
                            }
                        });
                        $('#edit_type_customer').html(typeOptions);

                        // Populate remaining fields
                        $('#edit_customer_id').val($(this).data('id'));
                        $('#edit_customer_name').val($(this).data('name'));
                        $('#edit_location_name').val($(this).data('location_name'));
                        $('#edit_email').val($(this).data('email'));
                        $('#edit_gender').val($(this).data('gender'));
                        $('#edit_customer_address').val($(this).data('address'));
                        $('#edit_location').val($(this).data('location'));
                        $('#edit_customer_state').val($(this).data('state'));
                        $('#edit_whatsapp_number').val($(this).data('whatsapp_number'));
                        $('#editCustomerModal').modal('show');
                    });

                    
        

                </script>

                <script>
                    function showDisabledNotification() {
                        const type = 'warning';
                        const title = 'Feature Disabled';
                        const message = 'This feature is currently disabled.';

                        toastr[type](message, title);
                    }
                </script>
                <script>
                    $(document).ready(function () {
                        let table = $('#customers-table').DataTable({
                            responsive: true,
                            ordering: true,
                            pageLength: 50,
                            order: [
                                [4, 'desc'], // Order by customer balance (7th column) descending
                                [0, 'asc']   // Then by customer name (1st column) ascending
                            ],
                            columnDefs: [
                                {
                                    targets: -1, // Assuming "Action" is the last column
                                    width: "170px",
                                    className: "text-center",
                                    orderable: false // Disable sorting for the action column
                                }
                            ]
                        });

                        // Search across all columns using external input
                        $('#search_query').on('keyup', function () {
                            table.search(this.value).draw();
                        });
                    });

                    $(document).ready(function () {
                        $('.email-customer-form').on('submit', function (e) {

                            const form   = $(this);
                            const button = form.find('button[type="submit"]');

                            const balance = parseFloat(button.data('balance'));
                            const email   = (button.data('email') || '').trim();

                            // ❌ No balance
                            if (isNaN(balance) || balance <= 0) {
                                e.preventDefault();
                                toastr.error('No outstanding invoices', 'FAILED');
                                return false;
                            }

                            // ❌ No email
                            if (email === '') {
                                e.preventDefault();
                                toastr.error('Customer email address is missing. Please update customer details.', 'FAILED');
                                return false;
                            }

                            // ✅ Prevent double submission
                            if (form.data('submitted')) {
                                e.preventDefault();
                                return false;
                            }
                            form.data('submitted', true);

                            // ✅ Update loader text
                            $('#loader-text').text('Please wait… generating customer invoices');

                            // ✅ Show loader
                            $('#fullscreen-loader').css('display', 'flex');

                            // ✅ Disable button
                            button.prop('disabled', true).css('opacity', '0.6');

                            // Allow form submission
                            return true;
                        });
                    });

                    


                </script>
                <script>
                    $(document).ready(function() {

                        // Init select2 outside modal
                        $('.select2').select2();

                    $('#addCustomerModal').on('shown.bs.modal', function () {
                        
                        $('#addCustomerModal .select2').each(function() {

                            // Destroy old Select2 safely
                            if ($(this).data('select2')) {
                                $(this).select2('destroy');
                            }

                            // Re-init with icons + dropdownParent
                            $(this).select2({
                                dropdownParent: $('#addCustomerModal'),
                                templateResult: formatOption,
                                templateSelection: formatSelection,
                                escapeMarkup: function(m) { return m; } // allow HTML
                            });

                        });

                    });


                    // Template for dropdown list
                    function formatOption(option) {
                        if (!option.id) {
                            return option.text; // placeholder
                        }

                        let icon = $(option.element).data('icon');
                        
                        if (icon) {
                            return $('<span><i class="' + icon + ' mr-2"></i>' + option.text + '</span>');
                        }

                        return option.text;
                    }

                    // Template for selected value
                    function formatSelection(option) {
                        if (!option.id) {
                            return option.text;
                        }

                        let icon = $(option.element).data('icon');

                        if (icon) {
                            return $('<span><i class="' + icon + ' mr-2"></i>' + option.text + '</span>');
                        }

                        return option.text;
                    }



                        // Handle location adding + required validation
                    $('#locationSelect').on('change', function () {
                        var selectedValue = $(this).val();

                        if (selectedValue === 'ADD_NEW') {

                            // Show the new-location fields
                            $('#newLocationFields').show();

                            // Make new location fields mandatory
                            $('input[name="new_location_name"]').attr('required', true);
                            $('select[name="new_location_district"]').attr('required', true);

                        } else {

                            // Hide the fields
                            $('#newLocationFields').hide();

                            // Remove required attribute
                            $('input[name="new_location_name"]').removeAttr('required');
                            $('select[name="new_location_district"]').removeAttr('required');
                        }
                    });


                        // Table search
                        $("#filter_global").on("keyup", function() {
                            var value = $(this).val().toLowerCase();
                            $("#customersTable tbody tr").filter(function() {
                                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                            });
                        });

                    });
                </script>
                <script>
$(document).ready(function() {
    // Check Phone Number
    $('#phone').on('input', function() {
        let phoneNumber = $(this).val().trim();

        // Check if phone number has exactly 9 digits (excluding the +265 part)
        if (phoneNumber.length === 9) {
            // Append +265 to the phone number before sending it to the backend
            let fullPhoneNumber = '+265' + phoneNumber;  // Adding +265 as prefix

            checkIfExists('phone', fullPhoneNumber, '#phone');
        } else {
            // If less than 9 digits, remove error message and reset styles
            $('#phonenumberErrorDisplay').text('');
            $('#phone').removeClass('is-invalid').removeClass('is-valid');
            $('#submitButton').prop('disabled', false); // Enable the submit button if number is incomplete
        }
    });

    // Check WhatsApp Number (OPTIONAL)
$('#whatsapp').on('input', function () {

    let enteredWhatsappNumber = $(this).val().trim();

    // Reset UI
    $('#whatsAppNumberErrorDisplay').text('');
    $(this).removeClass('is-valid is-invalid');

    // ✅ Optional field → do nothing if empty
    if (enteredWhatsappNumber === '') {
        $('#submitButton').prop('disabled', false);
        return;
    }

    // Remove non-digits (spaces, dashes, etc.)
    enteredWhatsappNumber = enteredWhatsappNumber.replace(/\D/g, '');

    // 🌍 Global minimum phone number length (E.164)
    const MIN_PHONE_LENGTH = 7;

    // ❌ Too short → do not validate yet
    if (enteredWhatsappNumber.length < MIN_PHONE_LENGTH) {
        return;
    }

    // ✅ Build international format
    let whatsappNumber = "+" + enteredWhatsappNumber;

    // Now safe to check duplicates
    checkIfExists('whatsapp', whatsappNumber, '#whatsapp');
});


    // Check Email Address
    $('#email').on('input', function () {
    let email = $(this).val().trim();

    // Reset UI state
    $('#emailErrorDisplay').text('');
    $(this).removeClass('is-valid is-invalid');

    // ✅ Email is OPTIONAL → do nothing if empty
    if (email === '') {
        $('#submitButton').prop('disabled', false);
        return;
    }

    // Email format regex
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]{2,}$/;

    // ❌ Only validate format if something is entered
    if (!emailRegex.test(email)) {
        $('#emailErrorDisplay').text('Please enter a valid email address.');
        $(this).addClass('is-invalid');
        $('#submitButton').prop('disabled', true);
        return;
    }

    // ✅ Valid format → check duplication
    checkIfExists('email', email, '#email');
});


    // Function to check if value already exists in the database
    function checkIfExists(fieldType, value, fieldSelector) {
        $.ajax({
            url: 'controllers/customer_controller.php', // PHP controller for checking duplicates
            method: 'POST',
            data: {
                action: 'check_duplicate',  // Action type for the controller
                field_type: fieldType,
                value: value
            },
            success: function(response) {
                // Reset all error messages
                $('#phonenumberErrorDisplay').text('');
                $('#whatsAppNumberErrorDisplay').text('');
                $('#emailErrorDisplay').text('');

                if (response === 'exists') {

                    // Show the error message in the corresponding span below the input field
                    if (fieldType === 'phone') {
                        $('#phonenumberErrorDisplay').text('This phone number already exists!');
                    } else if (fieldType === 'whatsapp') {
                        $('#whatsAppNumberErrorDisplay').text('This WhatsApp number already exists!');
                    } else if (fieldType === 'email') {
                        $('#emailErrorDisplay').text('This email address already exists!');
                    }

                    // Disable the submit button if the value exists
                    $('#submitButton').prop('disabled', true);
                } else {
                    // Value doesn't exist, mark as valid
                    $(fieldSelector).removeClass('is-invalid').addClass('is-valid');
                    // Remove the error message if the value is valid
                    if (fieldType === 'phone') {
                        $('#phonenumberErrorDisplay').text('');
                    } else if (fieldType === 'whatsapp') {
                        $('#whatsAppNumberErrorDisplay').text('');
                    } else if (fieldType === 'email') {
                        $('#emailErrorDisplay').text('');
                    }

                    // Enable the submit button if value doesn't exist
                    $('#submitButton').prop('disabled', false);
                }
            },
            error: function() {
                alert('Error checking the ' + fieldType);
            }
        });
    }
});
</script>








                <?php if (isset($_SESSION['wa_link'])): ?>
                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            Swal.fire({
                                title: 'Customer Notification Ready!',
                                text: 'Click below to open WhatsApp with the invoice details.',
                                icon: 'success',
                                confirmButtonText: '📲 Open WhatsApp',
                                showCancelButton: true,
                                cancelButtonText: 'Dismiss',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.open("<?php echo $_SESSION['wa_link']; ?>", '_blank');
                                }
                            });

                            // Optional: Try auto-open silently for browsers that allow it
                            setTimeout(() => {
                                let w = window.open("<?php echo $_SESSION['wa_link']; ?>", '_blank');
                                if (!w || w.closed || typeof w.closed == 'undefined') {
                                    console.log("Popup blocked. User must click manually.");
                                }
                            }, 1500);
                        });
                    </script>
                    <?php unset($_SESSION['wa_link']); ?>
                <?php endif; ?>



            </body>
        </html>
