<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          <?php
            include 'menu_finance.php';
            include_once 'model/employees_model.php';

            $employees_model = new employees_model();

            $posts = $employees_model->getPosts();
            $departments = $employees_model->getDepartments();

          ?>
          <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="page-title">
                <div class="title_left">
                  <h3><small>Employees </small></h3>
                </div>

                <div class="title_right">
                  <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                    <div class="input-group">
                      <input type="text" class="form-control" placeholder="Search............" id="query">
                    </div>
                  </div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title">
                      <h2>Manage Posts</h2>
                      <ul class="nav navbar-right panel_toolbox">
                        <li>
                          <a class="dropdown-item" rel="facebox" href="new_post.php">
                            <button class="btn btn-info">New Post</button>
                          </a>
                        </li>
                        <li>
                          <a class="dropdown-item" rel="facebox" href="new_department.php">
                            <button class="btn btn-info">New Department</button>
                          </a>
                        </li>
                      </ul>
                      <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                      <div class="row">
                        <div class="col-sm-12">
                          <div class="card-box table-responsive">
                            <table id="postsTable" class="table table-striped table-bordered" style="width:60%;float:left">
                              <thead>
                                <tr>
                                  <th>Title</th>
                                  <th>Department</th>
                                  <th style="text-align: center;">Salary</th>
                                  <th style="text-align: center;">Overtime Rate</th>
                                  <th>Action</th>
                                </tr>
                              </thead>
                              <tbody>
                                <?php
                                  foreach($posts as $post):
                                ?>
                                <tr>
                                  <td><?php echo $post['postname']?></td>
                                  <td><?php echo $post['department_name']?></td>
                                  <td style="text-align: right;"><?php echo number_format($post['gross_salary'],2) ?></td>
                                  <td style="text-align: right;"><?php echo number_format($post['overtime_rate'],2) ?></td>
                                </tr>
                                <?php
                                  endforeach;
                                ?>
                              </tbody>
                            </table>

                            <table id="departmentsTable" class="table table-striped table-bordered" style="width:40%;float:right">
                              <thead>
                                <tr>
                                  <th>Department Name</th>
                                  <th>Date Added</th>
                                  <th>Operator</th>
                                  <th>Action</th>
                                </tr>
                              </thead>
                              <tbody>
                                <?php
                                  foreach($departments as $department):
                                ?>
                                <tr>
                                  <td><?php echo $department['department_name']?></td>
                                  <td><?php echo date('d M, Y',strtotime($department['datecaptured']))?></td>
                                  <td><?php echo $department['operator']?></td>
                                </tr>
                                <?php
                                  endforeach;
                                ?>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->
          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>

      <?php
        include_once 'libraries.php';
      ?>
    </body>
  </html>
