<?php

include_once 'config.php';

class common_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getProcurementModeSetting() {
        $sql = "SELECT value FROM system_settings WHERE setting = 'procurement'";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ? $result['value'] : null;
    }

    public function checkDeliveryNoteCancelRequests(){
        $sql = "SELECT COUNT(*) as total FROM delivery_notes WHERE dn_state = 3";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['total'] > 0) ? 1 : 0;
    }

    public function countDeliveryNoteCancelRequests(){
        $sql = "SELECT COUNT(*) as total FROM delivery_notes WHERE dn_state = 3";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['total'] ?? 0;
    }

    public function getCompanyDetails() {
        $sql = "SELECT
                ss.location,
                ss.logo,
                ll.location_name,
                ss.address,
                ss.address as postal_address,
                ss.physical_location,
                dd.country,
                ss.phone_number,
                ss.company_phon2 as alt_phone,
                ss.email,
                ll.loc_dist as district,
                dd.district as district_name,
                ss.directors_signature,
                ss.tpin,
                ss.website
            FROM 
                settings ss
            LEFT JOIN
                locations ll ON ss.location = ll.loc_id 
            LEFT JOIN
                districts dd ON ll.loc_dist = dd.id
            WHERE ss.id = 1";
    
        $stmt = $this->link ->prepare($sql);
        $stmt->execute();
    
        return $stmt->fetch(PDO::FETCH_ASSOC); // Use fetch() since you're retrieving a single row
    }
    

    public function getLocations($district) {
        $sql = "SELECT loc_id, location_name FROM locations WHERE loc_dist = :district";
    
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':district', $district, PDO::PARAM_STR);
        $stmt->execute();
    
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    

    public function getAllLocations() {
        $sql = "SELECT 
                ll.loc_id, 
                ll.location_name,
                dd.district AS district_name,
                ll.location_state,
                dd.region,
                IF(ll.location_state = 1, 'Active Location', 'Disabled Location') as location_status,
                (
                    SELECT COUNT(*) FROM warehouses w WHERE w.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM branches b WHERE b.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM employees e WHERE e.current_location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM customers c WHERE c.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM third_party_companies t WHERE t.location = ll.loc_id
                ) AS total_usage
            FROM 
                locations ll
            LEFT JOIN
                districts dd ON ll.loc_dist = dd.id
            WHERE 
                ll.location_state = 1
            ORDER BY
                ll.location_name ASC";
    
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
    
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function listLocations() {
        $sql = "SELECT 
                ll.loc_id, 
                ll.location_name,
                dd.district AS district_name,
                ll.location_state,
                dd.region,
                IF(ll.location_state = 1, 'Active Location', 'Disabled Location') as location_status,
                (
                    SELECT COUNT(*) FROM warehouses w WHERE w.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM branches b WHERE b.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM employees e WHERE e.current_location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM customers c WHERE c.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM third_party_companies t WHERE t.location = ll.loc_id
                ) AS total_usage
            FROM 
                locations ll
            LEFT JOIN
                districts dd ON ll.loc_dist = dd.id";
    
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
    
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    

    public function getDistricts() {
        $sql = "SELECT id, district FROM districts ORDER BY district ASC";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function getNationalities() {
        $sql = "SELECT id, country_name, nationality, capital_city, phone_code FROM countries order by country_name ASC";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function addLocation($location_id, $location_name, $district_id) {
        $sql = "INSERT INTO locations (loc_id, location_name, loc_dist, location_state) VALUES (:loc_id, :location_name, :district_id, 1)";
        
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':loc_id', $location_id, PDO::PARAM_STR);
        $stmt->bindParam(':location_name', $location_name, PDO::PARAM_STR);
        $stmt->bindParam(':district_id', $district_id, PDO::PARAM_INT);
        
        return $stmt->execute();
    }
    public function getlogo()
    {
        $sql = "SELECT logo FROM settings WHERE id = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ? $result['logo'] : null;
    }

    public function getMaxLocationId() {
        $sql = "SELECT MAX(id) AS current FROM locations";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        return $result ? $result['current'] : 0;  // Return the max ID or 0 if no result
    }
    public function getCompanyName(){
        $sql = "SELECT company_name FROM settings WHERE id = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result && !empty(trim($result['company_name']))) {
            return $result['company_name'];
        }

   
    return 'COMPANY NAME';
    }

    public function getlocationDetails($loc_id) {
        $sql = "SELECT 
                    ll.loc_id, 
                    ll.location_name,
                    dd.district AS district_name,
                    dd.region,
                    ll.loc_dist,
                    ll.loc_dist,
                    ll.location_state,
                    if(ll.location_state = 1, 'Active Location', 'Disabled Location') as location_status
                FROM 
                    locations ll
                LEFT JOIN 
                    districts dd ON ll.loc_dist = dd.id
                WHERE 
                    ll.loc_id = :loc_id
                LIMIT 1";
    
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':loc_id', $loc_id, PDO::PARAM_STR);
        $stmt->execute();
    
        return $stmt->fetch(PDO::FETCH_ASSOC); // returns a single location detail row
    }

    public function updateLocation($location_id, $location_name, $district, $location_state) {
        $query = "UPDATE locations SET location_name = :location_name, loc_dist = :district, location_state = :location_state WHERE loc_id = :location_id";
                  
        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':location_name', $location_name);
        $stmt->bindParam(':district', $district);
        $stmt->bindParam(':location_state', $location_state);
        $stmt->bindParam(':location_id', $location_id);
    
        return $stmt->execute();
    }

    public function checkleaveRequests() {
   

        $sql = "SELECT COUNT(*) as total FROM leave_requests WHERE leaave_state = 0";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['total'] > 0) ? 1 : 0;
    }

    public function checkEMployeeBirthday($date_today) {
        $sql = "SELECT COUNT(*) as total_bdays 
                FROM employees 
                WHERE DATE_FORMAT(date_of_birth, '%m-%d') = :today 
                AND employee_state = 1";
        
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':today', $date_today, PDO::PARAM_STR);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['total_bdays'] > 0) ? 1 : 0;
    }


    public function countleaveRequets() {
        $sql = "SELECT COUNT(*) as total FROM leave_requests WHERE leaave_state = 0";

        try {
            $stmt = $this->link->prepare($sql);
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            return $result['total'];
        } catch (PDOException $e) {
            // Optionally log the error
            // error_log("Count Leave Requests Error: " . $e->getMessage());
            return 0;
        }
    }

    public function checkLowStockProducts() {
        $sql = "SELECT COUNT(*) as total
            FROM products p
            WHERE (
                IFNULL((
                    SELECT SUM(bs.quantity)
                    FROM branch_products bs
                    WHERE bs.product_id = p.product_id
                ), 0) +
                IFNULL((
                    SELECT SUM(ws.quantity)
                    FROM warehouse_products ws
                    WHERE ws.product_id = p.product_id
                ), 0)
            ) < p.min_order_level
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['total'] > 0) ? 1 : 0;
    }

    public function checkPendingTransferRequest() {
        $sql = "SELECT COUNT(*) as transfers
            FROM 
                stock_transfers_final p
            WHERE
                p.transfer_state = 1
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['transfers'] > 0) ? 1 : 0;
    }

    public function checkProductsoutofStock() {
        $sql = "SELECT COUNT(*) as total
            FROM products p
            WHERE (
                IFNULL((
                    SELECT SUM(bs.quantity)
                    FROM branch_products bs
                    WHERE bs.product_id = p.product_id
                ), 0) +
                IFNULL((
                    SELECT SUM(ws.quantity)
                    FROM warehouse_products ws
                    WHERE ws.product_id = p.product_id
                ), 0)
            ) = 0
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['total'] > 0) ? 1 : 0;
    }

    public function verifyLocation(string $location_id): ?array {
        $stmt = $this->link->prepare("SELECT * FROM locations WHERE loc_id = :location_id LIMIT 1");
        $stmt->bindParam(':location_id', $location_id, PDO::PARAM_STR);
        $stmt->execute();

        $location = $stmt->fetch(PDO::FETCH_ASSOC);
        return $location ?: null;
    }

    

    public function checkUncompletedcashSales() {
        $query = "SELECT
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_cash_sales
                FROM 
                    sales_order so
                LEFT JOIN 
                    payments py ON so.sales_number = py.sale_id
                WHERE 
                    (
                        py.sale_id IS NULL -- No payment made
                        OR (py.sale_id IS NOT NULL AND py.payment_state = 0)
                    )
                    AND so.type = 'Cash Sale'";

        $stmt = $this->link->prepare($query);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }
    
    public function checkUncompletedInvoices() {
        $query = "SELECT
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_invoices
                FROM 
                    sales_order so
                LEFT JOIN 
                    saved_orders ss ON so.sales_number = ss.order_number
                WHERE 
                    ss.order_number IS NULL
                    AND so.type = 'Customer Order'";

        $stmt = $this->link->prepare($query);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }

    

    public function checkforUncompletedThirdCompanyStockTransfers() {
        $query = "SELECT
                    COUNT(DISTINCT sti.transfer_id) AS total_incomplete_transfers
                FROM 
                    stock_transfer_items sti
                LEFT JOIN 
                    stock_transfers_final stf ON sti.transfer_id = stf.transfer_id
                WHERE 
                    stf.transfer_id IS NULL";

        $stmt = $this->link->prepare($query);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }

    public function checkPendingCustomerApprovals() {
        $sql = "SELECT COUNT(*) as total FROM customers WHERE customer_state = 2";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['total'] > 0) ? 1 : 0;
    }

    public function getWarehousesBranches(){
        $sql = "SELECT
                    w.warehouse_id as location_id,
                    w.warehouse_name as name,
                    'Warehouse' as type
                FROM 
                    warehouses w
                WHERE
                    warehouse_state = 1
            UNION ALL
                SELECT 
                    b.branch_id as location_id,
                    b.branch_name as name,
                    'Branch' as type
                FROM 
                    branches b
                WHERE 
                    b.branch_state = 1
            ORDER BY
                name ASC
                ";
            $smtp = $this->link->prepare($sql);
            $smtp->execute();
            $locations = $smtp->fetchAll(PDO::FETCH_ASSOC);
            return $locations;
    }

    public function countNotifications($receiver){
        $sql = "SELECT 
                EXISTS 
                (
                    SELECT 1
                    FROM 
                        notifications
                    WHERE 
                        receiver = :receiver
                        AND notificaton_state = 0
                    ) AS has_notifications";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':receiver', $receiver, PDO::PARAM_INT);
        $stmt->execute();

        return (int) $stmt->fetchColumn(); // returns 1 or 0
    }

    public function addNewLocation($loc_id, $new_location_name, $new_location_district, $location_state) {
        $sql = "INSERT INTO locations (loc_id, location_name, loc_dist, location_state) VALUES (:location_id, :location_name, :loc_dist, :location_state)";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location_id', $loc_id, PDO::PARAM_STR);
        $stmt->bindParam(':location_name', $new_location_name, PDO::PARAM_STR);
        $stmt->bindParam(':loc_dist', $new_location_district, PDO::PARAM_INT);
        $stmt->bindParam(':location_state', $location_state, PDO::PARAM_INT);
        
        if($stmt->execute()){
            return true;
        } else {
            return false;
        }
        
    }

    public function getPermissions($username){
        $sql = "SELECT payments_display, sales_display FROM users WHERE username =:username";
        $smtp = $this->link->prepare($sql);
        $smtp->bindParam(':username', $username, PDO::PARAM_STR);
        $smtp->execute();
        $permission_values = $smtp->fetch();
        return $permission_values;

    }
    
    public function fetchNotificationsData($emp_code){
        $sql = "SELECT 
                    id,
                    sender,
                    receiver,
                    purpose,
                    identifier,
                    message,
                    datecaptured,
                    notificaton_state
                FROM 
                    notifications
                WHERE 
                    receiver = :receiver
                ORDER BY 
                    datecaptured DESC";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':receiver', $emp_code, PDO::PARAM_INT);
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }



        
    
}