<?php
	session_start();
	include 'model/employees_model.php';
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
	
?>

<html>
	<head>
		<title>Leave Management</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
    
	<body>
		<?php
			$employees_model = new employees_model();
            
            $employees = $employees_model->getActiveEmployees();
            $leaves = $employees_model->getLeaves();
		?>
		
		<form action="controllers/leaves_controller.php" method="post">
			
			<center>
				<h2 class="page_titles">LEAVE APPLICATION FORM <i class="fa fa-mug-hot"></i></h2>
				<hr>
					
				<select style="width:320px; height:40px;" autocomplete="off" id="employee_code" name="employee_code" class="form-control" required>
                    <option value="" selected disabled>Select Employee</option>
                    <?php
                        foreach($employees as $employee):
                    ?>
                        <option value="<?php echo $employee['employee_code']?>"><?= $employee['fullname']?></option>
                    <?php 
                        endforeach;
                    ?>
                </select>
                <input type="hidden" readonly name="leave_form_everyone" value="leave_form_everyone">
                <br>

                <input type="text" style="width:320px; height:40px;" placeholder="Select Employee Name" autocomplete="off" id="post" name="post" value="" class="form-control" readonly>
                <br>

                <span style="float:left;margin-left:40px;">Allocated Number of Days</span>
                <input type="text" style="width:320px; height:40px;" autocomplete="off" placeholder="Select Employee Name" id="total_leave_days" name="total_leave_days" value="" class="form-control" readonly>
                <br>

                <span style="float:left;margin-left:40px;">Approved Number of Days</span>
                <input type="text" style="width:320px; height:40px;" autocomplete="off" placeholder="Select Employee Name" id="total_approved_days" name="total_approved_days" value="" class="form-control" readonly>
                <br>

                <span style="float:left;margin-left:40px;">Number of Days Left</span>
                <input type="text" style="width:320px; height:40px;" autocomplete="off" placeholder="Select Employee Name" id="days_left" name="days_left" value="" class="form-control" readonly>
                <br>

                <span style="float:left;margin-left:40px;">Select Type of Leave</span>
                <select name="leave" class="form-control" style="width:320px; height:40px;">
                    <option value="" selected disabled>Select Type of Leave</option>
                    <?php
                        foreach($leaves as $leave):
                    ?>
                        <option value="<?php echo $leave['leave_id']?>"><?php echo $leave['leave_name']?></option>
                    <?php
                        endforeach;
                    ?>
                </select>
                    
                    <!-- Start Date -->
                <span style="float:left;margin-left:40px;">Requested Start Date</span>
                <input type="date" id="requested_start_date" name="requested_start_date" class="form-control" required style="width:320px; height:40px;" min="<?php echo date('Y-m-d'); ?>">
                <br>

                <!-- End Date -->
                <span style="float:left;margin-left:40px;">Requested End Date</span>
                <input type="date" id="requested_end_date" name="requested_end_date" class="form-control" required style="width:320px; height:40px;" min="<?php echo date('Y-m-d'); ?>">
                <span id="date-error-msg" style="color: red; display: none;"></span>
                    <br>


                <!-- Calculated Number of Days -->
                <span style="float:left;margin-left:40px;">Requested Number of Days</span>
                <input type="text" id="requested_num_days" name="requested_num_days" class="form-control" required readonly placeholder="Select Start and End Date" style="width:320px; height:40px;">
                <br>

                <button class="btn btn-success btn-block btn-large" id="saveButton" style="width:322px;font-size: 18px;">
                    APPLY FOR LEAVE <i class="fa fa-save"></i>
                </button>
			</center>		
		</form>
        <script>
    console.log('🧠 Running script directly');

    const startInput = document.getElementById('requested_start_date');
    const endInput = document.getElementById('requested_end_date');
    const daysInput = document.getElementById('requested_num_days');
    const errorMsg = document.getElementById('date-error-msg');
    const saveButton = document.getElementById('saveButton');

    if (!startInput || !endInput || !daysInput || !saveButton) {
        console.error('❌ One or more inputs not found');
    } else {
        function calculateDays() {
            // Reset error state
            errorMsg.style.display = 'none';
            startInput.style.borderColor = '';
            endInput.style.borderColor = '';
            saveButton.disabled = true; // Default to disabled

            if (startInput.value && endInput.value) {
                const startParts = startInput.value.split('-');
                const endParts = endInput.value.split('-');

                const start = new Date(startParts[0], startParts[1] - 1, startParts[2]);
                const end = new Date(endParts[0], endParts[1] - 1, endParts[2]);

                if (isNaN(start.getTime()) || isNaN(end.getTime())) {
                    daysInput.value = '';
                    return;
                }

                if (end >= start) {
                    let count = 0;
                    const current = new Date(start);

                    while (current <= end) {
                        const day = current.getDay();
                        if (day !== 0 && day !== 6) { // 0 = Sunday, 6 = Saturday
                            count++;
                        }
                        current.setDate(current.getDate() + 1);
                    }

                    daysInput.value = count;
                    saveButton.disabled = count === 0; // disable button if no valid days
                } else {
                    daysInput.value = '';
                    errorMsg.textContent = '❌ Start date cannot be after end date.';
                    errorMsg.style.display = 'inline';
                    startInput.style.borderColor = 'red';
                    endInput.style.borderColor = 'red';
                    saveButton.disabled = true;
                }
            } else {
                daysInput.value = '';
                saveButton.disabled = true;
            }
        }

        startInput.addEventListener('input', calculateDays);
        endInput.addEventListener('input', calculateDays);

        // Initial check in case values are pre-filled
        window.addEventListener('DOMContentLoaded', calculateDays);
    }
</script>

        <script>
            document.getElementById('employee_code').addEventListener('change', function () {
                const employeeCode = this.value;

                if (employeeCode) {
                    // Make an AJAX request to fetch employee details
                    fetch(`get_employee_details.php?employee_code=${employeeCode}`)
                        .then(response => response.json())
                        .then(data => {
                            // Check if the data is valid
                            if (data.success) {
                                // Autofill the fields with the data returned
                                document.getElementById('post').value = data.employee.postname;
                                document.getElementById('total_leave_days').value = data.leaveDetails.total_allocated;
                                document.getElementById('total_approved_days').value = data.leaveDetails.total_approved;
                                document.getElementById('days_left').value = data.leaveDetails.total_left;
                            } else {
                                // Handle error if no data is found
                                alert('No data found for the selected employee.');
                            }
                        })
                        .catch(error => {
                            console.error('Error fetching employee details:', error);
                            alert('Error fetching employee details.');
                        });
                }
            });

        </script>

    </body>
</html>



