<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
            <style>
    .table th,
    .table td {
        vertical-align: middle;
    }

    .badge {
        font-size: 90%;
        padding: 0.45em 0.6em;
        border-radius: 0.25rem;
    }

    .table-hover tbody tr:hover {
        background-color: #f1f1f1;
    }
</style>

        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';

                        include_once 'model/transfers_model.php';

                        $transfers_model = new transfers_model();

                        $transfers = $transfers_model->getPendingTransfers();
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Stock/Transfers Management </small></h3>
                                </div>

                                <div class="title_right">
                    
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title">
                                            <h2>Pending Stock Transfers</h2>
                                            <ul class="nav navbar-right panel_toolbox">
                                            </ul>
                                            <div class="clearfix"></div>
                                        </div>
                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="card-box">
                                                        <div class="table-responsive">
                                                            <table class="table table-bordered table-striped table-hover" id="transfers-table">
                                                                <thead class="bg-success text-white">
                                                                    <tr>
                                                                        <th>Date</th>
                                                                        <th>Transfer ID</th>
                                                                        <th>Transfer From</th>
                                                                        <th>Transfer To</th>
                                                                        <th style="text-align: center;">Number of Items</th>
                                                                        <th>Date Captured</th>
                                                                        <th>Operator</th>
                                                                        <th>Transfer State</th>
                                                                        <th>Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php foreach($transfers as $data): ?>
                                                                        <?php
                                                                            // Assign status badge class
                                                                            switch($data['transfer_state']) {
                                                                                case 0:
                                                                                    $badge_class = 'badge badge-danger';
                                                                                    $bg_class = 'bg-danger text-white';
                                                                                    break;
                                                                                case 1:
                                                                                    $badge_class = 'badge badge-warning text-dark';
                                                                                    $bg_class = 'bg-warning text-dark';
                                                                                    break;
                                                                                case 2:
                                                                                    $badge_class = 'badge badge-success';
                                                                                    $bg_class = 'bg-success text-white';
                                                                                    break;
                                                                                case 3:
                                                                                    $badge_class = 'badge badge-secondary';
                                                                                    $bg_class = 'bg-secondary text-white';
                                                                                    break;
                                                                                default:
                                                                                    $badge_class = 'badge badge-light';
                                                                                    $bg_class = 'bg-light text-white';
                                                                            }
                                                                        ?>
                                                                        <tr>
                                                                            <td><?= date('d M Y', strtotime($data['transfer_date'])) ?></td>
                                                                            <td><?= $data['transfer_id'] ?></td>
                                                                            <td><?= $data['source_location'] ?></td>
                                                                            <td><?= $data['destination_name'] ?></td>
                                                                            <td style="text-align: center;"><?= $data['num_products'] ?></td>
                                                                            <td><?= date('d M Y H:i:s', strtotime($data['datecaptured'])) ?></td>
                                                                            <td><?= $data['operator_name'] ?></td>
                                                                            <td class="<?= $bg_class?>">
                                                                                <span class="<?= $badge_class ?>">
                                                                                    <?= strtoupper($data['transfer_status']) ?>
                                                                                </span>
                                                                            </td>
                                                                            <td>
                                                                                <a href="transfer_note.php?order_number=<?= $data['transfer_id'] ?>">
                                                                                    <button class="btn btn-sm btn-info" title="Delivery Note">
                                                                                        <i class="fas fa-clipboard-list"></i>
                                                                                    </button>
                                                                                </a>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endforeach; ?>
                                                                </tbody>
                                                            </table>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>
            <?php
                include_once 'libraries.php';
            ?>
        </body>
    </html>
