<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
            <style>
                /* Set font size and width for Select2 */
                .select2-container .select2-selection {
                    font-size: 18px;   /* Adjust font size */
                    height: 40px; 
                }     /* Optional: height */
                .select2-container .select2-selection {
                    display: block;
                    width: 100%;
                    height: calc(1.5em + .75rem + 2px);
                    font-size: 1rem;
                    font-weight: 400;
                    background-color: #fff;
                    background-clip: padding-box;
                    border: 1px solid #ced4da;
                    border-radius: .25rem;
                    transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
                }

                .select2-container {
                    width: 100% !important;  /* Adjust width */
                }
            </style>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                        include_once 'model/employees_model.php';
                        include_once 'model/common_model.php';

                        $employees_model = new employees_model();
                        $common_model = new common_model();

                        $companyDetails = $common_model->getCompanyDetails();
                        $district = $companyDetails['district'];

                        $employees = $employees_model->getActiveEmployees();
                        $locations = $common_model->getAllLocations();
                        $districts = $common_model->getDistricts();
                        $nationalities = $common_model->getNationalities();
                        $posts = $employees_model->getPosts();
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Employees </small></h3>
                                </div>
                            </div>

                            <div class="clearfix"></div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title">
                                            <h2>Register Employee</h2>
                                            <div class="clearfix"></div>
                                        </div>
                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <form class="form" method="post" action="save_employee.php">
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Full Name</label>
                                                                <input type="text" name="fullname" class="form-control" placeholder="Enter Full Name" required>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>National ID Number</label>
                                                                <input type="text" name="national_id_number" id="national_id_number" maxlength="15" class="form-control" placeholder="National ID Number" required>
                                                                <small id="error-message" style="color: red; display: none;">Only letters and numbers are allowed.</small>
                                                            </div>
                                                        </div>

                                                        <div class="form-row">
                                                            <!-- Phone Number with +265 prepend -->
                                                            <div class="form-group col-md-3">
                                                                <label>Phone Number</label>
                                                                <div class="input-group">
                                                                    <div class="input-group-prepend">
                                                                        <span class="input-group-text">+265</span>
                                                                    </div>
                                                                    <input type="text" name="phone_number" id="phone_number" maxlength="9" minlength="5" class="form-control" placeholder="Phone Number" required>
                                                                </div>
                                                            </div>

                                                            <!-- Email Address -->
                                                            <div class="form-group col-md-3">
                                                                <label>Email Address</label>
                                                                <input type="email" name="email_address" class="form-control" placeholder="Email Address" required>
                                                            </div>

                                                            <!-- Gender -->
                                                            <div class="form-group col-md-6">
                                                                <label>Gender</label>
                                                                <select name="gender" class="form-control" required>
                                                                    <option value="" disabled selected>Select Gender</option>
                                                                    <option value="Male">Male</option>
                                                                    <option value="Female">Female</option>
                                                                </select>
                                                            </div>
                                                        </div>


                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Date of Birth</label>
                                                                <input type="date" name="date_of_birth" class="form-control" max="<?php echo date('Y-m-d') ?>">
                                                            </div>
                                                            
                                                            <div class="form-group col-md-6">
                                                                <label>Current Location</label>
                                                                <select name="location" class="form-control select2" required>
                                                                    <option value="" disabled selected>Select Location</option>
                                                                    <?php foreach ($locations as $location): ?>
                                                                        <option value="<?= $location['loc_id'] ?>"><?= $location['location_name'] ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Home Village</label>
                                                                <input type="text" name="home_village" class="form-control" placeholder="Home Village" required>
                                                            </div>
                                                        
                                                            <div class="form-group col-md-6">
                                                                <label>Home District</label>
                                                                <select name="home_district" class="form-control" required>
                                                                    <option value="" disabled selected>Select District</option>
                                                                    <?php foreach ($districts as $district): ?>
                                                                        <option value="<?= $district['id'] ?>"><?= $district['district'] ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Nationality</label>
                                                                <select name="nationality" class="form-control select2" required>
                                                                    <option value="" disabled selected>Select Nationality</option>
                                                                    <?php foreach ($nationalities as $n): ?>
                                                                        <option value="<?= $n['id'] ?>"><?= $n['country_name'] ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>
                                                        
                                                            <div class="form-group col-md-6">
                                                                <label>Contract Type</label>
                                                                <select name="type_of_contract" class="form-control" id="contractType" required>
                                                                    <option value="" disabled selected>Select Contract Type</option>
                                                                    <option value="Fulltime Contract">Fulltime Contract</option>
                                                                    <option value="Internship">Internship</option>
                                                                    <option value="Voluntary">Voluntary</option>
                                                                    <option value="Part-time Contract">Part-time Contract</option>
                                                                    <option value="Temporary">Temporary</option>
                                                                    <option value="Probation">Probation</option>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Start Date</label>
                                                                <input type="date" name="start_date" class="form-control" max="<?php echo date('Y-m-d') ?>" required>
                                                            </div>
                                                        
                                                            <div class="form-group col-md-6" id="endDateDiv" style="display: none;">
                                                                <label>End Date</label>
                                                                <input type="date" name="end_date" class="form-control" min="<?php echo date('Y-m-d') ?>">
                                                            </div>
                                                        </div>

                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Post Offered</label>
                                                                <select name="post" id="post" class="form-control" required>
                                                                    <option value="" disabled selected>Select Post</option>
                                                                    <?php foreach ($posts as $post): ?>
                                                                        <option value="<?= $post['id'] ?>" data-salary="<?= $post['gross_salary'] ?>" data-department="<?= $post['department_name'] ?>">
                                                                            <?= $post['postname'] ?>
                                                                        </option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>
                                                        
                                                            <div class="form-group col-md-3">
                                                                <label>Gross Salary</label>
                                                                <input type="text" id="salary" name="gross_salary" class="form-control" readonly>
                                                            </div>
                                                        
                                                            <div class="form-group col-md-3">
                                                                <label>Department</label>
                                                                <input type="text" id="department" class="form-control" readonly>
                                                            </div>
                                                        </div>

                                                        <div class="form-group mt-4 text-right">
                                                            <button type="reset" class="btn btn-secondary">Reset</button>
                                                            <button type="submit" class="btn btn-success">Submit</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>
            <?php
                include_once 'libraries.php';
            ?>
            <script>
	            $(function () {
			        $('.select2').select2()
			    });
		    </script>
            <script>
                document.getElementById('contractType').addEventListener('change', function () {
                    const value = this.value;
                    const showTypes = ["Internship", "Part-time Contract", "Temporary", "Probation"];
                    const endDateDiv = document.getElementById('endDateDiv');
                    const endDateInput = endDateDiv.querySelector('input');

                    if (showTypes.includes(value)) {
                        endDateDiv.style.display = 'block';
                        endDateInput.setAttribute('required', 'required');
                    } else {
                        endDateDiv.style.display = 'none';
                        endDateInput.removeAttribute('required');
                        endDateInput.value = '';
                    }
                });


                function timeFunctionLong(input) {
                    setTimeout(function () {
                        input.type = 'text';
                    }, 60000);
                }
            </script>
            <script>
                $(document).ready(function() {
                    $('#post').change(function() {
                        var selectedPost = $(this).find('option:selected');
                        var salary = selectedPost.data('salary');
                        var department = selectedPost.data('department');

                        // Set the values in the corresponding input fields
                        $('#salary').val(salary);
                        $('#department').val(department);
                    });
                });
            </script>
            <script>
                document.getElementById('national_id_number').addEventListener('input', function(event) {
                    var value = this.value;

                    // Check if the value contains any character other than a letter or number
                    if (/[^a-zA-Z0-9]/.test(value)) {
                        // Display error message
                        document.getElementById('error-message').style.display = 'block';
                    } else {
                        // Hide error message when the input is valid
                        document.getElementById('error-message').style.display = 'none';
                    }
                });
            </script>
        </body>
    </html>
