<?php
session_start();
date_default_timezone_set('Africa/Blantyre');

include_once 'model/employees_model.php';
$employees_model = new employees_model();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    function clean_input($data) {
        return htmlspecialchars(trim($data));
    }

    //Generate Employee Code
    $employee_code = $employees_model->getNextEmployeeCode();
    // Collect form data
    $fullname       = clean_input($_POST['fullname']);
    $national_id       = clean_input($_POST['national_id_number']);
    $phone = '+265' . clean_input($_POST['phone_number']);
    $email          = clean_input($_POST['email_address']);
    $gender         = clean_input($_POST['gender']);
    $dob            = isset($_POST['date_of_birth']) ? clean_input($_POST['date_of_birth']) : null;
    $location       = clean_input($_POST['location']);
    $village        = clean_input($_POST['home_village']);
    $district       = clean_input($_POST['home_district']);
    $nationality    = clean_input($_POST['nationality']);
    $contract_type  = clean_input($_POST['type_of_contract']);
    $start_date     = clean_input($_POST['start_date']);
    $end_date       = isset($_POST['end_date']) ? clean_input($_POST['end_date']) : null;
    $post           = clean_input($_POST['post']);
    $salary         = clean_input($_POST['gross_salary']);
    $employee_state = 1;
    $operator       = $_SESSION['sess_employeecode'] ?? 'system';

    $check_email = $employees_model->checkEmailAddress($email);
    $check_nationalID = $employees_model->checkNationalID($national_id);
    
    // Validate required fields
    if (empty($fullname) || empty($phone) || empty($email) || empty($gender) || empty($dob) || empty($location) || empty($post) || empty($start_date) || empty($contract_type)) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Validation Error',
            'message' => 'Please fill in all required fields.'
        ];
        header('Location: manage_employees.php');
        exit();
    }

    if ($check_email > 0) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Validation Error',
            'message' => 'This email address is already used for a different employee.'
        ];
        header('Location: manage_employees.php');
        exit();
    }

    if ($check_nationalID > 0) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Validation Error',
            'message' => 'The National ID Number is already registered for a different employee.'
        ];
        header('Location: manage_employees.php');
        exit();
    }


    
    // Prepare data for model
    $employee_data = [
        'employee_code'   => $employee_code,
        'national_id'     => $national_id,
        'fullname'        => $fullname,
        'phone_number'    => $phone,
        'email_address'   => $email,
        'gender'          => $gender,
        'date_of_birth'   => $dob,
        'current_location'=> $location,
        'home_village'    => $village,
        'home_district'   => $district,
        'nationality'     => $nationality,
        'post'            => $post,
        'start_date'      => $start_date,
        'contract_type'   => $contract_type,
        'gross_salary'    => $salary,
        'end_date'        => $end_date,
        'datecaptured'    => date('Y-m-d H:i:s'),
        'operator'        => $operator,
        'employee_state'  => $employee_state
    ];

    // Save employee
    $saved = $employees_model->saveEmployee($employee_data);

    if ($saved) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'SUCCESS',
            'message' => 'Employee saved successfully.'
        ];
        header('Location: employee_details.php?employee_code=' . urlencode($employee_data['employee_code']));
        exit();
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Failed',
            'message' => 'Failed to save employee.'
        ];
        header('Location: manage_employees.php');
        exit();
    }


    header('Location: manage_employees.php');
    exit(); 
    
} else {
    $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'FAILED!',
        'message' => 'Invalid Server Request'
    ];
    header('Location: manage_employees.php');
    exit();
}
